# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Stock
from median.models import Adresse
from datetime import datetime
import time


class TestModelStock:
    def test_unknown_stock(self):
        """Test d'un stock produit à un emplacement inexistant"""
        with pytest.raises(DoesNotExist):
            Stock.get(adresse="INCONNU", reference="INCONNU")

    def test_create_stock(self):
        """Test création d'un stock produit à un emplacement"""
        stk = Stock()
        stk.reference = "0165146520"
        stk.adresse = "ST1.  2. 12. 16.  1"
        stk.lot = "ABCDS"
        stk.quantite = 12
        stk.date_entree = datetime.now()
        stk.save()
        assert stk.pk > 0
        assert stk.date_entree.strftime("%Y-%m-%d") == time.strftime("%Y-%m-%d")
        stk.delete_instance()

    def test_create_address(self):
        """Test création d'une adresse"""
        adr = Adresse()
        adr.adresse = "ST1.  9. 9. 9.  9"
        adr.etat = "L"
        adr.format = "BOITE PASS"
        adr.magasin = "ST1"
        adr.save()
        assert adr.pk > 0
        adr.delete_instance()

    def test_update_address(self):
        """Test mise à jour d'une adresse"""
        adr = Adresse()
        adr.adresse = "ST1.  9. 9. 9.  9"
        adr.etat = "L"
        adr.format = "BOITE PASS"
        adr.magasin = "ST1"
        adr.save()
        assert adr.pk > 0
        adr.etat = 'O'
        adr.contenant = '1234567'
        adr.update()
        assert adr.contenant == '1234567'
        adr.delete_instance()