from ..base import BaseView, BaseViewException
from peewee import DoesNotExist, IntegrityError
from median.models import Adresse, Stock


class Inventaire(BaseView):
    """Réalise des actions sur le stock"""

    def deplacer_produit(self, source, destination, produit=None):
        """
        Déplace un produit d'une emplacement à un autre, une option permet de vérifier
        que l'emplacement de destination peut avoir le même contenant que l'adresse de départ.
        Plusieurs lignes de stock peuvent être à cette adresse, il faut donc les déplacer aussi

        :param source: Emplacement ou se trouve le produit à l'origine
        :type  source: str
        :param destination: Emplacement ou sera déplacé le produit
        :type  destination: str
        :param produit: Produit a déplacer
        :type  produit: str
        :return: Retourne le nombre de ligne modifiée en base
        :rype: int
        """
        try:
            adr_src = Adresse.get(adresse=source)
        except DoesNotExist:
            raise BaseViewException("l'adresse source n'existe pas")

        try:
            adr_dst = Adresse.get(adresse=destination)
        except DoesNotExist:
            raise BaseViewException("l'adresse destination n'existe pas")

        if adr_src.format != adr_dst.format:
            raise BaseViewException("le format de destination n'est pas le même")
        if adr_dst.etat == 'O':
            raise BaseViewException("L'emplacement de destination est occupé")
        if adr_dst.etat == 'X':
            raise BaseViewException("L'emplacement de destination est bloqué")

        if produit is None:
            raise BaseViewException("Le produit est obligatoire")

        stk_src = Stock.select().where(Stock.adresse==adr_src.adresse,
                                       Stock.reference==produit)
        if not stk_src:
            raise BaseViewException("Pas de stock à l'emplacement source")

        stk_dst = Stock.select().where(Stock.adresse==adr_dst.adresse)
        if stk_dst:
            raise BaseViewException("Il y'a du stock a l'emplacement de destination, "
                                    "il faut au préalable le supprimer")

        # On change l'adresse des mouvements de stock concernés
        # il peut y avoir plusieurs
        q = Stock.update(adresse=destination).where(
            Stock.adresse==source, Stock.reference==produit)
        q.execute()

        # On libère l'adresse source
        a = Adresse.update(etat='L').where(Adresse.adresse==source)
        a.execute()

        # source: si pas de boite vide la .3 avance en .1

        # destination: si boite vide en .1 alors on la déplace en .3

        # On place l'adresse de destination en occupée (c'est peut être déjà le cas.)
        b = Adresse.update(etat='O').where(Adresse.adresse==destination)
        b.execute()

        # Ajout dans l'historique
        # TODO: To be fixed


        return True
