from peewee import IntegerField, CharField, DateTimeField, BooleanField
from median.database import TinyIntegerField
from ..base import BaseModel

PROFILES = [
    'ADMIN', 'ECO-DEX', 'DEENOVA'
    'INFIRMIER', 'INTERNE', 'PHARMACIEN',
    'PREPARATEUR', 'TECH',
]


class User(BaseModel):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    username = CharField(
        unique=True, column_name='x_user')
    password = CharField(
        column_name='x_passwd')
    profil = CharField(
        column_name='x_profil')
    description = CharField(
        column_name='x_desc')
    service = CharField(
        column_name='x_service')
    login = CharField(
        column_name='x_login', default='')
    badge = CharField(
        column_name='x_badge', default='')
    date_creation = DateTimeField(
        column_name='x_tcreat', default='0000-00-00 00:00:00')
    date_last_login = DateTimeField(
        column_name='x_tlogin', default='0000-00-00 00:00:00')
    droit_inventaire = BooleanField(
        column_name='x_inventaire', default=False)
    droit_stupefiant = BooleanField(
        column_name='x_astup', default=False)
    email = CharField(
        column_name='x_email', max_length=320, default='')
    import_flag = TinyIntegerField(
        column_name='x_import_flag', default=0)
    maintenance = TinyIntegerField(
        column_name='x_maintenance', default=0)

    class Meta:
        table_name = 'f_user'


class Profil(BaseModel):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    profil = CharField(
        column_name='x_profil', max_length=20)
    ressource = CharField(
        column_name='x_resrc', max_length=50)
    visu = TinyIntegerField(
        column_name='x_visu', default=0)
    edit = TinyIntegerField(
        column_name='x_edit', default=0)

    class Meta:
        table_name = 'f_profil'
        indexes = (
            (('x_profil', 'x_resrc'), True),
        )

# TODO: add table f_user_profil to store the default profil and the profil defined by the customer
