from peewee import AutoField, CharField, IntegerField, BooleanField
from peewee import SQL
from ..base import BaseModel

MAG_ECO_TYPE_LIST = [
    ('T', 'Cutting'),  # Tampon
    ('C', 'Picking'),  # Cueillette
    ('R', 'Return'),   # Retour
    ('A', 'Astus'),    # Astus
    ('L', 'Riedl'),    # Riedl (GPI)
]

MAG_ECO_TYPE = [m[0] for m in MAG_ECO_TYPE_LIST]


class Magasin(BaseModel):

    pk = AutoField(column_name="x_pk", primary_key=True)
    mag = CharField(
        column_name="x_mag", unique=True, null=True, constraints=[SQL("DEFAULT ''")]
    )
    type_mag = CharField(
        column_name="x_type_mag", null=True, constraints=[SQL("DEFAULT ''")]
    )
    dim_2 = IntegerField(
        column_name="x_dim_2", null=True, constraints=[SQL("DEFAULT 0")]
    )
    dim_3 = IntegerField(
        column_name="x_dim_3", null=True, constraints=[SQL("DEFAULT 0")]
    )
    dim_4 = IntegerField(
        column_name="x_dim_4", null=True, constraints=[SQL("DEFAULT 0")]
    )
    dim_5 = IntegerField(
        column_name="x_dim_5", null=True, constraints=[SQL("DEFAULT 0")]
    )
    lib_2 = CharField(column_name="x_lib_2", null=True, constraints=[SQL("DEFAULT ''")])
    lib_3 = CharField(column_name="x_lib_3", null=True, constraints=[SQL("DEFAULT ''")])
    lib_4 = CharField(column_name="x_lib_4", null=True, constraints=[SQL("DEFAULT ''")])
    lib_5 = CharField(column_name="x_lib_5", null=True, constraints=[SQL("DEFAULT ''")])
    nb_dim = IntegerField(
        column_name="x_nb_dim", null=True, constraints=[SQL("DEFAULT 0")]
    )

    # /!\ FIELD DEFINED AS UNUSED /!\
    # bmp = CharField(column_name="x_bmp", null=True, constraints=[SQL("DEFAULT ''")])
    # compo_x = IntegerField(
    #     column_name="x_compo_x", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # compo_y = IntegerField(
    #     column_name="x_compo_y", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # emp_res = BooleanField(
    #     column_name="x_emp_res", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # statique = BooleanField(
    #     column_name="x_statique", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # pds_max = IntegerField(
    #     column_name="x_pds_max", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # dim_pds = IntegerField(
    #     column_name="x_dim_pds", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # multiref = BooleanField(
    #     column_name="x_multiref", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # parcours = CharField(
    #     column_name="x_parcours", null=True, constraints=[SQL("DEFAULT ''")]
    # )
    # palettier = BooleanField(
    #     column_name="x_palettier", null=True, constraints=[SQL("DEFAULT 0")]
    # )
    # armoire = CharField(column_name="x_armoire", constraints=[SQL("DEFAULT ''")])
    # dest = CharField(column_name="x_dest", constraints=[SQL("DEFAULT ''")])
    # tampon = BooleanField(column_name="x_tampon", constraints=[SQL("DEFAULT 0")])
    # adr_tampon = CharField(
    #     column_name="x_adr_tampon", null=True, constraints=[SQL("DEFAULT ''")]
    # )
    # coef_aut = IntegerField(column_name="x_coef_aut", constraints=[SQL("DEFAULT 1")])
    eco_type = CharField(column_name="x_eco_type", constraints=[SQL("DEFAULT ''")])
    id_zone = IntegerField(
        column_name="x_id_zone", constraints=[SQL("DEFAULT 1")])
    id_robot = IntegerField(
        column_name='x_id_robot', constraints=[SQL("DEFAULT 1")])
    split_liste = BooleanField(
        column_name="x_split_liste", null=True, constraints=[SQL("DEFAULT 0")]
    )

    class Meta:
        table_name = "f_mag"
        indexes = (
            (('x_mag',), True)
        )

    def save(self, force_insert=False, only=None):
        """Enforce control on each information passed"""
        if self.eco_type not in MAG_ECO_TYPE:
            raise ValueError('Bad eco type!')
        if self.type_mag is None:
            raise ValueError('Type mag is required')
        return super().save(force_insert, only)


class Espace(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    poste = CharField(
        column_name='x_poste', null=True, constraints=[SQL("DEFAULT ''")])
    mag = CharField(
        column_name='x_mag', null=True, constraints=[SQL("DEFAULT ''")])
    alloc = BooleanField(
        column_name='x_alloc', null=True, constraints=[SQL("DEFAULT 0")])
    service = BooleanField(
        column_name='x_service', null=True, constraints=[SQL("DEFAULT 0")])

    # /!\ FIELD DEFINED AS UNUSED /!\
    # gest = CharField(
    #     column_name='x_gest', null=True, constraints=[SQL("DEFAULT ''")])
    # sub_gest = CharField(
    #     column_name='x_sub_gest', null=True, constraints=[SQL("DEFAULT ''")])
    # pos_aff = IntegerField(
    #     column_name='x_pos_aff', null=True, constraints=[SQL("DEFAULT 0")])
    # id_mag = CharField(
    #     column_name='x_id_mag', null=True, constraints=[SQL("DEFAULT ''")])
    # bouche = CharField(
    #     column_name='x_bouche', null=True, constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_espace'
        indexes = (
            (('x_poste', 'x_mag'), True),
            (('x_mag'), False)
        )

    # TODO: Check id poste or mag exists


class Adresse(BaseModel):

    pk = AutoField(column_name="x_pk", primary_key=True)
    adresse = CharField(
        column_name="x_adr", null=True, constraints=[SQL("DEFAULT ''")]
    )
    etat = CharField(column_name="x_etat", null=True, constraints=[SQL("DEFAULT ''")])
    format = CharField(
        column_name="x_format", null=True, constraints=[SQL("DEFAULT ''")]
    )
    magasin = CharField(column_name="x_mag", null=True, constraints=[SQL("DEFAULT ''")])
    contenant = CharField(column_name="x_contenant", constraints=[SQL("DEFAULT ''")])
    bloque = BooleanField(column_name="x_bloque", constraints=[SQL("DEFAULT 0")])
    stupefiant = BooleanField(
        column_name="x_stup", null=True, constraints=[SQL("DEFAULT 0")]
    )
    quantite_posage = IntegerField(
        column_name="x_qte_posage", null=True, constraints=[SQL("DEFAULT 0")]
    )
    nouvelle_quantite_posage = IntegerField(
        column_name="x_nouv_qte_posage", null=True, constraints=[SQL("DEFAULT 0")]
    )
    emplacement = CharField(
        column_name="x_emplacement", null=True, constraints=[SQL("DEFAULT ''")]
    )
    nouvel_emplacement = CharField(
        column_name="x_nouv_emplacement", null=True, constraints=[SQL("DEFAULT ''")]
    )
    classe = CharField(
        column_name="x_classe", null=True, constraints=[SQL("DEFAULT ''")]
    )
    dim_x = IntegerField(
        column_name="x_dim_x", null=True, constraints=[SQL("DEFAULT 0")]
    )
    dim_y = IntegerField(
        column_name="x_dim_y", null=True, constraints=[SQL("DEFAULT 0")]
    )
    princ = BooleanField(
        column_name="x_princ", null=True, constraints=[SQL("DEFAULT 0")]
    )
    adr_topo = CharField(
        column_name="x_adr_topo", null=True, constraints=[SQL("DEFAULT ''")]
    )
    serial = CharField(column_name="x_serial", constraints=[SQL("DEFAULT ''")])
    nb_div = IntegerField(
        column_name="x_nb_div", null=True, constraints=[SQL("DEFAULT 0")]
    )
    service = BooleanField(
        column_name="x_service", null=True, constraints=[SQL("DEFAULT 0")]
    )
    bloque_reappro = BooleanField(
        column_name="x_bloque_reappro", constraints=[SQL("DEFAULT 0")]
    )

    class Meta:
        table_name = "f_adr"
        indexes = (
            (('x_adr',), True)
        )


class Compteur(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    cle = CharField(
        column_name='x_cle', constraints=[SQL("DEFAULT ''")])
    val = IntegerField(
        column_name='x_val', constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_compteur'
        indexes = (
            (('x_cle',), True)
        )


class MagasinService(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    mag = CharField(
        column_name='x_mag', max_length=3, null=True,
        constraints=[SQL("DEFAULT ''")])
    dest = CharField(
        column_name='x_dest', max_length=30, null=True,
        constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_mag_dest'
        indexes = (
            (('x_mag', 'x_dest'), True),
        )

class Zone(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    zone = CharField(
        column_name='x_zone', max_length=20, null=True,
        constraints=[SQL("DEFAULT ''")])
    appro = IntegerField(
        column_name='x_appro', constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_zone'
        indexes = (
            (('x_zone'), True),
        )
        
class ZoneMag(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    zone = CharField(
        column_name='x_zone', max_length=20, null=True,
        constraints=[SQL("DEFAULT ''")])
    mag = CharField(
        column_name='x_mag', max_length=3, null=True,
        constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_zonemag'
        indexes = (
            (('x_zone', 'x_mag'), True),
        )
