from peewee import (
    AutoField,
    CharField,
    IntegerField,
    FloatField,
    BooleanField,
    DateTimeField,
    DateField,
    TextField
)
from peewee import SQL
from ..base import BaseModel

MODE_NOMINATIF = [
    'NOMINATIF',
    'EXOTIQUE',
]

FUSION_SORTIE_LOT = [
    'SORTIE DE LOTS',
]

FUSION_SORTIE_PERIME = [
    'SORTIE DE PERIMES',
]


class FListeError(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    liste = CharField(
        max_length=60, column_name='x_liste')
    mode = CharField(
        max_length=1, column_name='x_mode')
    message = TextField(
        column_name='x_message')

    class Meta:
        table_name = 'f_liste_error'
        indexes = (
            (('x_liste', 'x_mode'), True),
        )


class FItem(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    liste = CharField(
        column_name='x_liste', null=True, constraints=[SQL("DEFAULT ''")])
    mode = CharField(
        column_name='x_mode', null=True, constraints=[SQL("DEFAULT ''")])
    item = CharField(
        column_name='x_item', null=True, constraints=[SQL("DEFAULT ''")])
    reference = CharField(
        column_name='x_ref', null=True, constraints=[SQL("DEFAULT ''")])
    qte_dem = FloatField(
        column_name='x_qte_dem', null=True, constraints=[SQL("DEFAULT 0.000")])
    qte_serv = FloatField(
        column_name='x_qte_serv', null=True, constraints=[SQL("DEFAULT 0.000")])
    lot = CharField(
        column_name='x_lot', null=True, constraints=[SQL("DEFAULT ''")])
    # admin = CharField(
    #     column_name='x_admin', null=True, constraints=[SQL("DEFAULT ''")])
    tperemp = DateTimeField(
        column_name='x_tperemp', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # is_kit = BooleanField(
    #     column_name='x_is_kit', null=True, constraints=[SQL("DEFAULT 0")])
    # deroule = BooleanField(
    #     column_name='x_deroule', null=True, constraints=[SQL("DEFAULT 0")])
    # kit = CharField(
    #     column_name='x_kit', null=True, constraints=[SQL("DEFAULT ''")])
    # adr_pref = CharField(
    #     column_name='x_adr_pref', null=True, constraints=[SQL("DEFAULT ''")])
    # go_libre = BooleanField(
    #     column_name='x_go_libre', null=True, constraints=[SQL("DEFAULT 0")])
    dest = CharField(
        column_name='x_dest', null=True, constraints=[SQL("DEFAULT ''")])
    # tquarant = DateTimeField(
    #     column_name='x_tquarant', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # user = CharField(
    #     column_name='x_user', null=True, constraints=[SQL("DEFAULT ''")])
    # format_p = CharField(
    #     column_name='x_format_p', null=True, constraints=[SQL("DEFAULT ''")])
    # nb_div = IntegerField(
    #     column_name='x_nb_div', null=True, constraints=[SQL("DEFAULT 0")])
    etat = CharField(
        column_name='x_etat', null=True, constraints=[SQL("DEFAULT ''")])
    # priu = FloatField(
    #     column_name='x_prix_u', null=True, constraints=[SQL("DEFAULT 0.000")])
    # ret_outi = BooleanField(
    #     column_name='x_ret_outi', null=True, constraints=[SQL("DEFAULT 0")])
    info = CharField(
        column_name='x_info', null=True, constraints=[SQL("DEFAULT ''")])
    # urgent = BooleanField(
    #     column_name='x_urgent', null=True, constraints=[SQL("DEFAULT 0")])
    # cde_hs = IntegerField(
    #     column_name='x_cde_hs', null=True, constraints=[SQL("DEFAULT 0")])
    # interface = CharField(
    #     column_name='x_interface', constraints=[SQL("DEFAULT ''")])
    # date_dem = CharField(
    #     column_name='x_date_dem', null=True, constraints=[SQL("DEFAULT ''")])
    # heure_dem = CharField(
    #     column_name='x_heure_dem', null=True, constraints=[SQL("DEFAULT ''")])
    # lib_unite = CharField(
    #     column_name='x_lib_unite', null=True, constraints=[SQL("DEFAULT ''")])
    # typ_dem = CharField(
    #     column_name='x_typ_dem', null=True, constraints=[SQL("DEFAULT ''")])
    # num_mag = CharField(
    #     column_name='x_num_mag', null=True, constraints=[SQL("DEFAULT ''")])
    # dt_trait = CharField(
    #     column_name='x_dt_trait', null=True, constraints=[SQL("DEFAULT ''")])
    # h_trait = CharField(
    #     column_name='x_h_trait', null=True, constraints=[SQL("DEFAULT ''")])
    # num_dem = FloatField(
    #     column_name='x_num_dem', null=True, constraints=[SQL("DEFAULT 0")])
    # qte_disp = FloatField(
    #     column_name='x_qte_disp', null=True, constraints=[SQL("DEFAULT 0.000")])
    # d_recep = DateField(
    #     column_name='x_d_recep', null=True, constraints=[SQL("DEFAULT '0000-00-00'")])
    # four = CharField(
    #     column_name='x_four', null=True, constraints=[SQL("DEFAULT ''")])
    # contenant = CharField(
    #     column_name='x_contenant', null=True, constraints=[SQL("DEFAULT ''")])
    # magh2 = BooleanField(
    #     column_name='x_magh2', constraints=[SQL("DEFAULT 0")])
    num_ipp = CharField(
        column_name='x_num_ipp', constraints=[SQL("DEFAULT ''")])
    num_sej = CharField(
        column_name='x_num_sej', constraints=[SQL("DEFAULT ''")])
    # cause_non_delivrance = CharField(
    #     column_name='x_cause_non_delivrance', null=True, constraints=[SQL("DEFAULT ''")])
    # adr_tampon = CharField(
    #     column_name='x_adr_tampon', null=True, constraints=[SQL("DEFAULT ''")])
    id_chargement = IntegerField(
        column_name='x_id_chargement', null=True)
    id_chariot = IntegerField(
        column_name='x_id_chariot', null=True)
    # pas l'air utilisé
    # colonne_47 = IntegerField(
    #    column_name='Colonne 47', null=True)
    # colonne_48 = IntegerField(
    #    column_name='Colonne 48', null=True)
    num_face = IntegerField(
        column_name='x_num_face', null=True)
    # dotitemadd = BooleanField(
    #     column_name='x_dotitemadd', null=True, constraints=[SQL("DEFAULT 0")])
    # mode_mds = CharField(
    #     column_name='x_mode_mds', null=True, constraints=[SQL("DEFAULT ''")])
    # commentaire_web = CharField(
    #     column_name='x_commentaire_web', constraints=[SQL("DEFAULT ''")])
    id_presc = IntegerField(
        column_name='x_id_presc', null=True, constraints=[SQL("DEFAULT 0")])
    liste_pat = CharField(
        column_name='x_liste_pat', null=True, constraints=[SQL("DEFAULT ''")])
    # code_liv = CharField(
    #     column_name='x_code_liv', constraints=[SQL("DEFAULT ''")])
    dtprise = DateTimeField(
        column_name='x_dtprise', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    moment = CharField(
        column_name='x_moment', constraints=[SQL("DEFAULT ''")])
    # comment = CharField(
    #     column_name='x_comment', constraints=[SQL("DEFAULT ''")])
    id_pilulier = CharField(
        column_name='x_id_pilulier', null=True, constraints=[SQL("DEFAULT ''")])
    pos_pilulier = IntegerField(
        column_name='x_pos_pilulier', constraints=[SQL("DEFAULT 0")])
    tiroir = IntegerField(
        column_name='x_tiroir', constraints=[SQL("DEFAULT 0")])
    # alveole = IntegerField(
    #     column_name='x_alveole', null=True, constraints=[SQL("DEFAULT 0")])
    alveole_theo = IntegerField(
        column_name='x_alveole_theo', constraints=[SQL("DEFAULT 0")])
    no_pilulier = IntegerField(
        column_name='x_no_pilulier', constraints=[SQL("DEFAULT 0")])
    id_peigne = IntegerField(
        column_name='x_id_peigne', constraints=[SQL("DEFAULT 0")])
    pilulier_theo = IntegerField(
        column_name='x_pilulier_theo', constraints=[SQL("DEFAULT 0")])
    item_wms = IntegerField(
        column_name='x_item_wms', constraints=[SQL("DEFAULT 0")])
    pk_item = IntegerField(
        column_name='x_pk_item', constraints=[SQL("DEFAULT 0")])
    heure = CharField(
        column_name='x_heure', constraints=[SQL("DEFAULT ''")])
    readonly = BooleanField(
        column_name='x_readonly', constraints=[SQL("DEFAULT 0")])
    qte_prescrite = FloatField(
        column_name='x_qte_prescrite', constraints=[SQL("DEFAULT 0.000")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")])
    type_servi = CharField(
        column_name='x_type_servi', constraints=[SQL("DEFAULT 'GLOBAL_BTE'")])
    id_servi = IntegerField(
        column_name='x_id_servi', constraints=[SQL("DEFAULT 2")])
    sous_secteur = CharField(
        column_name='xx_sous_secteur', constraints=[SQL("DEFAULT ''")])
    id_plateau = CharField(
        column_name='x_id_plateau', constraints=[SQL("DEFAULT ''")])
    complement_envoye = BooleanField(
        column_name='x_complement_envoye', constraints=[SQL("DEFAULT 0")])
    liste_orig = CharField(
        column_name='x_liste_orig', null=True, constraints=[SQL("DEFAULT ''")])
    posologie = TextField(
        column_name='x_posologie', null=True)
    # Présent a Bordeaux mais ne semble pas utilisé
    # date_debut = DateTimeField(
    #     column_name='x_date_debut', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # date_fin = DateTimeField(
    #     column_name='x_date_fin', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])

    class Meta:
        table_name = 'f_item'


class FListe(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    liste = CharField(
        column_name='x_liste', null=True, constraints=[SQL("DEFAULT ''")])
    date_creation = DateTimeField(
        column_name='x_tcreat', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    etat = CharField(
        column_name='x_etat', null=True, constraints=[SQL("DEFAULT ''")])
    mode = CharField(
        column_name='x_mode', null=True, constraints=[SQL("DEFAULT ''")])
    fusion = CharField(
        column_name='x_fusion', null=True, constraints=[SQL("DEFAULT ''")])
    nb_item = IntegerField(
        column_name='x_nb_item', null=True, constraints=[SQL("DEFAULT 0")])
    service = CharField(
        column_name='x_dest', null=True, constraints=[SQL("DEFAULT ''")])
    date_modification = DateTimeField(
        column_name='x_tmodif', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # sequence = CharField(
    #     column_name='x_sequence', null=True, constraints=[SQL("DEFAULT ''")])
    # interface = CharField(
    #     column_name='x_interface', constraints=[SQL("DEFAULT ''")])
    num_ipp = CharField(
        column_name='x_num_ipp', constraints=[SQL("DEFAULT ''")])
    num_sej = CharField(
        column_name='x_num_sej', constraints=[SQL("DEFAULT ''")])
    zone_deb = CharField(
        column_name='x_zone_deb', null=True, constraints=[SQL("DEFAULT ''")])
    zone_fin = CharField(
        column_name='x_zone_fin', null=True, constraints=[SQL("DEFAULT ''")])
    # dot = CharField(
    #     column_name='x_dot', null=True, constraints=[SQL("DEFAULT ''")])
    # date_reception = DateTimeField(
    #     column_name='x_date_rece', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # imp_transfert = BooleanField(
    #     column_name='x_imp_transfert', null=True, constraints=[SQL("DEFAULT 0")])
    # type_liste_web = IntegerField(
    #     column_name='x_type_liste_web', constraints=[SQL("DEFAULT 0")])
    # createur = CharField(
    #     column_name='x_createur', constraints=[SQL("DEFAULT ''")])
    ddeb = DateTimeField(
        column_name='x_ddeb', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # moment = CharField(
    #     column_name='x_moment', null=True, constraints=[SQL("DEFAULT ''")])
    ipp = CharField(
        column_name='x_ipp', constraints=[SQL("DEFAULT ''")])
    id_prescription = IntegerField(
        column_name='x_id_presc', null=True, constraints=[SQL("DEFAULT 0")])
    liste_pat = CharField(
        column_name='x_liste_pat', null=True, constraints=[SQL("DEFAULT ''")])
    code_livraison = CharField(
        column_name='x_code_liv', constraints=[SQL("DEFAULT ''")])
    type_servi = CharField(
        column_name='x_type_servi', constraints=[SQL("DEFAULT 'GLOBAL_BTE'")])
    id_servi = IntegerField(
        column_name='x_id_servi', constraints=[SQL("DEFAULT 2")])
    robot = CharField(
        column_name='x_robot', constraints=[SQL("DEFAULT ''")])
    sous_secteur = CharField(
        column_name='xx_sous_secteur', constraints=[SQL("DEFAULT ''")])
    selectionne = IntegerField(
        column_name='x_selectionne', constraints=[SQL("DEFAULT 0")])
    origine_sel = CharField(
        column_name='x_origine_sel', constraints=[SQL("DEFAULT ''")])
    valide_sel = BooleanField(
        column_name='x_valide_sel', constraints=[SQL("DEFAULT 0")])
    id_pilulier = CharField(
        column_name='x_id_pilulier', constraints=[SQL("DEFAULT ''")])
    id_plateau = CharField(
        column_name='x_id_plateau', constraints=[SQL("DEFAULT ''")])
    no_pilulier = IntegerField(
        column_name='x_no_pilulier', constraints=[SQL("DEFAULT 0")])
    id_peigne = IntegerField(
        column_name='x_id_peigne', constraints=[SQL("DEFAULT 0")])
    tiroir = IntegerField(
        column_name='x_tiroir', constraints=[SQL("DEFAULT 0")])
    pos_pilulier = IntegerField(
        column_name='x_pos_pilulier', constraints=[SQL("DEFAULT 0")])
    id_chargement = CharField(
        column_name='x_id_chargement', null=True, constraints=[SQL("DEFAULT ''")])
    id_chariot = IntegerField(
        column_name='x_id_chariot', null=True, constraints=[SQL("DEFAULT 0")])
    adr_pilulier = CharField(
        column_name='x_adr_pilulier', null=True, constraints=[SQL("DEFAULT ''")])
    pk_pilulier = CharField(
        column_name='x_pk_pilulier', null=True, constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_liste'

    def save(self, force_insert=False, only=None):
        """Enforce control on each information passed"""
        if self.mode == 'S' and self.type_servi in MODE_NOMINATIF:
            if self.id_prescription is None:
                raise ValueError('No prescription found')
            if self.ipp is None:
                raise ValueError('No IPP found')
        elif self.mode == 'S' and self.fusion in FUSION_SORTIE_LOT:
            if self.type_servi is None:
                raise ValueError('No Type Servi found')
            if self.etat is None:
                self.etat = 'V'
        elif self.mode == 'S' and self.fusion in FUSION_SORTIE_PERIME:
            if self.type_servi is None:
                raise ValueError('No Type Servi found')
            if self.etat is None or self.etat == '':
                self.etat = 'V'
        return super().save(force_insert, only)

    def delete_instance(self, recursive=False, delete_nullable=False):
        """When we delete FListe, we must remove related FItem"""
        fi_list = FItem.select().where(FItem.liste==self.liste)
        for fi in fi_list:
            fi.delete_instance()

        return super().delete_instance(recursive, delete_nullable)


# Backward compatibility
Dispensation = FListe  # noqa
DispensationItem = FItem  # noqa
