from peewee import IntegerField, CharField, DateTimeField, BooleanField
from ..base import BaseModelSuiviProd
from peewee import SQL

class SuiviProd(BaseModelSuiviProd):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    variable = CharField(
        unique=True, column_name='x_variable')
    valeur_alpha = CharField(
        column_name='x_valeur_alpha')
    valeur_num = IntegerField(
        column_name="x_valeur_num", null=True, constraints=[SQL("DEFAULT 0")])
    poste = CharField(
        column_name='x_poste')
    type = CharField(
        column_name='x_type')
    etat = CharField(
        column_name='x_etat', default='')

    class Meta:
        table_name = 'f_suivi_production'
