from peewee import (
    AutoField,
    CharField,
    IntegerField,
    BooleanField,
    FloatField,
    DateTimeField,
)
from peewee import SQL
from ..base import BaseModel


class Gpao(BaseModel):      

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    poste = CharField(
        column_name='x_poste', null=True, constraints=[SQL("DEFAULT ''")])
    etat = CharField(
        column_name='x_etat', null=True, constraints=[SQL("DEFAULT ''")])
    ref = CharField(
        column_name='x_ref', null=True, constraints=[SQL("DEFAULT ''")])
    qte = FloatField(
        column_name='x_qte', null=True, constraints=[SQL("DEFAULT 0.000")])
    # admin = CharField(
    #    column_name='x_admin', null=True, constraints=[SQL("DEFAULT ''")])
    lot = CharField(
        column_name='x_lot', null=True, constraints=[SQL("DEFAULT ''")])
    # qte_avant = FloatField(
    #    column_name='x_qte_avant', null=True, constraints=[SQL("DEFAULT 0.000")])
    # qte_apres = FloatField(
    #    column_name='x_qte_apres', null=True, constraints=[SQL("DEFAULT 0.000")])
    type_mvt = CharField(
        column_name='x_type_mvt', null=True, constraints=[SQL("DEFAULT ''")])
    liste = CharField(
       column_name='x_liste', null=True, constraints=[SQL("DEFAULT ''")])
    dest = CharField(
        column_name='x_dest', null=True, constraints=[SQL("DEFAULT ''")])
    # user = CharField(
    #     column_name='x_user', null=True, constraints=[SQL("DEFAULT ''")])
    # item = CharField(
    #     column_name='x_item', null=True, constraints=[SQL("DEFAULT ''")])
    # indice = IntegerField(
    #    column_name='x_indice', null=True, constraints=[SQL("DEFAULT 0")])
    # sequence = CharField(
    #     column_name='x_sequence', null=True, constraints=[SQL("DEFAULT ''")])
    # num_mag = CharField(
    #     column_name='x_num_mag', null=True, constraints=[SQL("DEFAULT ''")])
    # interface = CharField(
    #     column_name='x_interface', constraints=[SQL("DEFAULT ''")])
    # demandeur = CharField(
    #     column_name='x_demandeur', null=True, constraints=[SQL("DEFAULT ''")])
    # info = CharField(
    #     column_name='x_info', null=True, constraints=[SQL("DEFAULT ''")])
    # exporte = BooleanField(
    #     column_name='x_exporte', null=True, constraints=[SQL("DEFAULT 0")])
    # date_dem = CharField(
    #     column_name='x_date_dem', null=True, constraints=[SQL("DEFAULT ''")])
    # heure_dem = CharField(
    #     column_name='x_heure_dem', null=True, constraints=[SQL("DEFAULT ''")])
    # num_dem = FloatField(
    #     column_name='x_num_dem', null=True, constraints=[SQL("DEFAULT 0")])
    # ucd = CharField(
    #     column_name='x_ucd', constraints=[SQL("DEFAULT ''")])
    # cip = CharField(
    #     column_name='x_cip', constraints=[SQL("DEFAULT ''")])
    # desig = CharField(
    #     column_name='x_desig', null=True, constraints=[SQL("DEFAULT ''")])
    # qte_dem = FloatField(
    #     column_name='x_qte_dem', null=True, constraints=[SQL("DEFAULT 0.000")])
    # qte_disp = FloatField(
    #     column_name='x_qte_disp', null=True, constraints=[SQL("DEFAULT 0.000")])
    # unite = CharField(
    #     column_name='x_unite', null=True, constraints=[SQL("DEFAULT ''")])
    # lib_unite = CharField(
    #     column_name='x_lib_unite', null=True, constraints=[SQL("DEFAULT ''")])
    # typ_dem = CharField(
    #     column_name='x_typ_dem', null=True, constraints=[SQL("DEFAULT ''")])
    id_pilulier = CharField(
        column_name='x_id_pilulier', constraints=[SQL("DEFAULT ''")])
    case = IntegerField(
        column_name='x_case', constraints=[SQL("DEFAULT 0")])
    solde = IntegerField(
        column_name='x_solde', constraints=[SQL("DEFAULT 0")])
    tperemp = DateTimeField(
        column_name='x_tperemp', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    item_wms = IntegerField(
        column_name='x_item_wms', null=True, constraints=[SQL("DEFAULT 0")])
    tenvoi = DateTimeField(
        column_name='x_tenvoi', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    serial = CharField(
        column_name='x_serial', constraints=[SQL("DEFAULT ''")])
    # type_mvt_bte = CharField(
    #     column_name='xx_type_mvt_bte', constraints=[SQL("DEFAULT ''")])
    # contenant = CharField(
    #     column_name='x_contenant', constraints=[SQL("DEFAULT ''")])
    # tentree = DateTimeField(
    #     column_name='x_tentree', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")])
    pk_item = IntegerField(
        column_name='x_pk_item', constraints=[SQL("DEFAULT 0")])
    ipp = CharField(
        column_name='x_ipp', constraints=[SQL("DEFAULT ''")])
    sejour = CharField(
        column_name='x_sejour', constraints=[SQL("DEFAULT ''")])
    id_zone = IntegerField(
        column_name='x_id_zone', null=True, constraints=[SQL("DEFAULT 1")])
    id_robot = IntegerField(
        column_name='x_id_robot', null=True, constraints=[SQL("DEFAULT 1")])

    class Meta:
        table_name = 'f_gpao'