# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Product, Ucd, Cip, Seuil


class TestModelProduct:
    def test_unknown_product(self):
        """Test d'un produit inexistant"""
        with pytest.raises(DoesNotExist):
            Product.get(reference="INCONNU")

    def test_select_product(self):
        """Verification du produit deverminage"""
        pr = Product.get(reference="DEVERMINAGE")
        assert pr.pk > 0

    def test_create_product(self):
        """Creation d'un produit de test"""
        pr = Product()
        pr.reference = "ECO1234"
        pr.designation = "Eco Medoc"
        pr.save()
        assert pr.pk > 0

    def test_modify_product(self):
        """Modify product (eg: astus only)"""
        pr = Product.get(reference="ECO1234")
        assert pr.externe == False
        pr.externe = True
        pr.save()
        assert pr.externe == True

    def test_delete_product(self):
        """Suppression du produitd e test"""
        pr = Product.get(reference="ECO1234")
        pr.delete_instance()

    def test_create_product_ucd(self):
        """Creation d'un produit de test avec UCD"""
        pr = Product()
        pr.reference = "ECO9999"
        pr.designation = "Eco Medoc"
        pr.save()
        assert pr.pk > 0
        ucd = Ucd()
        ucd.reference = pr.reference
        ucd.ucd = "9047693"
        ucd.save()
        assert ucd.pk > 0
        ucd.delete_instance()
        pr.delete_instance()

    def test_create_product_ucd_cip(self):
        """Creation d'un produit de test avec UCD et CIP"""
        pr = Product()
        pr.reference = "ECO9999"
        pr.designation = "Eco Medoc"
        pr.save()
        assert pr.pk > 0
        ucd = Ucd()
        ucd.reference = pr.reference
        ucd.ucd = "9047693"
        ucd.save()
        assert ucd.pk > 0
        cip = Cip()
        cip.ucd = ucd.ucd
        cip.cip = "3400937140423"
        cip.save()
        assert cip.pk > 0
        cip.delete_instance()
        ucd.delete_instance()
        pr.delete_instance()

    def test_create_seuil(self):
        """Creation d'un seuil"""
        s = Seuil()
        s.reference = "4556485"
        s.zone = "CUEILLETTE_100"
        s.stock_mini = 14
        s.stock_maxi = 28
        s.save()
        assert s.pk > 0
        s.delete_instance()
