import pytest
from peewee import DoesNotExist
from median.models import Config
from median.views.parameter import RawConfig
from datetime import datetime


class TestModelConfig:

    def test_global_config(self):
        """
        Lecture d'un parametre de configuration, numéro de version de la base
        """
        cfg = Config.get(poste='TOUS', cle='cfg', propriete='k_base_version')
        assert cfg.pk > 0
        assert cfg.type_value == 'N'
        assert cfg.type_champ == 'num'
        assert cfg.ref_id == '_3CM0JAGWD'


class TestParameter:

    def test_rawconfig_global(self):
        raw = RawConfig()
        cfg = raw.read('k_base_version')
        assert cfg.pk > 0
        assert cfg.value == 81
        assert cfg.type_value == 'N'
        assert cfg.type_champ == 'num'
        assert cfg.ref_id == '_3CM0JAGWD'

    def test_rawconfig_unknown(self):
        """Check unknown property"""
        raw = RawConfig()
        cfg = raw.read('k_base_vers')
        assert cfg is None

    def test_write_rawconfig_global(self):
        raw = RawConfig()
        cfg = raw.read('k_base_version')
        assert cfg.pk > 0
        assert cfg.value == 81

        cfg = raw.write('k_base_version', 92)
        assert cfg.pk > 0
        assert cfg.value == 92
        assert cfg.type_value == 'N'
        assert cfg.type_champ == 'num'

        cfg = raw.write('k_base_version', 81)
        assert cfg.type_value == 'N'
        assert cfg.type_champ == 'num'

    def test_write_rawconfig_global_str(self):
        raw = RawConfig()
        cfg = raw.read('k_batch_niv_des_log')
        assert cfg.pk > 0
        assert cfg.value == 'Info'

        cfg = raw.write('k_batch_niv_des_log', 'Debug')
        assert cfg.pk > 0
        assert cfg.value == 'Debug'

        cfg = raw.write('k_batch_niv_des_log', 'Info')

    def test_write_rawconfig_bool(self):
        """Test write de boolean value"""
        raw = RawConfig()
        cfg = raw.read('k_aff_gras')
        assert cfg.pk > 0
        assert cfg.value == False

        cfg = raw.write('k_aff_gras', True)
        assert cfg.pk > 0
        assert cfg.value == True

        cfg = raw.write('k_aff_gras', False)
        assert cfg.pk > 0
        assert cfg.value == False

    def test_write_rawconfig_int2(self):
        raw = RawConfig()
        cfg = raw.read('k_base_version')
        assert cfg.pk > 0
        assert cfg.value == 81

        cfg = raw.write('k_median_lib', 92)
        assert cfg.pk > 0
        assert cfg.value == 92

    def test_write_rawconfig_bool2(self):
        raw = RawConfig()
        cfg = raw.write('k_median_lib_bool', True)
        assert cfg.pk > 0
        assert cfg.value == True

        cfg = raw.write('k_median_lib_bool', False)
        assert cfg.pk > 0
        assert cfg.value == False

        raw.delete('k_median_lib_bool')

    def test_write_rawconfig_str2(self):
        raw = RawConfig()
        cfg = raw.write('k_median_lib_str', 'OK')
        assert cfg.pk > 0
        assert cfg.value == 'OK'

        raw.delete('k_median_lib_str')

    def test_delete_rawconfig_global(self):
        """Delete a key on configuration"""
        raw = RawConfig()
        raw.delete('k_median_lib')

    def test_delete_unknown_rawconfig_global(self):
        """Delete unknown a key on configuration"""
        raw = RawConfig()
        raw.delete('k_median_lib2')
        