import pytest
from median.base import BaseView


class TestClassBaseView:

    def test_init_baseview(self):
        """
        Test d'initialisation de la classe
        """
        bv = BaseView()
        assert bv is not None

    def test_protect_data_1(self):
        """
        Vérification des protection des données
        l'apostrophe
        """
        bv = BaseView()
        pt = bv._protect("L'idole des jeunes")
        assert pt == "L\\'idole des jeunes"

    def test_protect_data_2(self):
        """
        Vérification des protection des données
        l'anti slash
        """
        bv = BaseView()
        pt = bv._protect(r"c:\Windows\System32\test")
        assert pt == r"c:\\Windows\\System32\\test"

    def test_protect_data_3(self):
        """
        Vérification des protection des données
        le code hexa 0 (0x00) voir \0 en C
        """
        bv = BaseView()
        pt = bv._protect(r"Fin de ligne\0")
        assert pt == r"Fin de ligne\\0"

    def test_protect_data_4(self):
        """
        Vérification des protection des données
        Code ASCII 26 pour END-OF-FILE
        """
        bv = BaseView()
        pt = bv._protect(r"Fin de ligne\Z")
        assert pt == r"Fin de ligne\\Z"

    def test_protect_data_5(self):
        """
        Vérification des protection des données
        Caractère tabulation
        """
        bv = BaseView()
        pt = bv._protect(r"Fin de ligne\t")
        assert pt == r"Fin de ligne\\t"

    def test_protect_data_6(self):
        """
        Vérification des protection des données
        Caractère backspace
        """
        bv = BaseView()
        pt = bv._protect(r"Backspace\b")
        assert pt == r"Backspace\\b"

    def test_protect_data_6(self):
        """
        Vérification des protection des données
        Caractère backspace
        """
        bv = BaseView()
        pt = bv._protect(r'Double"Quote')
        assert pt == r'Double\"Quote'