
from ..models.config import Config
from peewee import DoesNotExist
import logging

logger = logging.getLogger('median.config')


class RawConfig:

    poste = None

    def __init__(self, c_poste=None):
        self.poste = c_poste or 'TOUS'

    def read(self, param=''):
        """read a Raw value"""
        try:
            res = Config.get(poste=self.poste, cle='cfg', propriete=param)
            # import pdb; pdb.set_trace()
            if res.type_value == 'N' and res.type_champ == 'num':
                res.value = int(res.value)
            elif res.type_value == 'N' and res.type_champ == 'bool':
                res.value = int(res.value) and True or False
            logger.debug('Poste "%s" lecture paramètre "%s"' % (self.poste, param))
        except DoesNotExist:
            logger.debug('Poste "%s" paramètre "%s" non trouvé' % (self.poste, param))
            res = None

        return res

    def write(self, param='', value=None):
        """write a Raw value"""
        try:
            res = Config.get(poste=self.poste, cle='cfg', propriete=param)
            if type(value) is bool:
                res.value = str(value and 1 or 0)
            elif type(value) is int:
                res.value = str(value)
            else:
                res.value = value
            res.save()
            logger.debug('Poste "%s" mise à jour paramètre "%s"' % (self.poste, param))
        except DoesNotExist:
            res = Config(poste=self.poste, cle='cfg')
            res.propriete = param
            if type(value) is bool:
                res.value = str(value and 1 or 0)
                res.type_value = 'N'
                res.type_champ = 'bool'
            elif type(value) is int:
                res.value = str(value)
                res.type_value = 'N'
                res.type_champ = 'num'
            else:
                res.type_value = 'C'
                res.type_champ = 'reg'
                res.value = value
            res.save()
            logger.debug('Poste "%s" création paramètre "%s"' % (self.poste, param))

        if isinstance(value, (int, bool)):
            res.value = value

        return res

    def delete(self, param=''):
        try:
            res = Config.get(poste=self.poste, cle='cfg', propriete=param)
            res.delete_instance()
            logger.debug('Poste "%s" suppression paramètre "%s"' % (self.poste, param))
        except DoesNotExist:
            pass