
from peewee import IntegerField, CharField, DateTimeField, BooleanField
from ..base import BaseModel


class User(BaseModel):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    username = CharField(
        unique=True, column_name='x_user')
    password = CharField(
        column_name='x_passwd')
    profil = CharField(
        column_name='x_profil')
    description = CharField(
        column_name='x_desc')
    service = CharField(
        column_name='x_service')
    login = CharField(
        column_name='x_login', default='')
    badge = CharField(
        column_name='x_badge', default='')
    date_creation = DateTimeField(
        column_name='x_tcreat', default='0000-00-00 00:00:00')
    date_last_login = DateTimeField(
        column_name='x_tlogin', default='0000-00-00 00:00:00')
    droit_inventaire = BooleanField(
        column_name='x_inventaire', default=False)
    droit_stupefiant = BooleanField(
        column_name='x_astup', default=False)

    class Meta:
        table_name = 'f_user'
