from peewee import (
    IntegerField,
    CharField,
    DateTimeField,
    BooleanField,
    AutoField,
    FloatField,
    DateField,
    TextField
)
from peewee import SQL
from ..base import BaseModel


class Product(BaseModel):

    pk = AutoField(column_name="x_pk", primary_key=True)
    reference = CharField(
        column_name="x_ref", unique=True, null=True, constraints=[SQL("DEFAULT ''")]
    )
    designation = CharField(
        column_name="x_desig", null=True, constraints=[SQL("DEFAULT ''")]
    )
    lib_court = CharField(
        column_name="x_lib_court", null=True, constraints=[SQL("DEFAULT ''")]
    )
    ref_bis = CharField(
        column_name="x_ref_bis", null=True, constraints=[SQL("DEFAULT ''")]
    )
    domaine = CharField(
        column_name="x_domaine", null=True, constraints=[SQL("DEFAULT ''")]
    )
    tmodif = DateTimeField(
        column_name="x_tmodif",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    tsortie = DateTimeField(
        column_name="x_tsortie",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    tentree = DateTimeField(
        column_name="x_tentree",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    tinvent = DateTimeField(
        column_name="x_tinvent",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    fam_ref = CharField(
        column_name="x_fam_ref", null=True, constraints=[SQL("DEFAULT ''")]
    )
    adr_pref = CharField(
        column_name="x_adr_pref", null=True, constraints=[SQL("DEFAULT ''")]
    )
    classe = CharField(
        column_name="x_classe", null=True, constraints=[SQL("DEFAULT ''")]
    )
    emp_res = BooleanField(
        column_name="x_emp_res", null=True, constraints=[SQL("DEFAULT 0")]
    )
    mono_emp = BooleanField(
        column_name="x_mono_emp", null=True, constraints=[SQL("DEFAULT 0")]
    )
    outil = BooleanField(
        column_name="x_outil", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_chrono = BooleanField(
        column_name="x_s_chrono", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_libmax = BooleanField(
        column_name="x_s_libmax", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_minmvt = BooleanField(
        column_name="x_s_minmvt", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_chrono = BooleanField(
        column_name="x_e_chrono", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_stricte = BooleanField(
        column_name="x_e_stricte", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_minmvt = BooleanField(
        column_name="x_e_minmvt", null=True, constraints=[SQL("DEFAULT 0")]
    )
    g_lot = BooleanField(
        column_name="x_g_lot", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_lot_f = BooleanField(
        column_name="x_s_lot_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_lot_f = BooleanField(
        column_name="x_e_lot_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_lot_str = BooleanField(
        column_name="x_e_lot_str", null=True, constraints=[SQL("DEFAULT 0")]
    )
    g_peremp = BooleanField(
        column_name="x_g_peremp", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_peremp_f = BooleanField(
        column_name="x_s_peremp_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_peremp_f = BooleanField(
        column_name="x_e_peremp_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_peremp_str = BooleanField(
        column_name="x_e_peremp_str", null=True, constraints=[SQL("DEFAULT 0")]
    )
    g_quarant = BooleanField(
        column_name="x_g_quarant", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_quarant_f = BooleanField(
        column_name="x_e_quarant_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_quarant_str = BooleanField(
        column_name="x_e_quarant_str", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_quarant_f = BooleanField(
        column_name="x_s_quarant_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    g_admin = BooleanField(
        column_name="x_g_admin", null=True, constraints=[SQL("DEFAULT 0")]
    )
    e_admin_str = BooleanField(
        column_name="x_e_admin_str", null=True, constraints=[SQL("DEFAULT 0")]
    )
    g_condi = BooleanField(
        column_name="x_g_condi", null=True, constraints=[SQL("DEFAULT 0")]
    )
    condi = FloatField(
        column_name="x_condi", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    e_condi = BooleanField(
        column_name="x_e_condi", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_lieu = CharField(
        column_name="x_s_lieu", null=True, constraints=[SQL("DEFAULT ''")]
    )
    e_lieu = CharField(
        column_name="x_e_lieu", null=True, constraints=[SQL("DEFAULT ''")]
    )
    alpha_1 = CharField(
        column_name="x_alpha_1", null=True, constraints=[SQL("DEFAULT ''")]
    )
    alpha_2 = CharField(
        column_name="x_alpha_2", null=True, constraints=[SQL("DEFAULT ''")]
    )
    num_1 = FloatField(
        column_name="x_num_1", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    num_2 = FloatField(
        column_name="x_num_2", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    e_admin_f = BooleanField(
        column_name="x_e_admin_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    s_admin_f = BooleanField(
        column_name="x_s_admin_f", null=True, constraints=[SQL("DEFAULT 0")]
    )
    old_ref = CharField(
        column_name="x_old_ref", null=True, constraints=[SQL("DEFAULT ''")]
    )
    stk_mini = FloatField(
        column_name="x_stk_mini", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    stk_maxi = IntegerField(
        column_name="x_stk_maxi", null=True, constraints=[SQL("DEFAULT 0")]
    )
    stk_reap = FloatField(
        column_name="x_stk_reap", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    cycle_reap = IntegerField(
        column_name="x_cycle_reap", null=True, constraints=[SQL("DEFAULT 0")]
    )
    reap_mode = CharField(
        column_name="x_reap_mode", null=True, constraints=[SQL("DEFAULT ''")]
    )
    priu = FloatField(
        column_name="x_prix_u", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    pds_u = FloatField(
        column_name="x_pds_u", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    treap = DateTimeField(
        column_name="x_treap",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    unite = CharField(column_name="x_unite", null=True, constraints=[SQL("DEFAULT ''")])
    pmp = FloatField(column_name="x_pmp", null=True, constraints=[SQL("DEFAULT 0.000")])
    g_pmp = BooleanField(
        column_name="x_g_pmp", null=True, constraints=[SQL("DEFAULT 0")]
    )
    image = CharField(column_name="x_image", null=True, constraints=[SQL("DEFAULT ''")])
    val_mag = CharField(
        column_name="x_val_mag", null=True, constraints=[SQL("DEFAULT ''")]
    )
    dcreat = DateField(
        column_name="x_dcreat", null=True, constraints=[SQL("DEFAULT '0000-00-00'")]
    )
    qml_cde = IntegerField(
        column_name="x_qml_cde", null=True, constraints=[SQL("DEFAULT 0")]
    )
    qml_serv = IntegerField(
        column_name="x_qml_serv", null=True, constraints=[SQL("DEFAULT 0")]
    )
    marche = CharField(
        column_name="x_marche", null=True, constraints=[SQL("DEFAULT ''")]
    )
    ageps = CharField(column_name="x_ageps", null=True, constraints=[SQL("DEFAULT ''")])
    deb_marche = DateField(
        column_name="x_deb_marche", null=True, constraints=[SQL("DEFAULT '0000-00-00'")]
    )
    fin_marche = DateField(
        column_name="x_fin_marche", null=True, constraints=[SQL("DEFAULT '0000-00-00'")]
    )
    t2a = BooleanField(column_name="x_t2a", null=True, constraints=[SQL("DEFAULT 0")])
    tva = FloatField(column_name="x_tva", null=True, constraints=[SQL("DEFAULT 0.00")])
    cpt_budg = CharField(
        column_name="x_cpt_budg", null=True, constraints=[SQL("DEFAULT ''")]
    )
    indic_gest = CharField(
        column_name="x_indic_gest", null=True, constraints=[SQL("DEFAULT ''")]
    )
    couv_min = IntegerField(column_name="x_couv_min", constraints=[SQL("DEFAULT 0")])
    couv_max = IntegerField(column_name="x_couv_max", constraints=[SQL("DEFAULT 0")])
    rupture = CharField(column_name="x_rupture", constraints=[SQL("DEFAULT ''")])
    g_traca = BooleanField(
        column_name="x_g_traca", null=True, constraints=[SQL("DEFAULT 0")]
    )
    actif = BooleanField(
        column_name="x_actif", null=True, constraints=[SQL("DEFAULT 0")]
    )
    cache_web = BooleanField(
        column_name="x_cache_web", null=True, constraints=[SQL("DEFAULT 0")]
    )
    delivrance = BooleanField(
        column_name="x_delivrance", null=True, constraints=[SQL("DEFAULT 0")]
    )
    depot = CharField(column_name="x_depot", null=True, constraints=[SQL("DEFAULT ''")])
    lppr = CharField(column_name="x_lppr", null=True, constraints=[SQL("DEFAULT ''")])
    type_marche = CharField(
        column_name="x_type_marche", null=True, constraints=[SQL("DEFAULT ''")]
    )
    g_traca_mds = BooleanField(
        column_name="x_g_traca_mds", null=True, constraints=[SQL("DEFAULT 0")]
    )
    cip = CharField(column_name="x_cip", null=True, constraints=[SQL("DEFAULT ''")])
    atc = CharField(column_name="x_atc", null=True, constraints=[SQL("DEFAULT ''")])
    ucd = CharField(column_name="x_ucd", null=True, constraints=[SQL("DEFAULT ''")])
    liste_med = CharField(column_name="x_liste_med", constraints=[SQL("DEFAULT ''")])
    info_web = CharField(column_name="x_info_web", constraints=[SQL("DEFAULT ''")])
    dci = CharField(column_name="x_dci", constraints=[SQL("DEFAULT ''")])
    forme = CharField(column_name="x_forme", constraints=[SQL("DEFAULT ''")])
    dose = CharField(column_name="x_dose", constraints=[SQL("DEFAULT ''")])
    fraction = FloatField(column_name="x_fraction", constraints=[SQL("DEFAULT 0.000")])
    ref_parent = CharField(column_name="x_ref_parent", constraints=[SQL("DEFAULT ''")])
    adr_ext = CharField(column_name="x_adr_ext", constraints=[SQL("DEFAULT ''")])
    desig_bis = CharField(column_name="x_desig_bis", constraints=[SQL("DEFAULT ''")])
    volume = CharField(column_name="x_volume", constraints=[SQL("DEFAULT ''")])
    robot = BooleanField(column_name="x_robot", constraints=[SQL("DEFAULT 0")])
    unit_gest = CharField(column_name="x_unit_gest", constraints=[SQL("DEFAULT ''")])
    unit_admin = CharField(column_name="x_unit_admin", constraints=[SQL("DEFAULT ''")])
    coef_conv = FloatField(
        column_name="x_coef_conv", constraints=[SQL("DEFAULT 0.000")]
    )
    delai_peremp = IntegerField(
        column_name="x_delai_peremp", constraints=[SQL("DEFAULT 0")]
    )
    externe = BooleanField(
        column_name="x_externe", null=True, constraints=[SQL("DEFAULT 0")]
    )
    conversion_ucd = BooleanField(
        column_name="x_conversion_ucd", null=True, constraints=[SQL("DEFAULT 0")]
    )
    multidose_par_uf = BooleanField(
        column_name="x_multidose_par_uf", constraints=[SQL("DEFAULT 0")]
    )
    com_med = TextField(
        column_name='x_com_med', null=True)
    bac = IntegerField(
        column_name='x_bac', null=True)

    class Meta:
        table_name = "f_ref"



class Seuil(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    reference = CharField(
        column_name='x_ref', constraints=[SQL("DEFAULT ''")])
    zone = CharField(
        column_name='x_zone', constraints=[SQL("DEFAULT ''")])
    stock_mini = FloatField(
        column_name='x_stk_mini', constraints=[SQL("DEFAULT 0.000")])
    stock_maxi = FloatField(
        column_name='x_stk_maxi', constraints=[SQL("DEFAULT 0.000")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")])

    class Meta:
        table_name = 'f_seuil'
