from peewee import AutoField, CharField, DateTimeField, DateField
from peewee import SQL

from ..base import BaseModel


class Patient(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    ipp = CharField(
        column_name='x_num_ipp', null=True, constraints=[SQL("DEFAULT ''")])
    nom = CharField(
        column_name='x_nom_pat', null=True, constraints=[SQL("DEFAULT ''")])
    prenom = CharField(
        column_name='x_prenom_pat', null=True, constraints=[SQL("DEFAULT ''")])
    date_maj = DateTimeField(
        column_name='x_date_maj', null=True,
        constraints=[SQL("DEFAULT now()")])
    date_naissance = DateField(
        column_name='x_dnaiss', null=True,
        constraints=[SQL("DEFAULT '0000-00-00'")])
    sexe = CharField(
        column_name='x_sexe', null=True,
        constraints=[SQL("DEFAULT '-'")])
    nom_jeune_fille = CharField(
        column_name='x_nom_jf',
        constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_patient'
