from peewee import AutoField, CharField, IntegerField, DateTimeField
from peewee import SQL

from ..base import BaseModel


class Cip(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    cip = CharField(
        column_name='x_cip', constraints=[SQL("DEFAULT ''")])
    ucd = CharField(
        column_name='x_ucd', constraints=[SQL("DEFAULT ''")])
    qt_blister = IntegerField(
        column_name='x_qt_blister', constraints=[SQL("DEFAULT 0")])
    qt_boite = IntegerField(
        column_name='x_qt_boite', constraints=[SQL("DEFAULT 0")])
    indedossier = CharField(
        column_name='x_index_dossier', constraints=[SQL("DEFAULT ''")])
    qt_pass = IntegerField(
        column_name='x_qt_pass', constraints=[SQL("DEFAULT 0")])
    qt_coupe = IntegerField(
        column_name='x_qt_coupe', constraints=[SQL("DEFAULT 0")])
    date_der_coupe = DateTimeField(
        column_name='x_date_der_coupe',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    delai_peremption = IntegerField(
        column_name='x_delai_peremption', null=True,
        constraints=[SQL("DEFAULT 0")])
    delai_a_saisir = IntegerField(
        column_name='x_delai_a_saisir', null=True,
        constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_ucd_cip'
