# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Patient, Prescription, Dispensation
import time
from datetime import datetime

@pytest.yield_fixture()
def rectest():
    print("Running method level setUp")
    rec_data = {}

    pat_test = Patient(nom='Test', prenom='Patrick')
    pat_test.ipp = "ABCD1234"
    pat_test.sexe = "M"
    pat_test.date_maj = datetime.now()
    pat_test.save()
    
    presc = Prescription()
    presc.ordre = 'Prescription 1'
    presc.ipp = 'ECO1234'
    presc.sejour = 'SEJ1234'
    presc.nom = "Test"
    presc.prenom = "Utilsiateur"
    presc.save()

    rec_data['patient'] = pat_test
    rec_data['prescription'] = presc
    yield rec_data

    print("Running method level tearDown")
    pat_test.delete_instance()
    presc.delete_instance()


class TestModelDispensation:

    def test_unknown_dispensation(self):
        """Test access unknown dispensation"""
        with pytest.raises(DoesNotExist):
            Dispensation.get(liste='INCONNU')

    def test_dispensation_out_wo_prescription(self, rectest):
        """Test create a dispensation without precription"""
        with pytest.raises(ValueError):
            dis = Dispensation()
            dis.liste = "TEST dispensation"
            dis.mode = 'S'
            dis.etat = 'V'
            dis.save()

    def test_dispensation_out_wo_patient(self, rectest):
        """Test create a dispensation without patient"""
        with pytest.raises(ValueError):
            dis = Dispensation()
            dis.liste = "TEST dispensation"
            dis.mode = 'S'
            dis.etat = 'V'
            dis.id_prescription = rectest['prescription']
            dis.save()

    def test_create_dispensation_out(self, rectest):
        """Test create a dispensation"""
        dis = Dispensation()
        dis.liste = "TEST dispensation"
        dis.mode = 'S'
        dis.etat = 'V'
        dis.id_prescription = rectest['patient']
        dis.ipp = rectest['patient']
        dis.save()
        assert dis.pk > 0
        dis.delete_instance()
