from peewee import AutoField, CharField, IntegerField, BooleanField 
from peewee import SQL

from ..base import BaseModel


class Service(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    code = CharField(
        column_name='x_dest', unique=True, null=True, constraints=[SQL("DEFAULT ''")])
    libelle = CharField(
        column_name='x_lib_dest', null=True, constraints=[SQL("DEFAULT ''")])
    ordre = IntegerField(
        column_name='x_ordre', null=True, constraints=[SQL("DEFAULT 0")])
    ug = CharField(
        column_name='x_ug', null=True, constraints=[SQL("DEFAULT ''")])
    resp_serv = CharField(
        column_name='x_resp_serv', null=True, constraints=[SQL("DEFAULT ''")])
    cadre_sup = CharField(
        column_name='x_cadre_sup', null=True, constraints=[SQL("DEFAULT ''")])
    cr = CharField(
        column_name='x_cr', null=True, constraints=[SQL("DEFAULT ''")])
    lib_cr = CharField(
        column_name='x_lib_cr', null=True, constraints=[SQL("DEFAULT ''")])
    pole = CharField(
        column_name='x_pole', constraints=[SQL("DEFAULT ''")])
    nb_cde = IntegerField(
        column_name='x_nb_cde', constraints=[SQL("DEFAULT 0")])
    nb_bu = IntegerField(
        column_name='x_nb_bu', constraints=[SQL("DEFAULT 0")])
    nb_item_bu = IntegerField(
        column_name='x_nb_item_bu', constraints=[SQL("DEFAULT 0")])
    type_peigne = IntegerField(
        column_name='x_type_peigne', constraints=[SQL("DEFAULT 0")])
    moment_deb = CharField(
        column_name='x_moment_deb', constraints=[SQL("DEFAULT '0'")])
    deb_matin = IntegerField(
        column_name='x_deb_matin', constraints=[SQL("DEFAULT 6")])
    deb_midi = IntegerField(
        column_name='x_deb_midi', constraints=[SQL("DEFAULT 11")])
    deb_soir = IntegerField(
        column_name='x_deb_soir', constraints=[SQL("DEFAULT 14")])
    deb_coucher = IntegerField(
        column_name='x_deb_coucher', constraints=[SQL("DEFAULT 20")])
    type_dest = CharField(
        column_name='x_type_dest', constraints=[SQL("DEFAULT 'SERVICE'")])
    tri = CharField(
        column_name='x_tri', constraints=[SQL("DEFAULT ''")])
    optim_peigne = BooleanField(
        column_name='x_optim_peigne', constraints=[SQL("DEFAULT 0")])
    nb_jour = IntegerField(
        column_name='x_nb_jour', null=True, constraints=[SQL("DEFAULT 0")])
    tri_jour = BooleanField(
        column_name='x_tri_jour', constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_dest'
