
from peewee import Model
from .database import mysql_db


class BaseModel(Model):
    """A base model that will use our MySQL database"""
    class Meta:
        database = mysql_db


class BaseViewException(Exception):
    def __init__(self, message):
        self.message = message


class BaseViewNotImplemented(Exception):
    def __init__(self, message):
        self.message = message


class BaseViewDuplicate(Exception):
    def __init__(self, message):
        self.message = message


class BaseView:
    """
    Business object to add standard function
    """

    id = 0

    def __init__(self):
        """Initialise BaseView class"""
        pass

    #
    # Fonction publique
    #
    def creer(self):
        raise BaseViewNotImplemented('Fonction creer() non implementée') 

    def modifier(self):
        raise BaseViewNotImplemented('Fonction modifier() non implementée') 

    def supprimer(self):
        raise BaseViewNotImplemented('Fonction supprimer() non implementée') 

    def lire(self):
        raise BaseViewNotImplemented('Fonction supprimer() non implementée') 

    #
    # Fonction privée
    #

    @staticmethod
    def _protect(data):
        """
        Protège les données avant de les envoyés en tant que requête SQL
        """
        data = data.replace("\\", "\\\\")
        data = data.replace("'", "\\'")
        data = data.replace('"', '\\"')
        return data