#
# Generate peewee model from MySQL Database
#
# flake8: noqa

import os
import sys

# import _mysql
import MySQLdb
import pprint
import pathlib

CUR_DIR = pathlib.Path(".")
DIST_FOLDER = CUR_DIR / "dist"

DB_HOST = os.environ.get("MEDIAN_DB_HOST", "127.0.0.1")
DB_PORT = int(os.environ.get("MEDIAN_DB_PORT", 3306))
DB_USER = os.environ.get("MEDIAN_DB_USER", "root")
DB_PASS = os.environ.get("MEDIAN_DB_PASS", "root")
DB_NAME = os.environ.get("MEDIAN_DB_NAME", "median")


DB_TABLE = "f_item_w"
DB_MODEL = "ItemWork"

TYPE_FIELD = []
FIEDLS = []

mydb = MySQLdb.connect(
    host=DB_HOST, port=DB_PORT, user=DB_USER, passwd=DB_PASS, db=DB_NAME
)
cr = mydb.cursor(MySQLdb.cursors.DictCursor)

#Check if dist forlder exists, otherwise create it

DIST_FOLDER.mkdir(parents=True, exist_ok=True)



# print("from peewee import SQL\n")
# print("from ..base import BaseModel\n\n")

Query = """
SELECT `TABLE_NAME` AS table_name, `COLUMN_NAME` AS column_name, `ORDINAL_POSITION` AS column_order, `COLUMN_DEFAULT` AS column_defaut,
       `IS_NULLABLE` AS can_be_null, `DATA_TYPE` AS column_datatype, `CHARACTER_MAXIMUM_LENGTH` AS column_length, `NUMERIC_PRECISION` AS  num_prec,
       `NUMERIC_SCALE` AS num_scale, `DATETIME_PRECISION` AS date_prec, `COLUMN_KEY` AS column_key, `EXTRA` AS extra, `COLUMN_COMMENT` AS column_comment,
       `COLUMN_TYPE` AS column_type
FROM information_schema.`COLUMNS`
WHERE table_schema = '%s'
AND `TABLE_NAME` = '%s'
ORDER BY `ORDINAL_POSITION`;
""" % (
    DB_NAME,
    DB_TABLE,
)

try:
    cr.execute(Query)

    # print("class %s(BaseModel):\n" % DB_MODEL)
    for row in cr.fetchall():
        col_attrs = {}
        col_type = ""
        col_size = 0
        new_col_name = row["column_name"].replace("xx_", "").replace("x_", "").lower()
        ori_co_name = row["column_name"]
        col_attrs["column_name"] = row["column_name"]
        col_attrs["default"] = ""
        if row["column_key"] == "UNI":
            col_attrs["unique"] = True
        elif row["column_key"] == "PRI":
            col_attrs["primary_key"] = True

        if row["can_be_null"] == "YES":
            col_attrs["is_null"] = True
        else:
            col_attrs["is_null"] = False

        if row["column_key"] == "PRI":
            if row["extra"] == "auto_increment":
                col_type = "integer"
            else:
                col_type = "integer"
        elif row["column_datatype"] == "varchar":
            col_type = "varchar"
            if row['column_length'] > 0:
                col_attrs["max_length"] = row['column_length']
                col_size = row['column_length']
            if row["column_defaut"] is not None:
                col_attrs["default"] = row["column_defaut"]
        elif row["column_datatype"] == "text":
            col_type = "text"
            if row["column_defaut"] is not None:
                col_attrs["default"] = '%s' % row["column_defaut"]
        elif row["column_datatype"] in ("datetime", "timestamp"):
            col_type = "datetime"
            if row["column_defaut"] is not None:
                col_attrs["default"] = '%s' % row["column_defaut"]
        elif row["column_datatype"] == "date":
            col_type = "date"
            if row["column_defaut"] is not None:
                col_attrs["default"] = '%s' % row["column_defaut"]
        elif row["column_datatype"] in ("int", "tinyint", "smallint"):
            col_type = "integer"
            if (
                row["column_datatype"] == "tinyint"
                and row["column_type"] == "tinyint(1)"
            ):
                col_type = "boolean"
            if row["column_defaut"] is not None:
                col_attrs["default"] = '%s' % row["column_defaut"]
        elif row["column_datatype"] in ("float",):
            col_type = "float"
            if row["column_defaut"] is not None:
                col_attrs["default"] = '%s' % row["column_defaut"]
        else:
            print(row)
        FIEDLS.append({
            "name": new_col_name,
            "type": col_type,
            "attrib": col_attrs,
            "size": int(col_size),
            "column": ori_co_name,

        })
        # print(
        #     "    %s = %s(\n        %s)" % (new_col_name, col_type, ", ".join(col_attrs))
        # )


    # pprint.pprint(FIEDLS)
    # Write the model file
    model_file = DIST_FOLDER / ("%s.cs" % DB_MODEL)

    with model_file.open("w", encoding ="utf-8") as f:
        f.write("// ************************************\n")
        f.write("// * Generate by model-generato-cs.py *\n")
        f.write("// ************************************\n\n")
        f.write("using MédianInterfaces.Domain.Abstractions;\n")
        f.write("using MédianInterfaces.Domain.Helpers;\n")
        f.write("using System;\n\n")
        f.write("namespace MédianInterfaces.Domain\n{\n")

        f.write("\t/// <summary>\n")
        f.write("\t/// table %s\n" % DB_TABLE)
        f.write("\t/// </summary>\n")

        f.write("\tpublic class %s  : IIdentifiable<int>\n\t{\n" % DB_MODEL)

        f.write("\t\t/// <summary>\n")
        f.write("\t\t/// field x_pk\n")
        f.write("\t\t/// </summary>\n")

        f.write("\t\tpublic virtual int Id { get; set; }\n")

        for fld in FIEDLS:
            if fld['name'] == 'pk':
                continue
            cs_field = fld['name'].replace('_', ' ')
            cs_field = cs_field.title()
            cs_field = cs_field.replace(' ', '')

            f.write("\t\t/// <summary>\n")
            f.write("\t\t/// field x_%s\n" % fld['name'])
            f.write("\t\t/// </summary>\n")

            if fld['type'] in ('varchar', 'text'):
                f.write("\t\tpublic virtual string %s { get; set; }\n" % cs_field)
            elif fld['type'] == 'integer':
                f.write("\t\tpublic virtual int %s { get; set; }\n" % cs_field)
            elif fld['type'] == 'float':
                f.write("\t\tpublic virtual float %s { get; set; }\n" % cs_field)
            elif fld['type'] == 'datetime':
                f.write("\t\tpublic virtual DateTime %s { get; set; }\n" % cs_field)
            elif fld['type'] == 'boolean':
                f.write("\t\tpublic virtual int %s { get; set; }\n" % cs_field)
            else:
                pprint.pprint(fld)

            pass

        f.write("\t}\n")
        f.write("} // end namespasce")

    model_file = DIST_FOLDER / ("%sMap.cs" % DB_MODEL)

    with model_file.open("w", encoding ="utf-8") as f:
        f.write("// ************************************\n")
        f.write("// * Generate by model-generato-cs.py *\n")
        f.write("// ************************************\n\n")

        f.write("using FluentNHibernate.Mapping;\n")
        f.write("using MédianInterfaces.Domain;\n")
        f.write("using MédianInterfaces.Domain.Customs;\n\n")

        f.write("namespace MédianInterfaces.HandleReceiver.DataAccess.Mappings\n{\n")

        f.write("\t/// <summary>\n")
        f.write("\t/// table %s\n" % DB_TABLE)
        f.write("\t/// </summary>\n")

        f.write("\tpublic class %sMap : ClassMap<%s>\n\t{\n" % (DB_MODEL, DB_MODEL))

        f.write("\t\tpublic %sMap()\n\t\t{\n" % DB_MODEL)

        f.write("\t\t\tTable(\"%s\");\n" % DB_TABLE)
        f.write("\t\t\tNot.LazyLoad();\n\n")

        # manage id as x_pk

        f.write("""\t\t\tId(p => p.Id)\n\t\t\t\t.Column("x_pk")\n\t\t\t\t.GeneratedBy.Identity();\n""")

        for fld in FIEDLS:
            if fld['name'] == 'pk':
                continue
            cs_field = fld['name'].replace('_', ' ')
            cs_field = cs_field.title()
            cs_field = cs_field.replace(' ', '')

            f.write("\t\t\t/// <summary>\n")
            f.write("\t\t\t/// field %s -> %s%s %s default %s \n" % (fld['column'], fld['type'], fld['size'] > 0 and " (%s)" % fld['size'] or '',
                                                             fld['attrib']['is_null'] and 'null' or 'not null', fld['attrib']['default']))
            f.write("\t\t\t/// </summary>\n")

            if fld['type'] in ('varchar', 'text'):
                f.write("""\t\t\tMap(p => p.%s)\n\t\t\t\t.Column("%s")\n""" % (cs_field, fld['column']))
                if not fld['attrib']['is_null']:
                    f.write("\t\t\t\t.Not.Nullable()\n")
                if fld['size'] > 0:
                    f.write("\t\t\t\t.Length(%i)" % fld['size'])
                f.write(";\n")
                # pprint.pprint(fld)
            elif fld['type'] == 'float':
                f.write("""\t\t\tMap(p => p.%s)\n\t\t\t\t.Column("%s")""" % (cs_field, fld['column']))
                if not fld['attrib']['is_null']:
                    f.write("\n\t\t\t\t.Not.Nullable()")
                f.write(";\n")
            elif fld['type'] == 'datetime':
                f.write("""\t\t\tMap(p => p.%s)\n\t\t\t\t.Column("%s")""" % (cs_field, fld['column']))
                f.write("\n\t\t\t\t.CustomType<MySQLDateTimeType>()")
                if not fld['attrib']['is_null']:
                    f.write("\n\t\t\t\t.Not.Nullable()\n")
                f.write(";\n")
                # pprint.pprint(fld)
            elif fld['type'] in ('integer', 'int'):
                f.write("""\t\t\tMap(p => p.%s)\n\t\t\t\t.Column("%s")""" % (cs_field, fld['column']))
                if not fld['attrib']['is_null']:
                    f.write("\n\t\t\t\t.Not.Nullable()")
                f.write(";\n")
            elif fld['type'] in ('boolean', 'bool'):
                f.write("""\t\t\tMap(p => p.%s)\n\t\t\t\t.Column("%s")""" % (cs_field, fld['column']))
                if not fld['attrib']['is_null']:
                    f.write("\n\t\t\t\t.Not.Nullable()")
                f.write(";\n")
            else:
                pprint.pprint(fld)
                pass


        f.write("\t\t} // end public %sMap()\n" % DB_MODEL)
        f.write("\t}\n")
        f.write("} // end namespace")

finally:
    # print("\n    class Meta:\n        table_name = '%s'\n" % DB_TABLE)

    if mydb:
        mydb.close()
