import os

from peewee import MySQLDatabase
from peewee import IntegerField

MYSQL_DB_HOST = os.environ.get('MEDIAN_DB_HOST', 'localhost')
MYSQL_DB_PORT = int(os.environ.get('MEDIAN_DB_PORT', 3306))
MYSQL_DB_NAME = os.environ.get('MEDIAN_DB_NAME', 'test')
MYSQL_DB_USER = os.environ.get('MEDIAN_DB_USER', 'test')
MYSQL_DB_PASS = os.environ.get('MEDIAN_DB_PASS', 'test')

mysql_db = MySQLDatabase(
    MYSQL_DB_NAME, user=MYSQL_DB_USER, password=MYSQL_DB_PASS,
    host=MYSQL_DB_HOST, port=MYSQL_DB_PORT
)

MYSQL_DB_NAME_SUIVI_PROD = os.environ.get('MEDIAN_DB_NAME_SUIVI_PROD', 'suivi_production')

mysql_db_suivi_prod = MySQLDatabase(
    MYSQL_DB_NAME_SUIVI_PROD, user=MYSQL_DB_USER, password=MYSQL_DB_PASS,
    host=MYSQL_DB_HOST, port=MYSQL_DB_PORT
)


class TinyIntegerField(IntegerField):
    """Define a type for TinyINT (only on MySQL) """
    field_type = 'TINYINT'


def crypte(passwd):
    """
    Encrypte le mot de passe dans le format pour le median Foxpro
    """
    passwd_enc = ''
    passwd = passwd.lower().lstrip()

    n_car = 0
    n_last_car = 0

    if len(passwd) == 0:
        return passwd_enc

    for i in range(1, len(passwd) + 1):
        n_car = ord(passwd[i - 1:][0])

        if i == 1:
            n_car += 5
            n_last_car = n_car
        else:
            if i % 2 != 0:
                n_car += (n_last_car % 7)
            else:
                n_car -= (n_last_car % 7)

        passwd_enc += chr(n_car)
    return passwd_enc


def decripte(passwd):
    passwd_dec = ''
    if not passwd:
        return passwd_dec
    passwd = passwd.lower().lstrip()

    n_car = 0
    n_last_car = 0

    if len(passwd) == 0:
        return passwd_dec

    for i in range(1, len(passwd) + 1):
        n_car = ord(passwd[i - 1:][0])

        if i == 1:
            n_last_car = n_car
            n_car = n_car - 5
        else:
            if i % 2 != 0:
                n_car = n_car - (n_last_car % 7)
            else:
                n_car = n_car + (n_last_car % 7)

        passwd_dec += chr(n_car)

    return passwd_dec
