# flake8: noqa
import pytest
from median.utils import compute_gtin_checksum, get_counter
from median.base import MedianLibException
from median.models import Compteur



class TestUtils:
    def test_compute_bad_length_checksum(self):
        with pytest.raises(MedianLibException) as e:
            compute_gtin_checksum("23300100000")
        assert "GTIN must have 12 characters!" in str(e.value)

    def test_compute_empty_gtin_checksum(self):
        with pytest.raises(MedianLibException) as e:
            compute_gtin_checksum("")
        assert "GTIN cannot be null" in str(e.value)

    def test_compute_good_checksum(self):
        chk = compute_gtin_checksum("233001000000")
        assert chk == "3"

    def test_compute_good_checksum_full(self):
        chk = compute_gtin_checksum("233001000000", True)
        assert chk == "2330010000003"

    def test_get_unknown_counter(self):
        with pytest.raises(MedianLibException):
            get_counter('PYTEST_UNK')

    def test_get_unknown_counter_and_create(self):
        res = get_counter('PYTEST_UNK_CREA', force_create=True)
        assert res == 1
        cr = Compteur.get(cle='PYTEST_UNK_CREA')
        assert cr.val == 2
        cr.delete_instance()

    def test_get_existing_counter(self):
        cpt = Compteur()
        cpt.cle = 'PYTEST'
        cpt.val = 2
        cpt.save()

        res = get_counter('PYTEST')
        assert res == 2

        # check if the next value is correct
        cr = Compteur.get(cle='PYTEST')
        assert cr.val == 3
        cr.delete_instance()

    def test_get_existing_counter_increment_five(self):
        cpt = Compteur()
        cpt.cle = 'PYTEST5'
        cpt.val = 2
        cpt.save()

        res = get_counter('PYTEST5', 5)
        assert res == 2

        # check if the next value is correct
        cr = Compteur.get(cle='PYTEST5')
        assert cr.val == 7
        cr.delete_instance()
