from peewee import IntegerField, CharField, DateTimeField, BooleanField, AutoField
from peewee import SQL
from median.database import TinyIntegerField
from ..base import BaseModel

PROFILES = [
    'ADMIN', 'ECO-DEX', 'DEENOVA'
                        'INFIRMIER', 'INTERNE', 'PHARMACIEN',
    'PREPARATEUR', 'TECH',
]


class User(BaseModel):
    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    username = CharField(
        unique=True, column_name='x_user', max_length=20)
    password = CharField(
        column_name='x_passwd', max_length=20)
    profil = CharField(
        column_name='x_profil', max_length=20)
    description = CharField(
        column_name='x_desc', max_length=20)
    service = CharField(
        column_name='x_service', max_length=20)
    login = CharField(
        column_name='x_login', default='', max_length=30)
    badge = CharField(
        column_name='x_badge', default='', max_length=16)
    date_creation = DateTimeField(
        column_name='x_tcreat', default='0000-00-00 00:00:00')
    date_last_login = DateTimeField(
        column_name='x_tlogin', default='0000-00-00 00:00:00')
    droit_inventaire = BooleanField(
        column_name='x_inventaire', default=False)
    droit_stupefiant = BooleanField(
        column_name='x_astup', default=False)
    email = CharField(
        column_name='x_email', max_length=320, default='')
    import_flag = TinyIntegerField(
        column_name='x_import_flag', default=0)
    maintenance = TinyIntegerField(
        column_name='x_maintenance', default=0)
    lang = CharField(
        column_name='x_lang', max_length=10, default='')
    retry = IntegerField(column_name='x_retry', default=5)
    passwordWeb = CharField(
        column_name='x_passwd_web', max_length=320)
    isEnabled = TinyIntegerField(
        column_name='x_is_enabled', default=1)
    isTemporary = TinyIntegerField(
        column_name='x_is_temporary', default=1)
    avatar = CharField(
        column_name='x_avatar', default='', max_length=50)

    class Meta:
        table_name = 'f_user'
        indexes = (
            (('x_user',), True),
            (('x_email',), False),
            (('x_login',), False),
            (('x_badge',), False),
        )


class Profil(BaseModel):
    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    profil = CharField(
        column_name='x_profil', max_length=20)
    ressource = CharField(
        column_name='x_resrc', max_length=50)
    visu = TinyIntegerField(
        column_name='x_visu', default=1)
    edit = TinyIntegerField(
        column_name='x_edit', default=0)
    cree = TinyIntegerField(
        column_name='x_cree', default=0)
    supp = TinyIntegerField(
        column_name='x_supp', default=0)

    class Meta:
        table_name = 'f_profil'
        indexes = (
            (('x_profil', 'x_resrc'), True),
            (('x_profil',), False),
        )


class Rights(BaseModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    ressource = CharField(
        column_name='x_resrc', unique=True, max_length=50,
        constraints=[SQL("DEFAULT ''")], default='')
    libelle = CharField(
        column_name='x_lib', max_length=75,
        constraints=[SQL("DEFAULT ''")], default='')
    group = CharField(
        column_name='x_group', max_length=75,
        constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        table_name = 'f_resrc'
        indexes = (
            (('x_resrc',), True),
        )
