# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import LogAstus, LogInfo, LogEchangeRiedl
from datetime import datetime


class TestLogAstus:
    def test_log_astus_ok(self):
        log = LogAstus()

    def test_log_info_ok(self):
        log = LogInfo()

    def test_log_info_save(self):
        log = LogInfo()
        log.poste = "MIRTH"
        log.section = "PATIENT"
        log.log = """Message
        multiligne
        encore une
        """
        log.save()


class TestLogRiedl:
    def test_log_create(self):
        log = LogEchangeRiedl()
        log.chrono = datetime.now
        log.poste = "RIEDL_00"
        log.type = "INP"
        log.reference = "ECO0000"
        log.qte = 10
        log.lot = "ABCD"
        log.tperemp = datetime.now
        log.gtin = "1234567891234"
        log.save()
        assert log.pk > 0
        log.delete_instance()
