from enum import Enum


class TypeListe(Enum):
    Input = 'E'
    Inventory = 'I'
    Output = 'S'


class TypeServiListe(Enum):
    GlobaleBoite = 'GLOBAL_BTE'
    GlobalePilulier = 'GLOBAL_PIL'
    Nominatif = 'NOMINATIF'
    Exotique = 'EXOTIQUE'
    RiedlBoite = 'RIEDL_BTE'     # Riedl mode
    Inventory = 'INVENTORY'      # Reidl mode
    Retour = 'RETOUR'            # Riedl mode
    Prelevement = 'PRELEV'       # Riedl mode
    RetraitLot = 'RETRAIT'       # Riedl mode
    Perimee = 'PERIMEE'          # Riedl mode


class EtatListe(Enum):
    Vierge = 'V'
    EnCours = 'E'
    Solde = 'S'
    Incident = 'I'
    Archive = 'Z'
    Picking = 'P'
    Annuler = 'A'


class PatientGlobal(Enum):
    Ipp = 'GLOBAL'
    Sejour = 'GLOBAL'


class EtatAdresse(Enum):
    Libre = 'L'
    Occupe = 'O'
    Bloque = 'X'
    Multiple = 'M'  # Many differents stock on the same address


class RiedlTakingMode(Enum):
    NoTakingMode = 'NO'
    OneBoxGlobalTray = 'GL'
    OneBoxTakingTray = 'PL'


class HistoryType(Enum):
    Coupe = "CPE"
    Directe = "DIR"
    Entree = "ENT"
    Inventaire = "INV"
    Liste = "LIS"
    Livraison = "LIV"
    Pilotage = "PIL"
    Reference = "REF"
    Sortie = "SOR"
    Transfert = "TFT"


class EcoType(Enum):
    Astus = "A"
    Cueillette = "C"
    Coupe = "T"
    Riedl = "L"
    Boites = "B"
    Externe = "E"


class AstusMachineType(Enum):
    Version_1 = "ASTUS_V1"
    Version_2 = "ASTUS_V2"
    Version_3 = "ASTUS_V3"


class PickingMachineType(Enum):
    Acced_110 = "ACCED_110"
    Acced_120 = "ACCED_120"
    Acced_210 = "ACCED_210"
    Acced_220 = "ACCED_220"
    Acced_230 = "ACCED_230"
    Acced_440 = "ACCED_440"
    Acced_Boite_Pass = "ACCED_V2"
    Acced_Dose_Unit = "ACCED_V3"
    Aide_150 = "AIDE_150"
    Aide_V2 = "AIDE_V2"
    Aide_V3 = "AIDE_V3"
    Aide_Pick = "AIDE_PICK"


class RiedlMachienType(Enum):
    Riedl_Version_1 = "RIEDL_1"
    Riedl_Version_2 = "RIEDL_2"


class BoxesMachineType(Enum):
    Aide_Box = "AIDE_BOX"


class CuttingMachineType(Enum):
    Module_Coupe_500 = "MC_500"
    Module_Coupe_1000 = "MC_1000"
    Acced_110 = "ACCED_110"
    Acced_120 = "ACCED_120"
    Acced_210 = "ACCED_210"
    Acced_220 = "ACCED_220"
    Acced_320 = "ACCED_320"
    Acced_230 = "ACCED_230"
    Acced_440 = "ACCED_440"
    Aide_V2 = "AIDE_V2"
    Aide_V3 = "AIDE_V3"
    Aide_Cut = "AIDE_CUT"


DEFAULT_PROFILS = [
    'ECO-DEX',
    'DEENOVA',
    'ADMIN',
    'TECH'
]

CUSTOM_PROFILS = [
    'PREPARATEUR',
    'PHARMACIEN',
    'REFERENT',
    'INFIRMIER'
]

RIEDL_PRIORITY = [
    (1, 'Haute'),
    (3, 'Normale'),
    (5, 'Faible'),
]

RIEDL_COMPLETE = [
    (0, 'Partiel'),
    (1, 'Complète')
]

DRUGS_FRACTION = [
    25, 50,
    75, 100
]

DRUGS_ANOMALY = [
    ("UCD_DBL", "UCD on 2 drugs"),
    ("GTIN_DBL", "GTIN on 2 UCD"),
]
