from enum import Enum


class TypeListe(Enum):
    Input = 'E'
    Output = 'S'


class TypeServiListe(Enum):
    GlobaleBoite = 'GLOBAL_BTE'
    GlobalePilulier = 'GLOBAL_PIL'
    Nominatif = 'NOMINATIF'
    Exotique = 'EXOTIQUE'
    RiedlBoite = 'RIEDL_BTE'     # Riedl mode
    Retour = 'RETOUR'            # Riedl mode
    Prelevement = 'PRELEV'       # Riedl mode
    RetraitLot = 'RETRAIT'       # Riedl mode
    Perimee = 'PERIMEE'          # Riedl mode


class EtatListe(Enum):
    Vierge = 'V'
    EnCours = 'E'
    Solde = 'S'
    Incident = 'I'
    Archive = 'Z'
    Picking = 'P'
    Annuler = 'A'


class PatientGlobal(Enum):
    Ipp = 'GLOBAL'
    Sejour = 'GLOBAL'


class EtatAdresse(Enum):
    Libre = 'L'
    Occupe = 'O'
    Bloque = 'X'
    Multiple = 'M'  # Many differents stock on the same address


class RiedlTakingMode(Enum):
    NoTakingMode = 'NO'
    OneBoxGlobalTray = 'GL'
    OneBoxTakingTray = 'PL'


class HistoryType(Enum):
    Coupe = "CPE"
    Directe = "DIR"
    Entree = "ENT"
    Inventaire = "INV"
    Liste = "LIS"
    Livraison = "LIV"
    Pilotage = "PIL"
    Reference = "REF"
    Sortie = "SOR"
    Transfert = "TFT"


DEFAULT_PROFILS = [
    'ECO-DEX',
    'DEENOVA',
    'ADMIN',
    'TECH'
]

CUSTOM_PROFILS = [
    'PREPARATEUR',
    'PHARMACIEN',
    'REFERENT',
    'INFIRMIER'
]

RIEDL_PRIORITY = [
    (1, 'Haute'),
    (3, 'Normale'),
    (5, 'Faible'),
]

RIEDL_COMPLETE = [
    (0, 'Partiel'),
    (1, 'Complète')
]

DRUGS_FRACTION = [
    25, 50,
    75, 100
]

DRUGS_ANOMALY = [
    ("UCD_DBL", "UCD on 2 drugs"),
    ("GTIN_DBL", "GTIN on 2 UCD"),
]
