# flake8: noqa
import sys

sys.path.append('src')
import logging
import time

from median.base import mysql_db
from median.migration import DbMigrator

log_file = '%s-medianlib-migration.log' % time.strftime('%Y-%m-%d')
logging.basicConfig(
    handlers=[logging.FileHandler(log_file, encoding='utf-8')],
    level=logging.DEBUG,
    format='%(asctime)s  %(name)-20s  %(levelname)-6s: %(message)s'
)
logger = logging.getLogger('median.migrate')

print('Start migrator')
mig = DbMigrator(mysql_db)
mig.migrate(force=True)
print('End migrator')
