import os

# import _mysql
import MySQLdb

DB_HOST = os.environ.get("MEDIAN_DB_HOST", "192.168.60.137")
DB_PORT = int(os.environ.get("MEDIAN_DB_PORT", 3306))
DB_USER = os.environ.get("MEDIAN_DB_USER", "root")
DB_PASS = os.environ.get("MEDIAN_DB_PASS", "root")
DB_NAME = os.environ.get("MEDIAN_DB_NAME", "test")

print("Server: %s:%i" % (DB_HOST, DB_PORT))
print("User: %s" % DB_USER)
print("Database: %s" % DB_NAME)

mydb = MySQLdb.connect(
    host=DB_HOST, port=DB_PORT, user=DB_USER, passwd=DB_PASS, db=DB_NAME
)
cr = mydb.cursor(MySQLdb.cursors.DictCursor)


def delete_reference(curs, code):
    query = """DELETE FROM f_ref WHERE x_ref='%s';""" % code
    curs.execute(query)
    query = """DELETE FROM f_stock WHERE x_ref='%s';""" % code
    curs.execute(query)
    query = """DELETE FROM f_histo WHERE x_ref='%s';""" % code
    curs.execute(query)


def delete_stock(curs, code):
    query = """DELETE FROM f_stock WHERE x_ref='%s';""" % code
    curs.execute(query)


def delete_poste(curs, code):

    query = """DELETE FROM f_poste WHERE x_poste = '%s';""" % code
    curs.execute(query)
    query = """DELETE FROM f_mag WHERE x_type_mag = '%s';""" % code
    curs.execute(query)
    query = """DELETE FROM f_dest WHERE x_secteur = '%s';""" % code
    curs.execute(query)


def delete_service(curs, code):
    query = """DELETE FROM f_dest WHERE x_dest='%s';""" % code
    curs.execute(query)


def delete_liste(curs):
    query = """DELETE FROM f_item WHERE 1=1;"""
    curs.execute(query)
    query = """DELETE FROM f_liste WHERE 1=1;"""
    curs.execute(query)
    query = """DELETE FROM f_liste_error WHERE 1=1;"""
    curs.execute(query)


def delete_config(curs, poste='TOUS'):
    query = """DELETE FROM f_config WHERE x_poste='%s' AND x_cle='cfg';""" % (poste,)
    curs.execute(query)
    query = """DELETE FROM f_config WHERE x_poste='TOUS' AND x_cle='cfg' AND x_prop LIKE 'k_rdl_printer%';"""
    curs.execute(query)


def delete_format(curs, tray):
    query = """DELETE FROM f_format WHERE x_format='%s';""" % (tray,)
    curs.execute(query)


def delete_address(curs, mag):
    query = """DELETE FROM f_adr WHERE x_mag='%s';""" % (mag,)
    curs.execute(query)
    query = """DELETE FROM f_adr WHERE x_adr like '%s%%';""" % (mag,)
    curs.execute(query)


try:
    delete_reference(cr, "ECO6547")
    delete_reference(cr, "DEE9999")
    delete_reference(cr, "ECO9999")
    delete_reference(cr, "ECO9876")
    delete_reference(cr, "ECO8754")
    delete_reference(cr, "ECO6521")
    delete_reference(cr, "DEE9999")
    delete_reference(cr, "DEE9998")
    delete_reference(cr, "ECO/6666")
    delete_stock(cr, "ECO6547")
    delete_poste(cr, "RIEDL_00")
    delete_poste(cr, "RIEDL_99")
    delete_service(cr, "9999")
    delete_service(cr, "WARD00")
    delete_service(cr, "S001")
    delete_liste(cr)
    delete_config(cr, "RIEDL_00")
    delete_config(cr, "RIEDL_99")
    delete_format(cr, "BACTEST")
    delete_address(cr, "T01")
    mydb.commit()
finally:
    print("\n DONE")
    if mydb:
        mydb.close()
