[![pipeline status](https://gitlab.com/eco-dex/python-median/badges/master/pipeline.svg)](https://gitlab.com/eco-dex/python-median/commits/master)

[![coverage report](https://gitlab.com/eco-dex/python-median/badges/master/coverage.svg)](https://gitlab.com/eco-dex/python-median/commits/master)

# Python Median

Librairie Python de gestion de Median


# Developpement

## Récupération du code

On commence par cloner le dépôt

`git clone https://gitlab.com/eco-dex/python-median.git`

### création d'un branche manuelle

puis ensuite on créer une branche

`git checkout -b "ma_nouvelle_branche"`

ensuite on pousse cette branche

`git push -u origin "ma_nouvelle_branche"`

## Mise à jour

Pour mettre à jour son code ou sa branche de développement depuis les dernières modifications de la branche master

```
git stash
git fetch origin
git rebase origin/master
git stash pop
```

ensuite on pousse les modifications en forçant sa branche

```
git push -f
```

## Installation VirtualEnv

```
pipenv install -d
pip install -e .
```

Ensuite la librairie est chargée en mode développement.

Chaque modification est instantanément pris en compte

## Validation en local

Pour valider le code, il faut lancer

```
flake8
```

Pour pour les tests et la couverture

```
pytest -vv . --cov=median
```


