import logging
from .base import MedianLibException


logger = logging.getLogger('median')


def compute_gtin_checksum(gtin, fullcode=False):
    """
    Compute the barcode checksum
    """
    if not gtin:
        raise MedianLibException("GTIN cannot be null!")

    if len(gtin) != 12:
        raise MedianLibException("GTIN must have 12 characters!")

    checksum_char = str((10 - sum((3, 1)[i % 2] * int(n) for i, n in enumerate(reversed(gtin)))) % 10)

    return fullcode and (gtin + checksum_char) or checksum_char
