from peewee import AutoField, CharField, IntegerField, DateTimeField
from peewee import SQL

from ..base import BaseModel


class Gtin(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    cip = CharField(
        column_name='x_cip', max_length=20, constraints=[SQL("DEFAULT ''")])
    ucd = CharField(
        column_name='x_ucd',  max_length=20, constraints=[SQL("DEFAULT ''")])
    qt_blister = IntegerField(
        column_name='x_qt_blister', constraints=[SQL("DEFAULT 0")], default=0)
    qt_boite = IntegerField(
        column_name='x_qt_boite', constraints=[SQL("DEFAULT 0")], default=0)
    dossier = CharField(
        column_name='x_index_dossier', max_length=20,
        constraints=[SQL("DEFAULT '0'")], default="0")
    qt_pass = IntegerField(
        column_name='x_qt_pass', constraints=[SQL("DEFAULT 0")], default=0)
    qt_coupe = IntegerField(
        column_name='x_qt_coupe', constraints=[SQL("DEFAULT 0")], default=0)
    date_der_coupe = DateTimeField(
        column_name='x_date_der_coupe',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    delai_peremption = IntegerField(
        column_name='x_delai_peremption', null=True,
        constraints=[SQL("DEFAULT 0")], default=0)
    delai_a_saisir = IntegerField(
        column_name='x_delai_a_saisir', null=True,
        constraints=[SQL("DEFAULT 0")], default=0)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    last_update = DateTimeField(
        column_name='x_update',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    last_user = CharField(
        column_name='x_last_user',  max_length=35,
        constraints=[SQL("DEFAULT '0'")], default="")

    class Meta:
        table_name = 'f_ucd_cip'
        indexes = (
            (('x_cip', 'x_ucd', 'x_index_dossier'), True),
            (('x_cip',), False),
            (('x_ucd',), False),
        )


class GtinAlias(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    source = CharField(
        column_name='x_source', max_length=20,
        constraints=[SQL("DEFAULT ''")], default="")
    destination = CharField(
        column_name='x_destination', max_length=20,
        constraints=[SQL("DEFAULT ''")], default="")

    class Meta:
        table_name = 'f_cip_alias'
        indexes = (
            (('x_source', 'x_destination'), True),
            (('x_source',), False),
            (('x_destination',), False),
        )


# def Cip(*args, **kwargs):
#     from warnings import warn
#     warn("Use Gtin class instead ! Cip is deprecated")
#     return Gtin(*args, **kwargs)

Cip = Gtin
