var users_table;

function select_groupe() {
    const myNode = document.getElementById("h_menu");
    myNode.textContent = '';

    if ($('#h_groupe').val() == "Choix du groupe") {
        return
    }

    $.ajax({
        url: "/api/menu",
        cache: false,
        data: {
            profil: $('#h_groupe').val(),
        }
    })
    .done(function(menu) {
        if (menu.length > 0) {
            $('#h_menu').append(`<div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <label title="Modification" style="float:right" class="bleu_jerome_devant rounded-0 bt"><i class="stock_table_icon fas fa-edit bt"></i></label>
                        <label title="Modification" style="float:right" class="bleu_jerome_devant rounded-0 bt"><i class="stock_table_icon fas fa-eye bt"></i></label>
                    </div>
                </div>
            </div>`);
            for ( var i = 0; i < menu.length ; i++) {
                $('#h_menu').append(`<div class="form-group">
                <span class="form-control-label">${menu[i].nom_profil}</span>
                <label class="custom-toggle custom-toggle-default" style="float: right">
                    <input type="checkbox" class="ck" id=${menu[i].profil} onclick="onSelectClick(this,'edit')" name=${menu[i].profil} value="1">
                    <span class="custom-toggle-slider rounded-circle"></span>
                </label>
                <label class="custom-toggle custom-toggle-default ck"" style="float: right">
                    <input type="checkbox" class="ck" id=${menu[i].profil_bis} onclick="onSelectClick(this,'visu')" name=${menu[i].profil} value="1">
                    <span class="custom-toggle-slider rounded-circle "></span>
                </label>
            </div>`);

            if (menu[i].checked == 1) {
                document.getElementById(menu[i].profil).checked = true;
            }


            if (menu[i].visu == 1) {
                document.getElementById(menu[i].profil_bis).checked = true;
            }
            if (menu[i].edit == 1) {
                document.getElementById(menu[i].profil).checked = true;
            }
        }

        }
    });
}

function onSelectClick(element, mode) {

    if (element.checked) {
        valeur = 1;
    } else {
        valeur = 0;
    }

    $.ajax({
        url: "/api/menu",
        cache: false,
        type: 'POST',
        data: {
            profil: $('#h_groupe').val(),
            ressource: element.name,
            mode: mode,
            valeur: valeur
        }
    })

}

function edit_user_line_onclick() {

    var row_indexes = users_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à éditer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    _l=users_table.row(row_indexes[0]).data();

    get_profil(_l.profil);

    $('#i_user_line_edit_nom').val(_l.user);
    $('#i_user_line_edit_password').val(_l.password);
    $('#i_user_line_edit_email').val(_l.email);

    if (_l.maintenance==1) {
        document.getElementById("maintenance").checked = true
    } else {
        document.getElementById("maintenance").checked = false
    }

    if (_l.stupefiant==1) {
        document.getElementById("stupefiant").checked = true
    } else {
        document.getElementById("stupefiant").checked = false
    }

    $('#modal-form-edit-user-line').modal('show');
}

function add_user_line_onclick() {
    get_profil("-");
    $('#i_user_line_add_nom').val("");
    $('#i_user_line_add_password').val("");
    $('#i_user_line_edit_email').val("");
    document.getElementById("maintenance1").checked = false
    document.getElementById("stupefiant1").checked = false
    $('#modal-form-add-user-line').modal('show');
}


$("#f_edit_user_line").submit(function(event) {

    event.preventDefault();

    // vérifier que tous les champs sont renseignés
    // if ( $('#modal-move-container-service-select').val() == '-' ) {
    //     $('#move_container_error_notif').html('<p class="mb-0">Veuillez indiquer le service imputé.</p>');
    //     $('#move_container_error_notif').show(400);
    //     return false;
    // }

    var row_indexes = users_table.rows( { selected: true } )[0];

    _l=users_table.row(row_indexes[0]).data();


    $.ajax({
        url: "/api/users",
        type: 'PUT',
        data: {
            pk: _l.pk,
            user: $('#i_user_line_edit_nom').val(),
            password: $('#i_user_line_edit_password').val(),
            email: $('#i_user_line_edit_email').val(),
            profil: $('#modal-edit-user-line-profil-select').val(),
            maintenance: document.getElementById("maintenance").checked,
            stupefiant:document.getElementById("stupefiant").checked
        },
        success: function(product) {

            users_table.draw();

            $('#move_container_error_notif').hide(400);
            users_table.draw();
            $('#modal-form-edit-user-line').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Utilisateur modifié.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $('#move_container_error_notif').html('<p class="mb-0">Problème rencontré lors de la mise à jour de l utilisteur.</p>');
            $('#move_container_error_notif').show(400);
        }
    });

});


$("#f_add_user_line").submit(function(event) {

    event.preventDefault();

    // vérifier que tous les champs sont renseignés
    // if ( $('#modal-move-container-service-select').val() == '-' ) {
    //     $('#move_container_error_notif').html('<p class="mb-0">Veuillez indiquer le service imputé.</p>');
    //     $('#move_container_error_notif').show(400);
    //     return false;
    // }

    $.ajax({
        url: "/api/users",
        type: 'GET',
        data: {
            user: $('#i_user_line_add_nom').val(),
            password: $('#i_user_line_add_password').val(),
            profil: $('#modal-add-user-line-profil-select').val(),
            maintenance: document.getElementById("maintenance1").checked,
            stupefiant:document.getElementById("stupefiant1").checked
        },
        success: function(product) {
            $('#move_container_error_notif').hide(400);
            users_table.draw();
            $('#modal-form-add-user-line').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Utilisateur créé.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $('#move_container_error_notif').html('<p class="mb-0">Problème rencontré lors du déplacement du contenant.</p>');
            $('#move_container_error_notif').show(400);
        }
    });

});

function onDeleteUserClick() {
    var row_indexes = users_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à éditer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    _l = users_table.row(row_indexes[0]).data();

    $('#modal-delete-user-line').modal('show');

}

function onDeleteModalClick(b_empty_container, service_code) {

    var row_indexes = users_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à supprimer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    _l = users_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/users",
        type: 'DELETE',
        data: {
            pk: _l.pk,
        },
        success: function() {
            users_table.draw();
            $('#modal-delete-user-line').modal('hide');
            users_table.draw();
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Utilisateur supprimé'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(error) {
            $.notify({
                icon: 'ni ni-check-bold',
                'message': error.responseText
            }, {
                'type': 'danger',
                'placement.align': 'center',
                'delay': 3000
            });
        }
    });

}


function add_group_onclick() {

    $('#i_user_line_add_group').val("");

    $('#group_add_error_notif').hide();

    $('#modal-form-add-group').modal('show');

}


$("#f_add_group_line").submit(function(event) {

    event.preventDefault();

    $.ajax({
        url: "/api/profils",
        type: 'post',
        data: {
            profil: $('#i_user_line_add_group').val(),
        },
        success: function(product) {

            users_table.draw();
            $('#modal-form-add-group').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Groupe créé.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });

            get_profil("-");

        },
        error: function(data) {
            $('#group_add_error_notif').html('<p class="mb-0">Le groupe existe déjà.</p>');
            $('#group_add_error_notif').show(400);
        }
    });

});

function btnExport(){
    var htmltable= document.getElementById('tableau_stock');
    var html = htmltable.outerHTML;
    window.open('data:application/vnd.ms-excel,' + encodeURIComponent(html));
 }


 function onPrintUserClick() {
    var row_indexes = users_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à imprimer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    document.getElementById("qrcode").innerHTML="";

    _l = users_table.row(row_indexes[0]).data();

    $('#qrcode').qrcode(_l.password);

    $('#modal-print-user-line').modal('show');

}

// document.getElementById("btnPrint").onclick = function () {
//     Popup($(elem).html());
// }


// Save | Download image
// function downloadImage(data, filename = 'untitled.jpeg') {
//     var a = document.createElement('a');
//     a.href = data;
//     a.download = filename;
//     document.body.appendChild(a);
//     a.click();
// }

function PrintElem(elem) {

    html2canvas(document.getElementById("qrcode")).then(function (canvas) {			var anchorTag = document.createElement("a");
    document.body.appendChild(anchorTag);

    // document.getElementById("previewImg").appendChild(canvas);
    anchorTag.download = "QRCode.jpg";
    anchorTag.href = canvas.toDataURL();
    anchorTag.target = '_blank';
    anchorTag.click();

});


}


function get_profil(profil_user) {
    var myNode = document.getElementById("modal-edit-user-line-profil-select");
    myNode.textContent = '';

    myNode = document.getElementById("modal-add-user-line-profil-select");
    myNode.textContent = '';

    profil_select=$('#h_groupe').val();

    myNode = document.getElementById("h_groupe");
    myNode.textContent = '';

    $('#modal-edit-user-line-profil-select').append(`<option>-</option>`);
    $('#modal-add-user-line-profil-select').append(`<option>-</option>`);
    $('#h_groupe').append(`<option>Choix du groupe</option>`);


    // chercher la liste des profils
    $.ajax({
        url: "/api/profils",
        cache: false
    })
    .done(function(profil) {
        if (profil.length > 0) {

            for ( var i = 0; i < profil.length ; i++) {
                $('#modal-edit-user-line-profil-select').append(`<option value="${profil[i].profil}">${profil[i].profil}</option>`);
                $('#modal-add-user-line-profil-select').append(`<option value="${profil[i].profil}">${profil[i].profil}</option>`);
                $('#h_groupe').append(`<option value="${profil[i].profil}">${profil[i].profil}</option>`);
            }
        }
        document.getElementById('modal-edit-user-line-profil-select').value=profil_user;
        document.getElementById('h_groupe').value=profil_select;

    });

}


$(document).ready(function() {


    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    // chercher la liste des profils
    $.ajax({
        url: "/api/profils",
        cache: false
    })
    .done(function(profil) {
        if (profil.length > 0) {

            for ( var i = 0; i < profil.length ; i++) {
                $('#h_groupe').append(`<option value="${profil[i].profil}">${profil[i].profil}</option>`);
            }
        }
    });

    function _create_bouton() {
        $('#tableau_users_wrapper').children().first().children().last().html(`

            <button title="Imprimer le code" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="onPrintUserClick();"><i class="stock_table_icon fas fa-print"></i></button>
            <button title="Supprimer un uilisateur" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="onDeleteUserClick();"><i class="stock_table_icon fas fa-trash"></i></button>
            <button title="Créer un utilisateur" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="add_user_line_onclick();"><i class="stock_table_icon fas fa-plus"></i></button>
            <button title="Modifier un utilisateur" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="edit_user_line_onclick();"><i class="stock_table_icon fas fa-pen"></i></button>
            `);

    }


    // get user data
    users_table = $('#tableau_users').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: '/api/datatable/users',
            type: 'POST',
        },
        rowId: 'pk',
        "columns": [{
            "data": null
        }, {
            "data": "user"
        }, {
            "data": "profil"
        }, {
            "data": "email"
        },{
            "data": "maintenance"
        }, {
            "data": "stupefiant"
        }, {
            "data": "pk",
            "visible": false
        }, {
            "data": "password",
            "visible": false
        }, {
            "data": "profil",
            "visible": false
        }],
        "scrollY": "545px",
        "sScrollX": "100%",
        "scrollX": true,
        "scrollCollapse": true,
        "searching": false,
        "paging": true,
        "pageLength": 100,
        "info": false,
        "columnDefs": [{
            targets: 0,
            data: null,
            defaultContent: '',
            orderable: false,
            className: 'select-checkbox'
        },{
            targets: 4,
            render: function ( data, type, row ) {
                if ( type === 'display' ) {
                    return '<input type="checkbox" ' + ((data == 1) ? 'checked' : '') + ' id="input" class="filter-ck" />';
                }
                return data;
              },
              className: "dt-body-center"
             },
             {targets: 4, className: "dt-body-center"},
        {
            targets: 5,
            render: function ( data, type, row ) {
                if ( type === 'display' ) {
                    return '<input type="checkbox" ' + ((data == 1) ? 'checked' : '') + ' id="input1" class="filter-ck" />';
                }
                return data;
                },
                className: "dt-body-center"
                },
                {targets: 5, className: "dt-body-center"},

          ],
        select: {
        style: 'os',
        // selector: 'td:not(:nth-child(2))'
        },
        "select": {
            style:    'single'
        },
        lengthMenu: [ [10, 25, 50, 100, 200, 10000000], ['10', '25', '50', '100', '200', 'Tout'] ],
        // "drawCallback": function( settings ) {
        //     var api = this.api();

        //     // Output the data for the visible rows to the browser's console
        //     // console.log( api.rows( {page:'current'} ).data() );
        //     // console.log(stock_table.page.info())
        //     document.getElementById('lbltipAddedComment').innerHTML = stock_table.page.info().recordsTotal + " emplacements";
        // },

    });

    $("#tableau_users").on('change',"input[type='checkbox']",function(e){

        var tr = $(this).closest("tr");
        var rowindex = tr.index();

        _l=users_table.row(rowindex).data();

        // alert(_l.pk)

        if (e.target.id=="input") {

            var checked = $(this).prop('checked');

            checked1=_l.stupefiant
        }

        if (e.target.id=="input1") {

            var checked1 = $(this).prop('checked');

            checked=_l.maintenance
        }

        $.ajax({
            url: "/api/users",
            type: 'PUT',
            data: {
                pk: _l.pk,
                user: _l.user,
                password: _l.password,
                profil: _l.profil,
                maintenance: checked,
                stupefiant: checked1,
                email: _l.email
            }
        });
    });

    _create_bouton();


});
