// get product reference
// product_ref = window.location.search.substr(1);
// product_ref = '158978'
// variable used for handling the stock table
var stock_table;

var v_bloque;
var fonction;


// needed to communicate format field in f_adr
function ecoBasicEncodeURIComponent(str) {
    return str.replace(' ', '__').replace('/', '--');
}



function onSelectStockTableColumns(columnId) {

    var serializedData = $('#f_select_stock_table_columns').serialize();

    if ( serializedData == '' ) {
        $('#select_stock_table_columns_error_notif_text').html("Veuillez cocher au-moins une colonne.");
        $('#select_stock_table_columns_error_notif').show(400);
     //   return false;
    }
    else {
        $('#select_stock_table_columns_error_notif').hide(400);
    }

    var col = stock_table.columns(columnId);

    col.visible( ! col.visible()[0] );

    return false;
}

$("#f_select_stock_table_columns").submit(function(event) {

    event.preventDefault();
    $('#modal-form-select-stock-table-columns').modal('hide');

});


function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}


function blocage_onclick() {

    if ( ! doesTableHaveASelectedRow(stock_table) ) return false;
    // var row_indexes = stock_table.rows( { selected: true } )[0];
    // _l = stock_table.row(row_indexes[0]).data();

    $.each(stock_table.rows('.selected').nodes(), function(i, item) {
        var data = stock_table.row(this).data();


        $.ajax({
            url: "/api/datatable/emplacements",
            type: 'PUT',
            data: {
                'adr': data.adr,
                'bloque': "1",
                'etat': "X"
            },
            success: function(cnt) {

                stock_table.draw();
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Emplacement bloqué'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });
            },
            error: function(error) {
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Un problème technique est survenu.'
                }, {
                    'type': 'danger',
                    'placement.align': 'center',
                    'delay': 3000
                });
            }
        });
    });
}

function deblocage_onclick() {
    if ( ! doesTableHaveASelectedRow(stock_table) ) return false;

    $.each(stock_table.rows('.selected').nodes(), function(i, item) {
        var data = stock_table.row(this).data();



        $.ajax({
            url: "/api/datatable/emplacements",
            type: 'PUT',
            data: {
                'adr': data.adr,
                'bloque': "0",
                'etat': data.etat
            },
            success: function(cnt) {

                stock_table.draw();
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Emplacement débloqué'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });
            },
            error: function(error) {
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Un problème technique est survenu.'
                }, {
                    'type': 'danger',
                    'placement.align': 'center',
                    'delay': 3000
                });
            }
        });
    });
}

function atteindre_reference_click() {
    if ( ! doesTableHaveASelectedRow(stock_table) ) return false;

    var row_indexes = stock_table.rows( { selected: true } )[0];
    _l = stock_table.row(row_indexes[0]).data();

    if (_l.reference!=null) {
        window.location.href = "/reference.html?" + _l.reference;
        sessionStorage.setItem("ref", _l.reference);
    } else {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Emplacement sans produit !'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
    }
}

function onDeleteContenantClick() {
    if ( ! doesTableHaveASelectedRow(stock_table) ) return false;
    // var row_indexes = stock_table.rows( { selected: true } )[0];
    // _l = stock_table.row(row_indexes[0]).data();

    $.each(stock_table.rows('.selected').nodes(), function(i, item) {
        var data = stock_table.row(this).data();

        if (data.contenant == '') {
            $.notify({
                icon: 'ni ni-air-baloon',
                'message': 'Emplacement déjà vide de contenant'
            }, {
                'type': 'warning',
                'placement.align': 'center',
                'delay': 3000
            });
            return
        }

        if (data.reference != null) {
            $.notify({
                icon: 'ni ni-air-baloon',
                'message': 'Emplacement non vide'
            }, {
                'type': 'warning',
                'placement.align': 'center',
                'delay': 3000
            });
            return
        }

        $.ajax({
            url: "/api/magasins",
            type: 'PUT',
            data: {
                'adr': data.adr,
                'type': 'suppression'
            },
            success: function(cnt) {

                stock_table.draw();
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Contenant supprimé'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });
            },
            error: function(error) {
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Un problème technique est survenu.'
                }, {
                    'type': 'danger',
                    'placement.align': 'center',
                    'delay': 3000
                });
            }
        });
    });
}

function onAddContenantClick() {
    if ( ! doesTableHaveASelectedRow(stock_table) ) return false;
    var row_indexes = stock_table.rows( { selected: true } )[0];
    _l = stock_table.row(row_indexes[0]).data();
    console.log(_l.adr)
    $.each(stock_table.rows('.selected').nodes(), function(i, item) {
        var data = stock_table.row(this).data();


        if (data.contenant != '') {
            $.notify({
                icon: 'ni ni-air-baloon',
                'message': 'Emplacement avec déjà un contenant'
            }, {
                'type': 'warning',
                'placement.align': 'center',
                'delay': 3000
            });
            return
        }

        $.ajax({
            url: "/api/magasins",
            type: 'PUT',
            data: {
                'adr': data.adr,
                'type': 'ajout_contenant'
            },
            success: function(cnt) {

                stock_table.draw();
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Contenant créé'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });
            },
            error: function(error) {
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Un problème technique est survenu.'
                }, {
                    'type': 'danger',
                    'placement.align': 'center',
                    'delay': 3000
                });
            }
        });
    });
}




function onFiltrerModalClick() {

    // var radios = document.getElementsByName('custom-radio-1');
    // var valeur;
    // for(var i = 0; i < boutons.length; i++){
    //     if(boutons[i].checked){
    //     valeur = boutons[i].value;
    //     }
    // }
    // var valeur = document.querySelector('input[name=custom-radio-1]:checked').value;

    // var boite = $('.boite');
    // var bac = $('.bac');
    var bloque = $('.bloque');
    fonction = document.querySelector("input[name=custom-radio-1]:checked").value;

    const checkboxes = document.querySelectorAll(`input[name=format_table_column_check]:checked`);
    let values = [];
    checkboxes.forEach((checkbox) => {
        values.push(checkbox.value);
    });
    // alert(values);

    // alert(fonction);

    if (bloque[0].checked) {
        v_bloque=1
    } else {
        v_bloque=0
    }

    // v_format=("BOITE PASS,BAC,TIROIR 1/3,TIROIR 1/4,TIROIR 1/5")

    // if (boite[0].checked && bac[0].checked) {
    //     v_format=("BOITE PASS,BAC")
    // } else {
    //     if (boite[0].checked) {
    //         v_format=("BOITE PASS")
    //     } else {
    //         if (bac[0].checked) {
    //             v_format=("BAC")
    //         }
    //     }
    // }

    v_format=values.join();

    stock_table.draw();
    $('#modal-form-select-stock-table-filtre').modal('hide');

}

// Handle filter by magasin
function magfilter_onclick() {

    var fc = $('.mag_filter_chk');
    var mags = [];

    for (var i = 0; i < fc.length; i++)
        if (fc[i].checked)
            mags.push(fc[i].value)

    if (mags.length>0) {
        $('#filterByMagasin').val(mags.join());
    } else {
        $('#filterByMagasin').val(" ");
    }

    stock_table.draw();

    $('#modal-form-filtrer-par-magasin').modal('hide');
}



function _create_stock_cards(mag) {
    for (i = 0; i < mag.length; i++) {
        $('#stock_cards_row').append(`
        <div class="col-3 stock_card_mag_col">
        <div class="card stock_card">
            <!-- Card body -->
            <div class="card-body">
                <div class="row">
                    <div class="col">
                        <h5 style="font-size: 1rem" class="card-title text-uppercase text-muted mb-0">Stock ${mag[i].mag} ${mag[i].type_mag}
                        <label class="custom-toggle  custom-toggle-default" style="float: right">
                            <input type="checkbox" onchange="magfilter_onclick(); return false;" type="submit" class="mag_filter_chk" name="mag_filter_check" value='${mag[i].mag}' checked>
                            <span class="custom-toggle-slider rounded-circle"></span>

                        </label>
                    </div>
                </div>

            </div>
        </div>
    </div>`);
    }
}

function btnExport(){
    var htmltable= document.getElementById('tableau_stock');
    var html = htmltable.outerHTML;
    window.open('data:application/vnd.ms-excel,' + encodeURIComponent(html));
 }


$(document).ready(function() {


    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });



    function _create_magasin_filter() {
        $('#tableau_stock_wrapper').children().first().children().last().html(`

        <!-- <button title="Filtre par emplacement" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" data-toggle="modal" data-target="#modal-form-select-stock-table-filtre-emplacement"><i class="stock_table_icon fab fa-mixer"></i></button> -->
            <button title="Filtre" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" data-toggle="modal" data-target="#modal-form-select-stock-table-filtre"><img src="./static/img/icons/median/filtrer.png" width="35"></i></button>
            <button title="Choix des colonnes" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" data-toggle="modal" data-target="#modal-form-select-stock-table-columns"><i class="stock_table_icon fas fa-th"></i></button>
            <button id="bt1" title="Créer un contenant" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="onAddContenantClick();"><img src="./static/img/icons/median/creer.png" width="35"></i></button>
            <button id="bt2" title="Supprimer le contenant" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="onDeleteContenantClick();"><i class="stock_table_icon fas fa-trash"></i></button>
            <button title="Voir la fiche référence" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="atteindre_reference_click();"><img src="./static/img/icons/median/blister.png" width="35"></button>
            <button id="bt3" title="Déblocage" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="deblocage_onclick();"><img src="./static/img/icons/median/debloquer.png" width="35"></button>
            <button id="bt4" title="Blocage" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="blocage_onclick();"><img src="./static/img/icons/median/bloquer.png" width="35"></button>
            <button title="Export vers Excel" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="btnExport();"><img src="./static/img/icons/median/Export vers excel.png" width="35"></button>
            <h5 id="lbltipAddedComment" class="card-title text-uppercase text-muted mb-2" style="font-size:1rem !important"></h5>
            `);

        if (sessionStorage.edit!=1) {
            document.getElementById("bt1").outerHTML = "";
            document.getElementById("bt2").outerHTML = "";
            document.getElementById("bt3").outerHTML = "";
            document.getElementById("bt4").outerHTML = "";
        }

    }

    $.ajax({
        url: "/api/container_formats",
        cache: false
    })
    .done(function(containers) {
            // $('#f_select_stock_table_filtre').html($('#f_select_stock_table_filtre').children().first());
            containers.reverse();
            for (var i = 0; i < containers.length; i++) {
                $('#f_select_stock_table_filtre').prepend(`
                <div class="form-group">
                <span class="form-control-label">${containers[i].format}</span>
                <label class="custom-toggle custom-toggle-default" style="float: right">
                    <input type="checkbox" class="${containers[i].format}" name="format_table_column_check" value="${containers[i].format}" checked>
                    <span class="custom-toggle-slider rounded-circle"></span>
                </label>
            </div>`);
            }
    })

    // get product
    $.ajax({
        url: "/api/magasins" ,
        cache: false,
        statusCode: {
            404: function() {
                window.location.replace('/reference.html');
            }
        }
    })


    .done(function(mag) {

        _create_stock_cards(mag);
        _create_magasin_filter();


    });


    v_bloque=-1
    v_format=null


    // get stock data
    stock_table = $('#tableau_stock').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: '/api/datatable/emplacements',
            type: 'POST',
            data: function(data) {
                data.filterByMagasin = $('#filterByMagasin').val(),
                data.bloque= v_bloque,
                data.format= v_format,
                data.fonction = fonction
            }
        },
        "columns": [{
            "data": null
        }, {
            "data": "bloque"
        }, {
            "data": "libelle"
        }, {
            "data": "adr"
        }, {
            "data": "format"
        }, {
            "data": "contenant"
        }, {
            "data": "etat"
        }, {
            "data": "quantite"
        }, {
            "data": "fraction"
        }, {
            "data": "reference"
        }, {
            "data": "designation"
        }, {
            "data": "ucd"
        }, {
            "data": "sortie"
        }, {
            "data": "entree"
        }, {
            "data": "lot"
        }, {
            "data": "peremp"
        }],
        "scrollY": "545px",
        "sScrollX": "100%",
        "scrollX": true,
        "scrollCollapse": true,
        "searching": false,
        "paging": true,
        "pageLength": 100,
        "info": false,
        "columnDefs": [{
            targets: 0,
            data: null,
            defaultContent: '',
            orderable: false,
            className: 'select-checkbox'
        },{
            targets: 1,
            render: function(data, type, row, meta) {
                if (data > '0' ) {
                    return '<i class="ni ni-lock-circle-open" title="L\'emplacement est bloqué!"></i>';
                }
                return '';
            }
        }],
        "select": {
            style:    'multi'
        },
        lengthMenu: [ [10, 25, 50, 100, 200, 10000000], ['10', '25', '50', '100', '200', 'Tout'] ],
        "drawCallback": function( settings ) {
            var api = this.api();

            // Output the data for the visible rows to the browser's console
            // console.log( api.rows( {page:'current'} ).data() );
            // console.log(stock_table.page.info())
            document.getElementById('lbltipAddedComment').innerHTML = stock_table.page.info().recordsTotal + " emplacements";
        },

    });



    $('#i_add_stock_line_date_peremption').datepicker({
        // inline: true,
        language: 'fr',
        dateFormat: 'dd-mm-yyyy',
        minDate: new Date(),
        classes: 'eco_datepicker',
        autoClose: true,
        position: "left top"
    });

    $('#i_edit_stock_line_date_peremption').datepicker({
        // inline: true,
        language: 'fr',
        dateFormat: 'dd-mm-yyyy',
        minDate: new Date(),
        classes: 'eco_datepicker',
        autoClose: true,
        position: "left top"
    });

});
