/**
 * S execute automatiquement lorsque la page est chargée
 */
 window.addEventListener("DOMContentLoaded", (event) => {
    console.log("DOM entièrement chargé et analysé");
    mweb_execute_partial('menu.hbs', 'menu-id', 'api/ui/menu', 'get', {}, 'sidenav-main');
    mweb_execute_template('topnav-main');
    init_page();
    load_lists();
});

var items_table;

function load_lists() {
    $.ajax({
        url: "/api/riedl/listes_sorties",
        type: 'GET',
        data: {
            'riedl': ''
        }
    }).done(function(response) {
        console.log(response);

        if (response.length == 0 ) {
            $('#riedl_sortie_liste').html('Aucune liste de chargement en cours.');
            return;
        }

        $('#riedl_sortie_liste').jstree({
            'core': {
                'data' : response.listes
            }
        });

        $('#riedl_sortie_liste').bind('loaded.jstree', function(e, data) {
            // invoked after jstree has loaded
            $(this).jstree("open_all");
            //$(this).jstree("select_node", data1);

            // $('#ucd_cip_tree_div').jstree(true).select_node(response.listes);

        })

        $('#riedl_sortie_liste').on("select_node.jstree", function(evt, data) {
            console.debug('node-select: ' + data.node.id);
            console.debug('node-length: ' + data.node.parents.length);
            list_name = data.node.id.substring(6);
            console.log('list_name: ' + list_name);
            //console.log('item_table: ' + items_table);
            // if (data.node.parents.length >= 2) {
            if (data.node.id.startsWith('model-')) {
                $('#div_tableau_items').show();
                $('#list_items_titre').html(data.node.id);
                $('#div_tableau_listes').hide();
                document.getElementById('atteindre_reference').style.visibility="visible";
                document.getElementById('button_unload_list').style.visibility="visible";
                document.getElementById('button_delete_list').style.visibility="visible";
                $('#button_delete_list').data('model-id', list_name);
                $('#button_unload_list').data('model-id', list_name);
                items_table = datatable_list(list_name, items_table);
                items_table.draw();
                items_table.columns().checkboxes.deselect(true);
                get_liste(list_name);
            } else {
                $('#div_tableau_items').hide();
                $('#list_items_titre').html(list_name);
                document.getElementById('atteindre_reference').style.visibility="hidden";
                document.getElementById('button_unload_list').style.visibility="hidden";
                document.getElementById('button_delete_list').style.visibility="hidden";
            }

        });
    })
}

function get_liste(list_name) {
    // Retrieve the list content
    var deferred = $.Deferred();

    deferred.done(function(value) {
        console.log('liste load OK');
        var endp = [];
        var prio = [];
        // fill the select endpoint
        value.selection.endpoint.forEach(function(item){
            endp.push({value: item.type_peigne, name: item.libelle});
        })
        form_select_element('riedlExit', endp, value.data.no_pilulier, function(val) {
            console.log('riedl Exit value: ' + val);
            $.ajax({
                url: "/api/riedl/listes_sorties",
                type: "PATCH",
                data: {
                    field: "no_pilulier",
                    value: val,
                    liste: list_name
                }
            }).done(function(response) {
                console.log(response);
            });
        });
        // select the priority
        value.selection.priority.forEach(function(item){
            prio.push({value: item.value, name: item.name});
        })
        form_select_element('riedlPriority', prio, value.data.pos_pilulier, function(val) {
            console.log('riedl Priority value:' + val);
            $.ajax({
                url: "/api/riedl/listes_sorties",
                type: "PATCH",
                data: {
                    field: "pos_pilulier",
                    value: val,
                    liste: list_name
                }
            }).done(function(response) {
                console.log(response);
            });
        });
        form_checkbox_element('riedlTakingMode', value.data.valide_sel, function(val) {
            console.debug('riedl Prelevement value:' + val);
            var intval = 0;
            if (val == true) {
                intval = 1;
            }
            $.ajax({
                url: "/api/riedl/listes_sorties",
                type: "PATCH",
                data: {
                    field: "valide_sel",
                    value: intval,
                    type: 'bool',
                    liste: list_name
                }
            }).done(function(response) {
                console.log(response);
            });
        });
    });

    $.ajax({
        url: "/api/riedl/listes_sorties/" + list_name,
        type: "GET",
    }).done(function(response) {
        console.log(response);
        deferred.resolve(response);
    });

}

/**
 * Fill the item of the list in a DatatableZ
 *
 * @param {string} listname Name of the MEdian List
 * @param {HTMLElement} elem CUrrent datatable element
 * @returns
 */
function datatable_list(listname, elem) {
    var uri = '/api/datatable/riedl_sorties_items/' + listname;
    if (elem === undefined) {
        elem = $('#tableau_items').DataTable({
            "language": datatables_lang_fr,
            "processing": true,
            "serverSide": true,
            "stateSave": false,
            "ajax": {
                url: uri,
                type: 'POST'
            },
            "columnDefs": [{
                'targets': 0,
                'searchable': false,
                'orderable': false,
                'checkboxes':{
                    "selectRow": true
                }
            }],
            "select": {
                style:    'multi'
            },
            "columns": [
                {
                    "data": null
                }, {
                    "data": "item"
                }, {
                    "data": "etat"
                }, {
                    "data": "reference"
                }, {
                    "data": "fraction"
                }, {
                    "data": "designation"
                }, {
                    "data": "qte_demandee"
                }, {
                    "data": "qte_servie"
                }, {
                    "data": "moment"
                }, {
                    "data": "heure"
                }
            ],
            "searching": false,
            "paging": false,
            "pageLength": 10,
            "info": false,
            "deferLoading": 0,
            order: []
        });
    } else {
        elem.ajax.url(uri);
    }

    return elem;
}

function atteindre_reference_click() {
    if ( ! DatatableSelectedRow(items_table) ) return false;

    window.location.href = "/reference.html?" + sessionStorage.ref;
}

function execute_unload(elem) {
    alert('OK');
}

function init_page() {
    document.getElementById('button_unload_list').style.visibility="hidden";
    document.getElementById('button_delete_list').style.visibility="hidden";
    $("#button_unload_list").BootConfirm({
        complete: function(elem){
            $.ajax({
                url: "/api/riedl/command_sorties",
                type: "POST",
                data: {
                    liste: $(elem).data('model-id')
                }
            }).done(function(response) {
                console.log('unload: ' + response);
                alert('Lancement effectué');
                window.location.reload();
            }).fail(function(response) {
                console.error('unload error: ' + response);
                alert('Erreur de lancement');
            });
        },
        message: true
    });

    $("#button_delete_list").BootConfirm({
        complete: function(elem){
            console.log($(elem).data('model-id'));
            $.ajax({
                url: "/api/riedl/listes_sorties",
                type: "DELETE",
                data: {
                    liste: $(elem).data('model-id')
                }
            }).done(function(response) {
                console.log('delete: ' + response['liste']);
                window.location.reload();
            });
            // execute_unload();
        },
        message: true
    });
}
