
$( "#f_edit_product" ).submit(function( event ) {

    event.preventDefault();

    var ref = $('#i_edit_ref').val();
    var de = $('#i_edit_desig').val();
    var cm = $('#i_edit_com_med').val();

    var posting = $.post('/api/product/',
            {
                ref : ref,
                designation : de,
                com_med : cm
            });

    posting.done(function( data ) {
        if(data.status != 'Success') {
            $('#product_edit_error_notif_text').html("La référence existe déjà!");
            $('#product_edit_error_notif').show(400);
        }
        else {
            window.location.href = "/reference.html?" + data.ref;
            sessionStorage.storage()
        }
    });

});


$(document).ready(function () {

    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    $('#tableau_ref').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "stateSave": true,
        "ajax": {
            url: '/api/products',
            type: 'POST'
        },
        "columns": [
            {
                "data": "reference"
            }, {
                "data": "designation"
            }, {
                "data": "ucd"
            }
        ],
        "searching": true,
        "paging": true,
        "pageLength": 10,
        "info": false
    });



    // $('#tableau_ref_wrapper').children().first().children().last().prepend(`
    // <button style="float:right; border-radius: 50%" type="button" class="btn btn-sm mr-0 bleu_jerome text-white" data-toggle="modal" data-target="#modal-form-nouveau-produit"><i class="ni ni-fat-add"></i></button>`);
});
