var items_table;
var v_filtre;
var pk_item;
var titre;

function getReapprolistes() {

    $.ajax({
        url: "/api/listes_reappro"
    })
    .done(function(listes) {

        if ( listes.length == 0 ) {
            $('#div_liste_reappros').html('Aucune commande en cours.');
            return;
        }

        _o = '<ul>';
        for ( var i = 0; i < listes.length; i++ ) {
            _pk = listes[i]['pk'];
            _label = listes[i]['label'];
            _o += '<li id="'+_pk+'" class="li1"><a href="#" onclick="list_onclick('+_pk+', \''+_label+'\')">'+_label+'</a></li>'
        }
        _o += '</ul>';
        $('#div_liste_reappros').html(_o);
    });
}

function list_onclick(pk, label) {
    $('#div_tableau_items').show();
    $('#list_items_titre').html(label);
    titre=label;
    $('#filterByMagasin').val("V,E,S");

    $('.vierge')[0].checked = true;
    $('.entame')[0].checked = true;
    $('.solde')[0].checked = true;

    items_table.ajax.url('/api/datatable/liste_reappro_items/'+pk);
    items_table.draw();

    // $('#tableau_items_wrapper').children().first().children().last().html(`
    // <button title="Filtrer par état" style="float:right" type="button" class="btn btn-sm mr-0 bleu_jerome_devant rounded-0" data-toggle="modal" data-target="#modal-form-filtrer"><i class="stock_table_icon fas fa-filter"></i></button>
    // <button title="Supprimer une ligne" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="onDeleteClick();"><i class="stock_table_icon fas fa-trash"></i></button>
    // <button title="Voir la fiche référence" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="atteindre_reference_click();"><img src="./static/img/icons/median/blister.png" width="35"></button>
    // <input type="button" value="Print" onclick="printtabledetails()" />
    // `);

}

function delete_list_click() {

    $.ajax({
        url: "/api/listes_reappro"
    }).done(function(listes) {

        if ( listes.length == 0 ) {
            return;
        }

        _o = '<select style="width:100%" name="del_list_select" id="del_list_select"><option>-</option>';
        for ( var i = 0; i < listes.length; i++ ) {
            _pk = listes[i]['pk'];
            _label = listes[i]['label'];
            _o += '<option value="'+_pk+'">'+_label+'</option>'
        }
        _o += '</select>';
        $('#f_delete_list_sel_div').html(_o);

        $('#modal-form-delete-list').modal('show');
    });
}

$('#f_delete_list').submit(function(event) {

    event.preventDefault();

    var _l = $('#del_list_select').val();

    $.ajax({
        url: "/api/listes_reappro",
        type: 'DELETE',
        data: {
            pk: _l
        },
        beforeSend: function() {
            $('#modal-form-delete-list').modal('hide');
            $("#overlay").modal("show");
         },
         complete: function(){
            $("#overlay").modal("hide");
         },
        success: function(product) {
            $('#delete_list_error_notif').hide(400);

            $('#modal-form-delete-list').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Une commande a été supprimée.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });

            $('#div_tableau_items').hide();
            $('#list_items_titre').html("<< Cliquez sur une commande pour afficher les détails.");
            getReapprolistes();

        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#delete_list_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#delete_list_error_notif').html('<p class="mb-0">Problème lors de la suppression de commande.</p>');
            }

            $('#delete_list_error_notif').show(400);
        },
    });

});

/**
 * On Generate list wizard, add the list to the session storage
 * when click on the button Generate
 */
$('#f_generate_list').submit(function(event) {

    event.preventDefault();

    var _mag = $('#generate_list').val();
    // use sessionstorage to retireve user
    var _user = $('#username').text();
    var _date = new Date().toISOString().slice(0, 10);

    $.ajax({
        url: "/api/calcul_reappro",
        type: 'POST',
        data: {
            mag: _mag
        },
        beforeSend: function() {
            $('#modal-form-generate-list').modal('hide');
            $("#overlay").modal("show");
         },
         complete: function(){
            $("#overlay").modal("hide");
         },
        success: function(lines) {
            // store on the sessionStorage, the result.
            if (sessionStorage.getItem("reappro.calcul")) {
                sessionStorage.removeItem('reappro.calcul');
            }
            sessionStorage.setItem('reappro.calcul', JSON.stringify(lines));
            sessionStorage.setItem('magasin', _mag);

            $('#generate_list_error_notif').hide(400);
            $('#modal-form-generate-list').modal('hide');
            // Launch
            window.location.href = "/calcul_reappro.html";
        },
        error: function (data) {
            var msg = data.responseJSON.message;
            if ( msg == '' ) {
                msg = "Problème lors de la création de commande.";
            }

            $('#generate_list_error_notif').html('<p class="mb-0">' + msg + '</p>');
            $('#generate_list_error_notif').show(400);

        }
    });

});

$('#f_send_list').submit(function(event) {

    event.preventDefault();

    var _mag = $('#send_list').val();
    
    var res = [];
    var liste = "";

    $.ajax({
        url: "/api/reappro",
        method: 'POST',
        data: JSON.stringify({"lines": res, "liste": liste, "type_magasin": _mag, "gpao": "1"}),
        contentType: "application/json",
        dataType: "json",
        success: function(lines) {
            $('#send_list_error_notif').hide(400);
            $('#modal-form-send-list').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Les listes ont été envoyées.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function (data) {
            // var msg = data.responseJSON.message;
            // if ( msg == '' ) {
            //     msg = "Problème lors de la création de commande.";
            // }

            $('#send_list_error_notif').html('<p class="mb-0">' + msg + '</p>');
            $('#send_list_error_notif').show(400);

        }
    });

});

function onFiltrerModalClick() {

    var v_filtre = [];

    if ($('.vierge')[0].checked) {
        v_filtre.push('V')
    }

    if ($('.entame')[0].checked) {
        v_filtre.push('E')
    }

    if ($('.solde')[0].checked) {
        v_filtre.push('S')
    }

    $('#filterByMagasin').val(v_filtre.join());

    items_table.draw();
    $('#modal-form-filtrer').modal('hide');

}

function onDeleteClick() {

    if ( ! doesTableHaveASelectedRow(items_table) ) return false;

    $('#modal-form-delete-item').modal('show');

}

$('#f_delete_item').submit(function(event) {

    event.preventDefault();

    $.each(items_table.rows('.selected').nodes(), function(i, item) {
        var id = item.id;
        var data = items_table.row(this).data();

        $.ajax({
            url: "/api/reappro",
            type: 'DELETE',
            data: { pk_item: id },
            success: function(product) {
                $('#delete_item_error_notif').hide(400);

                $('#modal-form-delete-item').modal('hide');

                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Une ligne de commande a été supprimée.'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });

                items_table.draw();

            },
            error: function(data) {
                var msg = data.responseJSON.message;
                if ( msg != '' ) {
                    $('#delete_item_error_notif').html('<p class="mb-0">' + msg + '</p>');
                }
                else {
                    $('#delete_item_error_notif').html('<p class="mb-0">Problème lors de la suppression d un item d entrée.</p>');
                }

                $('#delete_item_error_notif').show(400);
            }
        });
    });

});

function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}

function atteindre_reference_click() {
    if ( ! doesTableHaveASelectedRow(items_table) ) return false;

    window.location.href = "/reference.html?" + sessionStorage.ref;
}


function btnExport(){
    var htmltable= document.getElementById('tableau_items');
    var html = htmltable.outerHTML;
    window.open('data:application/vnd.ms-excel,' + encodeURIComponent(html));
 }

$(document).ready(function () {

    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });

    // get lists
    getReapprolistes();

    items_table = $('#tableau_items').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        // "stateSave": false,
        "ajax": {
            url: '/api/datatable/liste_reappro_items/',
            type: 'POST',
            data: function(data) {
                data.filterByMagasin = $('#filterByMagasin').val();
            }
        },
        "scrollY": "545px",
        lengthMenu: [ [10, 25, 50, 100, 10000000], ['10', '25', '50', '100', 'Tout'] ],
        "drawCallback": function ( settings ) {

            var api = this.api();

            for (var i = 0; api.rows().count() > i; i++) {
                var rowData = api.row(i).data();
                var rowNode = api.row(i).node();
                var cellNode = api.cell(i, 0).node(); // Can apply same logic to just a cell
                                        // want specific cell to be bolded or some other style --cell(row, column)
                if (rowData.etat == "Entamé") {
                    $(rowNode).addClass("");
                    $(cellNode).addClass("orangeClass");
                } else if (rowData.etat == "Soldé") {
                    $(rowNode).addClass("");
                    $(cellNode).addClass("vertClass");
                }
                // } else { // remove the class in case it was previously added
                //     $(rowNode).removeClass("row-attention");
                //     $(cellNode).removeClass("cell-attention");
                // }
            }

        },
        "select": {
            style:    'multi'
        },
        rowId: 'pk',
        "columns": [
            {
                "data": "etat"
            }, {
                "data": "reference"
            }, {
                "data": "fraction"
            }, {
                "data": "designation"
            }, {
                "data": "qte_demandee", className: "td1"
            }, {
                "data": "qte_servie", className: "td1"
            }
        ],
        "sScrollX": "100%",
        "scrollX": true,
        "searching": false,
        "paging": true,
        "pageLength": 100,
        "info": true,
        "deferLoading": 0,
        order: [],
        // dom: 'Bfrtip',
        // buttons: [
        //     {
        //         customize: function ( win ) {
        //             $(win.document.body)
        //                 .css( 'font-size', '10pt' )

        //             $(win.document.body).find( 'table' )
        //                 .addClass( 'compact' )
        //                 .css( 'font-size', 'inherit' );
        //         }
        //     }
        // ]
        dom: 'lBfrtip',
        buttons: [
            {
                extend: 'print',
                // message: titre,
                messageTop: function(){
                    var printTitle = titre
                    return printTitle
                },
                // title: function(){
                //     var printTitle = titre
                //     return printTitle
                // }

            }
        ]
    });

    $('.dt-buttons').attr('hidden',true);

    items_table.MakeCellsEditable({
        "onUpdate": myCallbackFunction,
        "inputCss":'my-input-class',
        "columns": [4]
    });

    // chercher la liste des magasins
    var mags = $.ajax({
        url: "/api/magasins",
        cache: false
    }).done(function(mags) {
            _o = '';
            for (var i = 0; i < mags.length; i++) {
                _o += `<option>${mags[i].type_mag}</option>`;
            }

            $('#f_generate_list_mag_div').html(`
                <div class="form-group">
                    <label for="i_generate_list_mag" class="form-control-label">Sélectionner le stock de destination :</label>
                    <select name="magasin" class="form-control form-control-sm" id="generate_list" required>
                        ${_o}
                    </select>
                </div>`);

            $('#f_send_list_mag_div').html(`
                <div class="form-group">
                    <label for="i_send_list_mag" class="form-control-label">Sélectionner le stock de destination :</label>
                    <select name="magasin" class="form-control form-control-sm" id="send_list" required>
                        ${_o}
                    </select>
                </div>`);
    });

    $('#tableau_items tbody').on('click', 'tr', function () {
        var data = items_table.row( this ).data();
        sessionStorage.setItem("ref",data.reference);
        pk_item = items_table.row( this ).id();
        // window.location.href = "/reference.html?" + data.reference;
    });

});

function myCallbackFunction(updatedCell, updatedRow, oldValue) {
    console.log("The new value for the cell is: " + updatedCell.data());
    console.log("The old value for that cell was: " + oldValue);
    console.log("The values for each cell in that row are: " + updatedRow.data());

    if (updatedCell.data() != oldValue) {
        $.ajax({
            url: "/api/reappro_item",
            type: 'POST',
            data: {
                pk_item: pk_item,
                qte_dem: updatedCell.data()
            },
        });
    }
}

// function pdf() {

//     let t = document.getElementById('div_tableau_items').innerHTML;

//     let style = "<style>";
//     style = style + "table {width: 100%; font-size: 17px;}";
//     style = style + "table, th, td {border: solid 1px #DDD; border-collapse: collapse;";
//     style = style + "padding: 2px 3px;text-align: center;}";
//     style = style + "</style>";
//     let win = window.open('', '', 'height=700,width=700');

//     win.document.write('<html><head>');
//     win.document.write('<title>Liste d\'entrées</title>');
//     win.document.write(style);
//     win.document.write('</head>');
//     win.document.write('<body>');

//     t.addClass = "compact";

//     win.document.write(t);
//     win.document.write('</body></html>');

//     win.document.close();
//     win.print();
// }

function printtabledetails(){

    $(".buttons-print")[0].click();
  }
