// get product reference
product_ref = window.location.search.substr(1);
product_ref=sessionStorage.ref

var list_of_services;

var zones;

// needed to communicate format field in f_adr
function ecoBasicEncodeURIComponent(str) {
    return str.replace(' ', '__').replace('/', '--');
}



function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}



function generer_sortie_onclick() {
    if ( ! doesTableHaveASelectedRow(lots_retires_table) ) return false;

    var row_indexes = lots_retires_table.rows( { selected: true } )[0];
    _l = lots_retires_table.row(row_indexes[0]).data();

    $('#generer_sortie_info_div').html(`
        <p>Vous allez générer une liste de sortie pour le lot :</p>
        <p class="text-center"><b>'${_l.lot}'</b></p>
        <p>Voulez-vous confirmer?</p>
    `);

    $('#modal-form-generer-sortie').modal('show');
}



$('#f_generer_sortie').submit(function(event) {

    event.preventDefault();

    var row_indexes = lots_retires_table.rows( { selected: true } )[0];
    _l = lots_retires_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/liste_sorties/" + product_ref,
        type: 'POST',
        data: {
            ucd: _l.ucd,
            lot: _l.lot
        },
        success: function(product) {
            $('#generer_sortie_error_notif').hide(400);
            lots_retires_table.draw();

            $('#modal-form-generer-sortie').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Opération réussie.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#generer_sortie_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#generer_sortie_error_notif').html('<p class="mb-0">Problème lors de la génération de sortie.</p>');
            }

            $('#generer_sortie_error_notif').show(400);
        }
    });

});



function onDeleteClick() {
    if ( ! doesTableHaveASelectedRow(lots_retires_table) ) return false;
    $('#modal-delete').modal('show');
}


function onDeleteModalClick() {

    var row_indexes = lots_retires_table.rows( { selected: true } )[0];
    _l = lots_retires_table.row(row_indexes[0]).data();

    $('#modal-delete').modal('hide');

    $.ajax({
        url: "/api/lots_retires/" + product_ref,
        type: 'DELETE',
        data: {
            ucd: _l.ucd,
            lot: _l.lot
        },
        success: function() {

            lots_retires_table.draw();
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Ligne supprimée'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(error) {
            $.notify({
                icon: 'ni ni-check-bold',
                'message': error.responseText
            }, {
                'type': 'danger',
                'placement.align': 'center',
                'delay': 3000
            });
        }
    });
}



function refresh_stock_cards() {
    $.ajax({
        url: "/api/product/" + product_ref,
        cache: false,
        statusCode: {
            404: function() {
                window.location.replace('/reference.html');
            }
        }
    })
    .done(function(product) {
        $('#stock_total_span').html(product.stock);
        $('#stock_cards_row').children('.stock_card_mag_col').remove();
        _create_stock_cards(product.stock_by_mag);
    });
}




$('#f_add').submit(function(event) {

    event.preventDefault();

    _ucd = $('#i_add_ucd').val().trim();
    _lot = $('#i_add_lot').val().trim();

    $.ajax({
        url: "/api/lots_retires/" + product_ref,
        type: 'POST',
        data: {
            ucd: _ucd,
            lot: _lot
        },
        success: function(product) {
            $('#add_error_notif').hide(400);
            lots_retires_table.draw();

            $('#modal-form-add').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Opération réalisée avec succès.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#add_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#add_error_notif').html('<p class="mb-0">Un problème technique a empêché l\'opération, veuillez réessayer.</p>');
            }

            $('#add_error_notif').show(400);
        }
    });

});




// chercher la liste des magasins
var mags = $.ajax({
        url: "/api/magasins",
        cache: false
    })
    .done(function(mags) {
        // s'il y a un seul magasin, on va chercher les formats
        if (mags.length == 1) {
            $('#f_add_stock_line_adr_div').html(`
                <div class="form-group">
                    <label class="form-control-label">Magasin</label>
                    <p>${mags[0].type_mag}</p>
                    <input type="hidden" name="magasin" value="${mags[0].mag}">
                </div>
                `);
            getAvailableFormatsForMagasin(mags[0].mag);



            _o = '';
            for (var i = 0; i < mags.length; i++) {
                _o += `<option value="${mags[i].mag}">${mags[i].type_mag}</option>`;
            }
            $('#f_move_container_adr_div').html(`
            <div class="form-group">
                <label for="i_move_container_adr_mag" class="form-control-label">Magasin</label>
                <select name="magasin" class="form-control form-control-sm" id="i_move_container_adr_mag" required onchange="moveContainer_getAvailableAddressesForMagasin(this.value);">
                    <option value="">Choix du magasin</option>
                    ${_o}
                </select>
            </div>
            `);

        } else if (mags.length > 1) {

            _o = '';
            for (var i = 0; i < mags.length; i++) {
                _o += `<option value="${mags[i].mag}">${mags[i].type_mag}</option>`;
            }

            $('#f_add_stock_line_adr_div').html(`
                <div class="form-group">
                    <label for="i_add_stock_line_adr_mag" class="form-control-label">Magasin</label>
                    <select name="magasin" class="form-control form-control-sm" id="i_add_stock_line_adr_mag" required onchange="getAvailableFormatsForMagasin(this.value);">
                        <option value="">Choix du magasin</option>
                        ${_o}
                    </select>
                </div>
                `);

                $('#f_move_container_adr_div').html(`
                <div class="form-group">
                    <label for="i_move_container_adr_mag" class="form-control-label">Magasin</label>
                    <select name="magasin" class="form-control form-control-sm" id="i_move_container_adr_mag" required onchange="moveContainer_getAvailableAddressesForMagasin(this.value);">
                        <option value="">Choix du magasin</option>
                        ${_o}
                    </select>
                </div>
                `);
        } else {
            $('#f_add_stock_line_adr_div').html("Une erreur s'est produite.");
            $('#f_move_container_adr_div').html("Une erreur s'est produite.");
        }
    });




function _create_stock_cards(stock_by_mag) {
    for (i = 0; i < stock_by_mag.length; i++) {
        $('#stock_cards_row').append(`
            <div class="col-3 stock_card_mag_col">
                <div class="card stock_card">
                    <!-- Card body -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <h5 style="font-size: 1rem" class="card-title text-uppercase text-muted mb-0">Stock ${stock_by_mag[i].type_mag}</h5></td><td align="right">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-7"><span style="font-size: 3rem" class="h1 font-weight-bold mb-0">${stock_by_mag[i].stock}</span></div>
                            <div class="col-5">
                                <img title="Quantité de produits commandés" style="margin-top: 0.5rem !important; height: 3rem !important;" src="./static/img/icons/median/commandes.png" />
                                <span class="text-warning align-bottom font-weight-bold mb-0">${stock_by_mag[i].commande}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            `);
    }
}

function create_existing_lots_form(ucd) {
    $('#existing_lot_form_group').html('');
    $('#i_add_lot').val('');
    $.ajax({
        url: "/api/lots/" + ucd,
        cache: false
    })
    .done(function(lots) {
        if (lots.length > 0) {
            _html = `<label class="form-control-label" for="i_select_lot">Choisir un lot existant :</label>
            <select name="lot" class="form-control form-control-sm" id="i_select_lot">`;
            _html += `<option>-</option>`;
            for ( var i = 0; i < lots.length; i++ ) {
                _html += `<option onclick="$('#i_add_lot').val('${lots[i].lot}');">${lots[i].lot}</option>`;
            }
            _html += `</select>`;
            $('#existing_lot_form_group').html(_html);
        }
    });
}

$(document).ready(function() {


    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    // // chercher la liste des services
    // var list_of_services = $.ajax({
    //         url: "/api/services",
    //         cache: false
    //     })
    //     .done(function(services) {
    //         if (services.length > 0) {

    //             for ( var i = 0; i < services.length ; i++) {
    //                 $('#i_add_stock_line_service').append(`<option value="${services[i].id}">${services[i].name}</option>`);
    //                 $('#modal-delete-stock-line-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
    //                 $('#modal-edit-stock-line-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
    //                 $('#modal-form-sortie-unitaire-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
    //                 $('#modal-move-container-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
    //             }

    //         } else {
    //             $('#f_add_stock_line_adr_div').html("Une erreur s'est produite.");
    //             $('#f_edit_stock_line_adr_div').html("Une erreur s'est produite.");
    //         }
    //     });

    // get labels for custom buttons
    $.ajax({
            url: "/api/labels"
        })
        .done(function(labels) {
            $('.medianCustomField1').html(labels.dci + ' : ');
            $('.medianCustomField2').html(labels.desig_bis + ' : ');
        });


    // get product
    if (product_ref !== "" & product_ref != undefined) {
        $.ajax({
            url: "/api/product/" + product_ref,
            cache: false,
            statusCode: {
                404: function() {
                    window.location.replace('/reference.html');
                }
            }
        })
        .done(function(product) {
            $('#encadre_infos__ref').html(product.reference);
            $('#encadre_infos__desig').html(product.designation);
            $('#encadre_infos__com_med').html(product.com_med);
            $('#breadcrumbs_product_desig').html(product.designation);
            $('#breadcrumbs_product_ref').html("[" + product_ref + "]");
            $('#encadre_infos__dci').html(product.dci);
            $('#encadre_infos__desig_bis').html(product.desig_bis);
            $('#stock_total_span').html(product.stock);
            $('#i_edit_desig').val(product.designation);
            $('#i_edit_com_med').val(product.com_med);

            if (product.ucd_cip_list.length > 0) {
                $('#ucd_cip_tree_div').jstree({
                    'core': {
                        'data': product.ucd_cip_list
                    }
                });
            } else {
                $('#ucd_cip_tree_div').html("<p>Aucun UCD n'a été renseigné pour ce produit</p>");
            }

            var _u = '';
            if (product.ucd_cip_list.length == 0) {
                $('#i_add_ucd').prop("disabled", true);
            } else if (product.ucd_cip_list.length == 1) {
                var _ucd = product.ucd_cip_list[0].text.replace('<b>UCD</b>:', '');
                $('#i_add_ucd').replaceWith(`<p>${_ucd}</p><input id="i_add_ucd" type="hidden" name="ucd" value="${_ucd}">`);
                create_existing_lots_form(_ucd.trim());
            } else {
                for (var i = 0; i < product.ucd_cip_list.length; i++) {
                    var _ucd = product.ucd_cip_list[i].text.replace('<b>UCD</b>:', '');
                    $('#i_add_ucd').append(`<option onclick="create_existing_lots_form('${_ucd.trim()}');">${_ucd}</option>`);
                }
            }

            _create_stock_cards(product.stock_by_mag);
        });


        // get zones
        $.ajax({
            url: "/api/product/" + product_ref,
            cache: false,
            statusCode: {
                404: function() {
                    window.location.replace('/reference.html');
                }
            }
        })
        .done(function(product) {
            // mettre les options dans le select
            $('#encadre_infos__ref').html(product.reference);


        });



        // chercher les lots retirés
        lots_retires_table = $('#tableau_lots_retires').DataTable({
            "language": datatables_lang_fr,
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: '/api/lots_retires/' + product_ref,
                type: 'GET'
            },
            "columns": [{
                "data": null
            }, {
                "data": "ucd"
            }, {
                "data": "lot"
            }, {
                "data": "quantite"
            }],
            "searching": false,
            "paging": false,
            "info": false,
            "columnDefs": [{
                targets: 0,
                data: null,
                defaultContent: '',
                orderable: false,
                className: 'select-checkbox'
            }],
            select: {
                style:    'single',
                selector: 'td:first-child'
            }
        });
    }

});

