// variable used for handling the stock table
var histo_table;
var select_type_mouvement;



function onSelectHistoTableColumns(columnId) {

    var serializedData = $('#f_select_histo_table_columns').serialize();

    if ( serializedData == '' ) {
        $('#select_histo_table_columns_error_notif_text').html("Veuillez cocher au-moins une colonne.");
        $('#select_histo_table_columns_error_notif').show(400);
     //   return false;
    }
    else {
        $('#select_histo_table_columns_error_notif').hide(400);
    }

    var col = histo_table.columns(columnId);

    col.visible( ! col.visible()[0] );

    return false;
}

$("#f_select_histo_table_columns").submit(function(event) {

    event.preventDefault();
    $('#modal-form-select-histo-table-columns').modal('hide');

});

function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}

function filtrer_list_click() {
    // alert($('#h_ucd').val());
    select_type_mouvement=$('#select_type_mouvement').val().join();
    histo_table.draw();
}


window.addEventListener("load", function() {
    var now = new Date(new Date().getFullYear(),new Date().getMonth() , new Date().getDate());
    now.setDate(now.getDate() - 6);
    var offset = now.getTimezoneOffset() * 60000;
    var adjustedDate = new Date(now.getTime() - offset);
    var formattedDate = adjustedDate.toISOString().substring(0,16); // For minute precision

    var datetimeField = document.getElementById("myDatetimeDebut");
    datetimeField.value = formattedDate;

    var now = new Date(new Date().getFullYear(),new Date().getMonth() , new Date().getDate(),"23","59","59");
    var offset = now.getTimezoneOffset() * 60000;
    var adjustedDate = new Date(now.getTime() - offset);
    var formattedDate = adjustedDate.toISOString().substring(0,16); // For minute precision
    var datetimeField = document.getElementById("myDatetimeFin");
    datetimeField.value = formattedDate;

});

function GetChar (event){
    var keyCode = ('which' in event) ? event.which : event.keyCode;
    autocomplete_ucd_lot()
}

function autocomplete_ucd_lot() {
    $.ajax({
        url: "/api/suggestions_ucd_lot_histo",
        type: 'GET',
        data: {
            'fonction': 'ref',
            'ref': document.getElementById("h_reference").value
        },
        success: function(ref) {
            if (ref.length > 0) {

                $('#h_designation').text("Désignation : " + ref[0].text);

                $.ajax({
                    url: "/api/suggestions_ucd_lot_histo",
                    type: 'GET',
                    data: {
                        'fonction': 'ucd',
                        'ref': document.getElementById("h_reference").value
                    },
                    success: function(ucd) {
                        $("#h_ucd")
                            .replaceWith(
                        '<select id="h_ucd" ><option>Tous</option></select>')

                        for ( var i = 0; i < ucd.length ; i++) {
                            $('#h_ucd').append(`<option value="${ucd[i].value}">${ucd[i].value}</option>`);
                        }
                    }
                });

                $.ajax({
                    url: "/api/suggestions_ucd_lot_histo",
                    type: 'GET',
                    data: {
                        'fonction': 'lot',
                        'ref': document.getElementById("h_reference").value
                    },
                    success: function(lot) {
                        $("#h_lot")
                            .replaceWith(
                        '<select id="h_lot" ><option>Tous</option></select>')

                        for ( var i = 0; i < lot.length ; i++) {
                            $('#h_lot').append(`<option value="${lot[i].value}">${lot[i].value}</option>`);
                        }
                    }
                });
            } else {
                $("#h_ucd").replaceWith('<input id="h_ucd" >');
                $("#h_lot").replaceWith('<input id="h_lot" >');
                $('#h_designation').text("Désignation : ");
            }

        },
        error: function(error) {
            $("#h_ucd").replaceWith('<input id="h_ucd" >');
        }
    });

}

function atteindre_reference_click() {
    if ( ! doesTableHaveASelectedRow(histo_table) ) return false;
    var row_indexes = histo_table.rows( { selected: true } )[0];
    _l = histo_table.row(row_indexes[0]).data();

    window.location.href = "/reference.html?" + _l.reference;
    sessionStorage.setItem("ref", _l.reference);

}

function btnExport(){
    var htmltable= document.getElementById('tableau_histo');
    var html = htmltable.outerHTML;
    window.open('data:application/vnd.ms-excel,' + encodeURIComponent(html));
 }

 function btnExport1(){
    var table = $('#tableau_histo').DataTable();
    var order = table.order();

    // alert( 'Column '+order[0][0]+' is the ordering column' );
    // alert( 'Column '+order[0][1]+' is the dir column' );

    // var columns = histo_table.settings().init().columns;
    // histo_table.columns().every(function(index) {
        // console.log(columns[index].name);
        // console.log(columns[index].visible()[0]);
    // })

    var ColVisible = histo_table.columns().visible();
    console.dir(ColVisible);

    // var col = histo_table.columns(columnId);

    // col.visible( ! col.visible()[0] );

    $.ajax({
        url: "/api/datatable/export_historique",
        type: 'POST',
        data: {
            filterByMagasin: 'DC1',
            date_debut: document.getElementById("myDatetimeDebut").value,
            date_fin: document.getElementById("myDatetimeFin").value,
            type_mouvement: $('#select_type_mouvement').val().join(),
            reference: $('#h_reference').val(),
            fraction: $('#h_fraction').val(),
            ucd: $('#h_ucd').val(),
            lot: $('#h_lot').val(),
            adresse: $('#h_adresse').val(),
            serial: $('#h_serial').val(),
            contenant: $('#h_contenant').val(),
            utilisateur: $('#h_utilisateur').val(),
            ipp: $('#h_ipp').val(),
            patient: $('#h_nom_patient').val(),
            liste: $('#h_liste').val(),
            pilulier: $('#h_pilulier').val(),
            service: $('#h_service').val(),
            magasin: $('#h_magasin').val(),
            colvisible: ColVisible.join(),
            orderby: order[0][0],
            dir: order[0][1]
        },
        xhrFields: {
            'responseType': 'blob'
        },
        beforeSend: function() {
            $("#overlay").modal("show");
         },
         complete: function(){
            $("#overlay").modal("hide");
         },
        success: function(data, status, xhr) {
            $('#loader').hide();

            var link = document.createElement('a'),
            filename = 'file.xlsx';

            link.href = URL.createObjectURL(data);
            link.download = filename;
            link.click();
        }
    });
 }

 $(document).ready(function() {

    document.getElementById("h_reference").addEventListener("keyup", GetChar);

    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    // chercher la liste des services
    $.ajax({
            url: "/api/services",
            cache: false,
            data: {
                fonction: '1'
            }
        })
        .done(function(services) {
            if (services.length > 0) {

                for ( var i = 0; i < services.length ; i++) {
                    $('#h_service').append(`<option value="${services[i].id}">${services[i].code_et_name}</option>`);
                }

            } else {
                $('#f_add_stock_line_adr_div').html("Une erreur s'est produite.");
                $('#f_edit_stock_line_adr_div').html("Une erreur s'est produite.");
            }
        });

    // chercher la liste des magasins
    $.ajax({
            url: "/api/magasins",
            cache: false
        })
        .done(function(magasin) {
            if (magasin.length > 0) {

                for ( var i = 0; i < magasin.length ; i++) {
                    $('#h_magasin').append(`<option value="${magasin[i].mag}">${magasin[i].type_mag}</option>`);
                }

            } else {
                $('#f_add_stock_line_adr_div').html("Une erreur s'est produite.");
                $('#f_edit_stock_line_adr_div').html("Une erreur s'est produite.");
            }

        });

    // Quick search
    $('.ecodexAutoComplete1').autoComplete({
        resolverSettings: {
            url: '/api/suggestions'
        },
        noResultsText: 'Aucun produit trouvé'
    });

    $('.ecodexAutoComplete1').on('autocomplete.select', function(evt, item) {
        $('#h_reference').val(item.value);
        $('#h_designation').text("Désignation : " + item.designation);
        autocomplete_ucd_lot();
    });

    $('.ecodexAutoComplete2').autoComplete({
        resolverSettings: {
            url: '/api/suggestions_patient'
        },
        noResultsText: 'Aucun patient trouvé'
    });

    $('.ecodexAutoComplete2').on('autocomplete.select', function(evt, item) {
        $('#h_nom_patient').val(item.value);
    });


    // Disable Enter Key (for AutoComplete Search Form)
    $(document).keydown(function(e){
        var key = e.charCode || e.keyCode;
        if (key == 13) {
          // enter key do nothing
          e.preventDefault();
        }
      });

    histo_table = $('#tableau_histo').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: '/api/datatable/historique',
            type: 'POST',
            data: function(data) {
                data.filterByMagasin = 'DC1',
                data.date_debut= document.getElementById("myDatetimeDebut").value,
                data.date_fin= document.getElementById("myDatetimeFin").value,
                data.type_mouvement= select_type_mouvement,
                data.reference= $('#h_reference').val(),
                data.fraction= $('#h_fraction').val(),
                data.ucd= $('#h_ucd').val(),
                data.lot= $('#h_lot').val(),
                data.adresse= $('#h_adresse').val(),
                data.serial= $('#h_serial').val(),
                data.contenant= $('#h_contenant').val(),
                data.utilisateur= $('#h_utilisateur').val(),
                data.ipp= $('#h_ipp').val(),
                data.patient= $('#h_nom_patient').val(),
                data.liste= $('#h_liste').val(),
                data.pilulier= $('#h_pilulier').val(),
                data.service= $('#h_service').val(),
                data.magasin= $('#h_magasin').val()
            }
        },
        "columns": [
        {
            "data": "chrono",
            name: "chrono"
        }, {
            "data": "reference"
        }, {
            "data": "designation"
        }, {
            "data": "fraction"
        }, {
            "data": "type_mouvement"
        }, {
            "data": "adresse"
        }, {
            "data": "adresse_from"
        }, {
            "data": "quantite_mouvement"
        }, {
            "data": "quantite_prescrite"
        }, {
            "data": "quantite_totale"
        }, {
            "data": "info"
        }, {
            "data": "liste"
        }, {
            "data": "service"
        }, {
            "data": "patient"
        }, {
            "data": "pilulier"
        }, {
            "data": "lot"
        }, {
            "data": "ucd"
        }, {
            "data": "utilisateur"
        }, {
            "data": "poste"
        }, {
            "data": "date_peremption"
        }, {
            "data": "serial"
        }, {
            "data": "contenant"
        }],
        "scrollY": "374px",
        "sScrollX": "100%",
        "scrollX": true,
        "scrollCollapse": true,
        "searching": false,
        "paging": true,
        "pageLength": 100,
        "info": true,
        "order": [[ 0, "desc" ]],
        "select": {
            style:    'single'
        },
        lengthMenu: [ [10, 25, 50, 100, 200, 10000000], ['10', '25', '50', '100', '200', 'Tout'] ],

    });

    $("#select_type_mouvement").CreateMultiCheckBox({ width: '220px', defaultText : 'Type de mouvement', height:'250px' });

    $(document).on("click", ".MultiCheckBox", function () {
        var detail = $(this).next();
        detail.show();
    });

    $(document).on("click", ".MultiCheckBoxDetailHeader input", function (e) {
        e.stopPropagation();
        var hc = $(this).prop("checked");
        $(this).closest(".MultiCheckBoxDetail").find(".MultiCheckBoxDetailBody input").prop("checked", hc);
        $(this).closest(".MultiCheckBoxDetail").next().UpdateSelect();
    });

    $(document).on("click", ".MultiCheckBoxDetailHeader", function (e) {
        var inp = $(this).find("input");
        var chk = inp.prop("checked");
        inp.prop("checked", !chk);
        $(this).closest(".MultiCheckBoxDetail").find(".MultiCheckBoxDetailBody input").prop("checked", !chk);
        $(this).closest(".MultiCheckBoxDetail").next().UpdateSelect();
    });

    $(document).on("click", ".MultiCheckBoxDetail .cont input", function (e) {
        e.stopPropagation();
        $(this).closest(".MultiCheckBoxDetail").next().UpdateSelect();

        var val = ($(".MultiCheckBoxDetailBody input:checked").length == $(".MultiCheckBoxDetailBody input").length)
        $(".MultiCheckBoxDetailHeader input").prop("checked", val);
    });

    $(document).on("click", ".MultiCheckBoxDetail .cont", function (e) {
        var inp = $(this).find("input");
        var chk = inp.prop("checked");
        inp.prop("checked", !chk);

        var multiCheckBoxDetail = $(this).closest(".MultiCheckBoxDetail");
        var multiCheckBoxDetailBody = $(this).closest(".MultiCheckBoxDetailBody");
        multiCheckBoxDetail.next().UpdateSelect();

        var val = ($(".MultiCheckBoxDetailBody input:checked").length == $(".MultiCheckBoxDetailBody input").length)
        $(".MultiCheckBoxDetailHeader input").prop("checked", val);
    });

    $(document).mouseup(function (e) {
        var container = $(".MultiCheckBoxDetail");
        if (!container.is(e.target) && container.has(e.target).length === 0) {
            container.hide();
        }
    });
});

var defaultMultiCheckBoxOption = { width: '220px', defaultText: 'Select Below', height: '200px' };

jQuery.fn.extend({
    CreateMultiCheckBox: function (options) {

        var localOption = {};
        localOption.width = (options != null && options.width != null && options.width != undefined) ? options.width : defaultMultiCheckBoxOption.width;
        localOption.defaultText = (options != null && options.defaultText != null && options.defaultText != undefined) ? options.defaultText : defaultMultiCheckBoxOption.defaultText;
        localOption.height = (options != null && options.height != null && options.height != undefined) ? options.height : defaultMultiCheckBoxOption.height;

        this.hide();
        this.attr("multiple", "multiple");
        var divSel = $("<div class='MultiCheckBox'>" + localOption.defaultText + "<span class='k-icon k-i-arrow-60-down'><svg aria-hidden='true' focusable='false' data-prefix='fas' data-icon='sort-down' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512' class='svg-inline--fa fa-sort-down fa-w-10 fa-2x'><path fill='currentColor' d='M41 288h238c21.4 0 32.1 25.9 17 41L177 448c-9.4 9.4-24.6 9.4-33.9 0L24 329c-15.1-15.1-4.4-41 17-41z' class=''></path></svg></span></div>").insertBefore(this);
        divSel.css({ "width": localOption.width });

        var detail = $("<div class='MultiCheckBoxDetail'><div class='MultiCheckBoxDetailHeader'><input type='checkbox' class='mulinput' value='-1982' /><div>Sélectionner tout</div></div><div class='MultiCheckBoxDetailBody'></div></div>").insertAfter(divSel);
        detail.css({ "width": parseInt(options.width), "max-height": localOption.height });
        var multiCheckBoxDetailBody = detail.find(".MultiCheckBoxDetailBody");

        this.find("option").each(function () {
            var val = $(this).attr("value");

            if (val == undefined)
                val = '';

            multiCheckBoxDetailBody.append("<div class='cont'><div><input type='checkbox' class='mulinput' value='" + val + "' /></div><div class='MultiCheckBoxDetail1'>" + $(this).text() + "</div></div>");
        });

        multiCheckBoxDetailBody.css("max-height", (parseInt($(".MultiCheckBoxDetail").css("max-height")) - 28) + "px");

        $('#select_type_mouvement').val("")

    },
    UpdateSelect: function () {
        var arr = [];

        this.prev().find(".mulinput:checked").each(function () {
            arr.push($(this).val());
        });

        this.val(arr);
    },

});

