// get product reference
product_ref = window.location.search.substr(1);
product_ref=sessionStorage.ref

var list_of_services;

var zones;

ucd_list = [];

// needed to communicate format field in f_adr
function ecoBasicEncodeURIComponent(str) {
    return str.replace(' ', '__').replace('/', '--');
}






function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}


function refresh_stock_cards() {
    $.ajax({
        url: "/api/product/" + product_ref,
        cache: false,
        statusCode: {
            404: function() {
                window.location.replace('/reference.html');
            }
        }
    })
    .done(function(product) {
        $('#stock_total_span').html(product.stock);
        $('#stock_cards_row').children('.stock_card_mag_col').remove();
        _create_stock_cards(product.stock_by_mag);
    });
}



function onDeleteSeuilClick() {
    if ( ! doesTableHaveASelectedRow(seuils_table) ) return false;
    $('#modal-delete-seuil').modal('show');
}


function edit_seuil_onclick() {
    if ( ! doesTableHaveASelectedRow(seuils_table) ) return false;
    var row_indexes = seuils_table.rows( { selected: true } )[0];
    _l = seuils_table.row(row_indexes[0]).data();
    $('#i_edit_seuil_min').val(_l.seuil_min);
    $('#i_edit_seuil_max').val(_l.seuil_max);
    $('#modal-form-edit-seuil').modal('show');  // A TESTER
}

function generer_commande_onclick() {
    if ( ! doesTableHaveASelectedRow(seuils_table) ) return false;

    var row_indexes = seuils_table.rows( { selected: true } )[0];
    _l = seuils_table.row(row_indexes[0]).data();

    $('#generate_order_info_div').html(`
        <p>Vous allez générer une liste de commande pour le produit :</p>
        <ul>
            <li>Réf : ${product_ref}</li>
            <li>Fraction : ${_l.fraction}</li>
            <li>Stock : ${_l.mag}</li>
            <div class="form-group">
                <li>Quantité :</li>
                <input name="Quantite" id="Quantité" class="form-control" value="${_l.en_commande}" />
            </div>
        </ul>
        <p>Voulez-vous confirmer?</p>
    `);

    $('#generate_order_error_notif').hide();

    $('#modal-form-generate-order').modal('show');

}


function onDeleteSeuilModalClick() {

    var row_indexes = seuils_table.rows( { selected: true } )[0];
    _l = seuils_table.row(row_indexes[0]).data();

    $('#modal-delete-seuil').modal('hide');

    $.ajax({
        url: "/api/seuils/" + product_ref,
        type: 'DELETE',
        data: {
            pk: _l.pk
        },
        success: function() {

            seuils_table.draw();
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Ligne supprimée'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(error) {
            $.notify({
                icon: 'ni ni-check-bold',
                'message': error.responseText
            }, {
                'type': 'danger',
                'placement.align': 'center',
                'delay': 3000
            });
        }
    });

}


function onDeleteUcdClick() {
    _options = '';
    for (var i = 0; i < ucd_list.length; i++) {
        _options += '<option>' + ucd_list[i] + '</option>'
    }
    $('#delete_ucd_select_div').html('');
    $('#delete_ucd_select_div').append('<select class="form-control" id="ucd_select">' + _options + '</select>');
    $('#modal-form-delete-ucd').modal('show');
}



function create_list_click() {

    event.preventDefault();

    var row_indexes = seuils_table.rows( { selected: true } )[0];
    _l = seuils_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/liste_entrees/" + product_ref,
        type: 'POST',
        data: {
            fraction: _l.fraction,
            quantite: $('#Quantité').val(),
            mag: _l.mag
        },
        success: function(product) {
            $('#generate_order_error_notif').hide(400);
            seuils_table.draw();

            $('#modal-form-generate-order').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Une commande a été créée.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });

            refresh_stock_cards();

        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#generate_order_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#generate_order_error_notif').html('<p class="mb-0">Problème lors de la création de commande.</p>');
            }

            $('#generate_order_error_notif').show(400);
        }


    });

}

function abandon_list_click() {

    $('#modal-form-generate-order').modal('hide');

}

$("#f_edit_seuil").submit(function(event) {

    event.preventDefault();

    var seuil_min = $('#i_edit_seuil_min').val();
    var seuil_max = $('#i_edit_seuil_max').val();

    if ( Number(seuil_min) >= Number(seuil_max) ) {
        $('#seuil_edit_error_notif_text').html("Attention, vous avez indiqué un seuil min plus grand que le seuil max!");
        $('#seuil_edit_error_notif').show(400);
        return false;
    }

    if ( Number(seuil_min) < 0 || Number(seuil_max) <= 0 ) {
        $('#seuil_edit_error_notif_text').html("Attention, vous avez indiqué un seuil négatif!");
        $('#seuil_edit_error_notif').show(400);
        return false;
    }

    var row_indexes = seuils_table.rows( { selected: true } )[0];
    _l = seuils_table.row(row_indexes[0]).data();

    // requête pour éditer la ligne
    $.ajax({
        url: "/api/seuils/" + product_ref,
        type: 'PUT',
        data: {
            pk: _l.pk,
            seuil_min: seuil_min,
            seuil_max: seuil_max
        },
        success: function(product) {
            $('#seuil_edit_error_notif').hide(400);
            seuils_table.draw();

            $('#modal-form-edit-seuil').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Le seuil a bien été modifié.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#seuil_edit_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#seuil_edit_error_notif').html('<p class="mb-0">Problème lors de la modification du seuil.</p>');
            }

            $('#seuil_edit_error_notif').show(400);
        }
    });

});








function _create_stock_cards(stock_by_mag) {
    for (i = 0; i < stock_by_mag.length; i++) {
        $('#stock_cards_row').append(`
            <div class="col-3 stock_card_mag_col">
                <div class="card stock_card">
                    <!-- Card body -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <h5 style="font-size: 1rem" class="card-title text-uppercase text-muted mb-0">Stock ${stock_by_mag[i].type_mag}</h5></td><td align="right">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-7"><span style="font-size: 3rem" class="h1 font-weight-bold mb-0">${stock_by_mag[i].stock}</span></div>
                            <div class="col-5">
                                <img title="Quantité de produits commandés" style="margin-top: 0.5rem !important; height: 3rem !important;" src="./static/img/icons/median/commandes.png" />
                                <span class="text-warning align-bottom font-weight-bold mb-0">${stock_by_mag[i].commande}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            `);
    }
}





$("#f_add_seuil").submit(function(event) {

    event.preventDefault();

    var mag = $('#i_add_seuil_mag').val();
    var fraction = $('#i_add_seuil_fraction').val();
    var seuil_min = $('#i_add_seuil_min').val();
    var seuil_max = $('#i_add_seuil_max').val();

    if ( Number(seuil_min) >= Number(seuil_max) ) {
        $('#add_seuil_error_notif_text').html("Attention, vous avez indiqué un seuil min plus grand que le seuil max!");
        $('#add_seuil_error_notif').show(400);
        return false;
    }

    if ( Number(seuil_min) < 0 || Number(seuil_max) <= 0 ) {
        $('#add_seuil_error_notif_text').html("Attention, vous avez indiqué un seuil négatif!");
        $('#add_seuil_error_notif').show(400);
        return false;
    }

    // requête pour ajouter la ligne
    $.ajax({
        url: "/api/seuils/" + product_ref,
        type: 'POST',
        data: {
            mag: mag,
            fraction: fraction,
            seuil_min: seuil_min,
            seuil_max: seuil_max
        },
        success: function(product) {
            $('#add_seuil_error_notif').hide(400);
            seuils_table.draw();

            $('#modal-form-add-seuil').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Le seuil a bien été ajouté.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#add_seuil_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#add_seuil_error_notif').html('<p class="mb-0">Problème lors de la création du seuil.</p>');
            }

            $('#add_seuil_error_notif').show(400);
        }
    });

});


$("#f_add_ucd").submit(function(event) {

    event.preventDefault();

    var nouv_ucd = $('#i_add_ucd').val();

    if ( nouv_ucd == '' ) {
        $('#add_ucd_error_notif_text').html("Veuillez saisir un UCD à associer!");
        $('#add_ucd_error_notif').show(400);
        return false;
    }

    // requête pour ajouter la ligne
    $.ajax({
        url: "/api/ucd_cip/" + product_ref,
        type: 'POST',
        data: {
            ucd: nouv_ucd
        },
        success: function(product) {
            $('#add_ucd_error_notif').hide(400);
            ucd_cip_table.draw();

            $('#modal-form-add-ucd').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Opération réalisée avec succès.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
            document.location.reload(true);
        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#add_ucd_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#add_ucd_error_notif').html('<p class="mb-0">Problème lors de l\'association du nouvel UCD.</p>');
            }

            $('#add_ucd_error_notif').show(400);
        }
    });

});


$("#f_delete_ucd").submit(function(event) {

    event.preventDefault();

    var _ucd = $('#ucd_select').val();

    if ( _ucd == '' ) {
        $('#delete_ucd_error_notif_text').html("Veuillez saisir un UCD!");
        $('#delete_ucd_error_notif').show(400);
        return false;
    }

    // requête pour ajouter la ligne
    $.ajax({
        url: "/api/ucd_cip/" + product_ref,
        type: 'DELETE',
        data: {
            ucd: _ucd
        },
        success: function(product) {
            $('#delete_ucd_error_notif').hide(400);
            ucd_cip_table.draw();

            $('#modal-form-delete-ucd').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Opération réalisée avec succès.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
            document.location.reload(true);
        },
        error: function(data) {
            var msg = data.responseJSON.message;
            if ( msg != '' ) {
                $('#delete_ucd_error_notif').html('<p class="mb-0">' + msg + '</p>');
            }
            else {
                $('#delete_ucd_error_notif').html('<p class="mb-0">Problème lors de la suppression de l\'UCD.</p>');
            }
            $('#delete_ucd_error_notif').show(400);
        }
    });
});


$(document).ready(function() {


    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    $.ajax({
            url: "/api/labels"
        })
        .done(function(labels) {
            $('.medianCustomField1').html(labels.dci + ' : ');
            $('.medianCustomField2').html(labels.desig_bis + ' : ');
        });


    // get product
    if (product_ref !== "" & product_ref != undefined) {
        $.ajax({
            url: "/api/product/" + product_ref,
            cache: false,
            statusCode: {
                404: function() {
                    window.location.replace('/reference.html');
                }
            }
        }).done(function(product) {
            $('#encadre_infos__ref').html(product.reference);
            $('#encadre_infos__desig').html(product.designation);
            $('#encadre_infos__com_med').html(product.com_med);
            $('#breadcrumbs_product_desig').html(product.designation);
            $('#breadcrumbs_product_ref').html("[" + product_ref + "]");
            $('#encadre_infos__dci').html(product.dci);
            $('#encadre_infos__desig_bis').html(product.desig_bis);
            $('#stock_total_span').html(product.stock);
            $('#i_edit_desig').val(product.designation);
            $('#i_edit_com_med').val(product.com_med);

            if (product.ucd_cip_list.length > 0) {
                $('#ucd_cip_tree_div').jstree({
                    'core': {
                        'data': product.ucd_cip_list
                    }
                });
            } else {
                $('#ucd_cip_tree_div').html("<p>Aucun UCD n'a été renseigné pour ce produit</p>");
            }

            var _u = '';
            if (product.ucd_cip_list.length == 0) {
                $('#i_add_stock_line_ucd').prop("disabled", true);
            } else if (product.ucd_cip_list.length == 1) {
                var _ucd = product.ucd_cip_list[0].text.replace('<b>UCD</b>:', '');
                $('#i_add_stock_line_ucd').replaceWith(`<p>${_ucd}</p><input type="hidden" name="ucd" value="${_ucd}">`);

            } else {
                for (var i = 0; i < product.ucd_cip_list.length; i++) {
                    $('#i_add_stock_line_ucd').append(`<option>${product.ucd_cip_list[i].text.replace('<b>UCD</b>:', '')}</option>`);
                }
            }

            for (var i = 0; i < product.ucd_cip_list.length; i++) {
                ucd_list.push((product.ucd_cip_list[i].text.replace('<b>UCD</b>:', '').trim()));
            }

            _create_stock_cards(product.stock_by_mag);
        });


        // get zones
        $.ajax({
            url: "/api/product/" + product_ref,
            cache: false,
            statusCode: {
                404: function() {
                    window.location.replace('/reference.html');
                }
            }
        })
        .done(function(product) {
            // mettre les options dans le select
            $('#encadre_infos__ref').html(product.reference);


        });




        // chercher la liste des magasins
        var mags = $.ajax({
            url: "/api/magasins",
            cache: false
        })
        .done(function(mags) {

                _o = '';
                for (var i = 0; i < mags.length; i++) {
                    _o += `<option>${mags[i].type_mag}</option>`;
                }

                $('#f_add_seuil_mag_div').html(`
                    <div class="form-group">
                        <label for="i_add_seuil_mag" class="form-control-label">Magasin</label>
                        <select name="magasin" class="form-control form-control-sm" id="i_add_seuil_mag" required>
                            ${_o}
                        </select>
                    </div>
                    `);
        });


        // get seuils data
        seuils_table = $('#tableau_gestion_des_seuils').DataTable({
            "language": datatables_lang_fr,
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: '/api/seuils/' + product_ref,
                type: 'GET'
            },
            "columns": [{
                "data": null
            }, {
                "data": "mag"
            }, {
                "data": "fraction"
            }, {
                "data": "seuil_min"
            }, {
                "data": "seuil_max"
            }, {
                "data": "quantite"
            }, {
                "data": "commande"
            }, {
                "data": "en_commande"
            }],
            "searching": false,
            "paging": false,
            "info": false,
            "columnDefs": [{
                targets: 0,
                data: null,
                defaultContent: '',
                orderable: false,
                className: 'select-checkbox'
            }],
            select: {
                style:    'single',
                selector: 'td:first-child'
            }
        });


        // get ucd_cip data
        ucd_cip_table = $('#tableau_ucd_cip').DataTable({
            "language": datatables_lang_fr,
            // "processing": true,
            "serverSide": true,
            "ajax": {
                url: '/api/ucd_cip/' + product_ref,
                type: 'GET'
            },
            "columns": [{
                "data": "ucd"
            }, {
                "data": "cip"
            }, {
                "data": "qte_pass"
            }, {
                "data": "qte_boite"
            }, {
                "data": "qte_blister"
            }, {
                "data": "index"
            }],
            "searching": false,
            "paging": false,
            "info": false
        });
    }

});

