// get product reference
product_ref = window.location.search.substr(1);

// variable used for handling the stock table
var stock_table;

var list_of_services;

var zones;

// needed to communicate format field in f_adr
function ecoBasicEncodeURIComponent(str) {
    return str.replace(' ', '__').replace('/', '--');
}



function onSelectStockTableColumns(columnId) {

    var serializedData = $('#f_select_stock_table_columns').serialize();

    if ( serializedData == '' ) {
        $('#select_stock_table_columns_error_notif_text').html("Veuillez cocher au-moins une colonne.");
        $('#select_stock_table_columns_error_notif').show(400);
        return false;
    }
    else {
        $('#select_stock_table_columns_error_notif').hide(400);
    }

    var col = stock_table.columns(columnId);

    col.visible( ! col.visible()[0] );

    return false;
}

$("#f_select_stock_table_columns").submit(function(event) {

    event.preventDefault();
    $('#modal-form-select-stock-table-columns').modal('hide');

});


// Handle for editing stock line
function edit_stock_line_onclick() {

    var row_indexes = stock_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à éditer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    // display a modal, with edit form, prefilled with values just fetched from stock_table
    _l = stock_table.row(row_indexes[0]).data();
    $('#i_stock_line_edit_qte').val(_l.quantite);
    $('#i_stock_line_edit_lot').val(_l.lot);
    $('#i_edit_stock_line_date_peremption').val(_l.date_peremption.split(' ')[0]);
    $('#modal-form-edit-stock-line').modal('show');
}


// Handle for "sortie unitaire"
function sortie_unitaire_onclick() {

    var row_indexes = stock_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à éditer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    $('#modal-form-sortie-unitaire').modal('show');
}


// Handle for moving container
function move_container_onclick() {

    var row_indexes = stock_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à éditer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    // init form
    $('#i_move_container_adr_mag').val('');
    $('#move_container_adr_adr_form_group').children().remove();

    $('#modal-form-move-container').modal('show');
}


function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}


function refresh_stock_cards() {
    $.ajax({
        url: "/api/product/" + product_ref,
        cache: false,
        statusCode: {
            404: function() {
                window.location.replace('/reference.html');
            }
        }
    })
    .done(function(product) {
        $('#stock_total_span').html(product.stock);
        $('#stock_cards_row').children('.stock_card_mag_col').remove();
        _create_stock_cards(product.stock_by_mag);
    });
}


// Handle for delete stock line(s)
function onDeleteClick() {
    if ( ! doesTableHaveASelectedRow(stock_table) ) return false;
    var row_indexes = stock_table.rows( { selected: true } )[0];
    _l = stock_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/get_adr",
        type: 'GET',
        data: {
            'ref': product_ref,
            'adr': _l.emplacement.replace(/ /g, ''),
        },
        success: function(cnt) {

            if ( cnt > 1 ) {
                $('#delete-stock-line__empty-container').hide();
            }
            else {
                $('#delete-stock-line__empty-container').show();
            }

            $('#modal-delete-stock-line').modal('show');
        },
        error: function(error) {
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Un problème technique est survenu.'
            }, {
                'type': 'danger',
                'placement.align': 'center',
                'delay': 3000
            });
        }
    });
}

function onDeleteModalClick(b_empty_container, service_code) {

    if ( service_code == '-' ) {
        $.notify({
            icon: 'ni ni-check-bold',
            'message': 'Veuillez sélectionner un service.'
        }, {
            'type': 'danger',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    $('#modal-delete-stock-line').modal('hide');

    if ( ! doesTableHaveASelectedRow(stock_table) ) return false;

    var _sel_stock_line = stock_table.row(stock_table.rows( { selected: true } )[0][0]).data();
    var _pk = _sel_stock_line.pk;
    var _adr = _sel_stock_line.emplacement.replace(/ /g, '');
    var _qte_mvt = _sel_stock_line.quantite;
    var _lot = _sel_stock_line.lot;
    var _date_peremption = _sel_stock_line.date_peremption;
    var _contenant = _sel_stock_line.contenant;
    var _ucd = _sel_stock_line.ucd;
    var _fraction = _sel_stock_line.fraction;

    $.ajax({
        url: "/api/stock/" + product_ref,
        type: 'DELETE',
        data: {
            pk: _pk,
            is_empty_container: b_empty_container,
            adresse: _adr,
            service: service_code,
            qte_mvt: _qte_mvt,
            lot: _lot,
            date_peremption: _date_peremption,
            contenant: _contenant,
            ucd: _ucd,
            fraction: _fraction
        },
        success: function() {

            refresh_stock_cards();
            stock_table.draw();
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Lignes supprimées'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(error) {
            $.notify({
                icon: 'ni ni-check-bold',
                'message': error.responseText
            }, {
                'type': 'danger',
                'placement.align': 'center',
                'delay': 3000
            });
        }
    });

}


// Handle filter by magasin
function magfilter_onclick() {

    var fc = $('.mag_filter_chk');
    var mags = [];

    for (var i = 0; i < fc.length; i++)
        if (fc[i].checked)
            mags.push(fc[i].value)

    $('#filterByMagasin').val(mags.join());

    stock_table.draw();

    $('#modal-form-filtrer-par-magasin').modal('hide');
}

// Handle stock line edition
// $("#f_edit_stock_line").submit(function(event) {

//     event.preventDefault();

//     var qte = $('#i_stock_line_edit_qte').val();
//     var _a = $('#i_edit_stock_line_adr_adr').val();

//     if ( ! _a ) {
//         adr = '';
//     }
//     else {
//         adr = _a[0].replace(/ /g, '');
//     }

//     $.ajax({
//         url: "/api/stock/" + product_ref,
//         type: 'PUT',
//         data: {
//             quantite: qte,
//             adresse: adr
//         },
//         success: function(product) {
//             stock_table.draw();
//             $('#modal-form-edit-stock-line').modal('hide');
//             $.notify({
//                 icon: 'ni ni-check-bold',
//                 'message': 'La ligne de stock a été modifiée.'
//             }, {
//                 'type': 'success',
//                 'placement.align': 'center',
//                 'delay': 3000
//             });
//         },
//         error: function(data) {
//             $.notify({
//                 icon: 'ni ni-check-bold',
//                 'message': 'Une erreur est survenue.'
//             }, {
//                 'type': 'warning',
//                 'placement.align': 'center',
//                 'delay': 3000
//             });
//         }
//     });
// });



// Handle "sortie unitaire"
$("#f_sortie_unitaire").submit(function(event) {

    event.preventDefault();

    var row_indexes = stock_table.rows( { selected: true } )[0];
    _l = stock_table.row(row_indexes[0]).data();

    var qte_new = $('#i_sortie_unitaire_qte').val();
    var serv = $('#modal-form-sortie-unitaire-service-select').val();

    $.ajax({
        url: "/api/sortie_unitaire/" + product_ref,
        type: 'POST',
        data: {
            quantite_new: qte_new,
            fraction: _l.fraction,
            quantite_old: _l.quantite,
            service: serv,
            adresse: _l.emplacement.replace(/ /g, ''),
            pk: _l.pk,
            lot_old: _l.lot,
            date_peremption_old: _l.date_peremption,
            contenant: _l.contenant,
            ucd: _l.ucd,
        },
        success: function(msg) {

            if ( msg == 'Success' ) {

                stock_table.draw();

                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'La sortie unitaire a été prise en compte.'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });

                $('#modal-form-sortie-unitaire').modal('hide');
            }
            else {
                $.notify({
                    icon: 'ni ni-air-baloon',
                    'message': msg
                }, {
                    'type': 'warning',
                    'placement.align': 'center',
                    'delay': 3000
                });
            }

        },
        error: function(data) {
            $('#sortie_unitaire_error_notif_text').html(data);
            $('#sortie_unitaire_error_notif').show(400);
        }
    });
});



// Handle product edition
$("#f_edit_product").submit(function(event) {

    event.preventDefault();

    var de = $('#i_edit_desig').val();
    var cm = $('#i_edit_com_med').val();

    $.ajax({
        url: "/api/product/" + product_ref,
        type: 'PUT',
        data: {
            designation: de,
            com_med: cm
        },
        success: function(product) {
            $('#encadre_infos__desig').html(de);
            $('#encadre_infos__com_med').html(cm)
            $('#breadcrumbs_product_desig').html(de);
            $('#breadcrumbs_product_ref').html(product_ref);
            $('#modal-form-editer-infos-produit').modal('hide');
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Produit enregistré.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $('#product_edit_error_notif_text').html(data);
            $('#product_edit_error_notif').show(400);
        }
    });
});

// Handle add stock line
$("#f_add_stock_line").submit(function(event) {

    event.preventDefault();

    if ( $('#i_add_stock_line_service').val() == '-' ) {
        $('#add_stock_line_error_notif').html('<p class="mb-0">Veuillez indiquer un service d\'origine.</p>');
        $('#add_stock_line_error_notif').show(400);
        return false;
    }

    $.ajax({
        url: "/api/stock/" + product_ref,
        type: 'POST',
        data: {
            form_data: $('#f_add_stock_line').serialize()
        },
        success: function(product) {
            $('#add_stock_line_error_notif').hide(400);
            refresh_stock_cards();
            stock_table.draw();

            // re-init form
            while ($('#f_add_stock_line_adr_div').children().length > 1)
                $('#f_add_stock_line_adr_div').children().last().remove();
            $('#i_add_stock_line_adr_mag').val('');
            $('#i_add_stock_line_qte').val(1);
            $('#i_add_stock_line_lot').val('');
            $('#i_add_stock_line_service').val('-');
            $('#i_add_stock_line_date_peremption').val('');

            $('#modal-form-add-stock-line').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Nouvelle ligne créée en stock.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $('#add_stock_line_error_notif').html('<p class="mb-0">Problème lors de la création de la ligne de stock.</p>');
            $('#add_stock_line_error_notif').show(400);
        }
    });
});

// Handle edit stock line
$("#f_edit_stock_line").submit(function(event) {

    event.preventDefault();

    var serv = $('#modal-edit-stock-line-service-select').val();

    if ( serv == '-' ) {
        $('#stock_line_edit_error_notif').html('<p class="mb-0">Veuillez sélectionner un service.</p>');
        $('#stock_line_edit_error_notif').show(400);
        return false;
    }

    // new values
    var n_qte = $('#i_stock_line_edit_qte').val();
    // var n_lot = $('#i_stock_line_edit_lot').val();
    // var n_dp = $('#i_edit_stock_line_date_peremption').val();

    // old values
    var row_indexes = stock_table.rows( { selected: true } )[0];
    _l = stock_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/stock/" + product_ref,
        type: 'PUT',
        data: {
            pk: _l.pk,
            quantite_new: n_qte,
            quantite_old: _l.quantite,
            // lot_new: n_lot,
            lot_old: _l.lot,
            // date_peremption_new: n_dp,
            date_peremption_old: _l.date_peremption,
            service: serv,
            adresse: _l.emplacement.replace(/ /g, ''),
            contenant: _l.contenant,
            ucd: _l.ucd,
            fraction: _l.fraction
        },
        success: function(product) {
            $('#edit_stock_line_error_notif').hide(400);
            refresh_stock_cards();
            stock_table.draw();
            $('#modal-form-edit-stock-line').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'La ligne a bien été modifiée.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $('#edit_stock_line_error_notif').html('<p class="mb-0">Problème lors de la modification de la ligne de stock.</p>');
            $('#edit_stock_line_error_notif').show(400);
        }
    });
});


function updateContenantField(adr) {
    $.ajax({
            url: "/api/adresse/" + adr,
            method: 'POST',
            cache: false
        })
        .done(function(code_contenant) {
            if (code_contenant.length > 0) {
                $('#i_add_stock_line_adr_contenant').val(code_contenant);
            } else {
                $('#i_add_stock_line_adr_contenant').val('');
            }
        });
}


function getAvailableAdresses(mag, format, cur_func = 'add') {

    if (!mag || !format) {
        return false;
    }

    if ( cur_func == 'add' ) {
        while ($('#f_add_stock_line_adr_div').children().length > 2) {
            $('#f_add_stock_line_adr_div').children().last().remove();
        }
    }
    // else if ( cur_func == 'edit') {
    //     while ($('#f_edit_stock_line_adr_div').children().length > 2) {
    //         $('#f_edit_stock_line_adr_div').children().last().remove();
    //     }
    // }

    // chercher les adresses dispo pour ce magasin et ce format
    var adr = $.ajax({
            url: "/api/available_adresses",
            type: 'GET',
            data: {
                reference: product_ref,
                origin_adresse: "-",
                fraction:"-",
                magasin: mag,
                format: ecoBasicEncodeURIComponent(format),
                creation: true
            },
            cache: false
        })
        .done(function(adresses) {
            if ( cur_func == 'add' ) {
                if (adresses.length > 0) {
                    _o = '';
                    for (var i = 0; i < adresses.length; i++) {
                        _o += `<option value="${adresses[i].adresse}">${adresses[i].adresse}</option>`;
                    }

                    $('#f_add_stock_line_adr_div').append(`
                        <div class="form-group">
                            <label for="i_add_stock_line_adr_adr" class="form-control-label">Emplacement</label>
                            <select name="adresse" multiple class="form-control" id="i_add_stock_line_adr_adr" required onclick="updateContenantField(this.value); return false;">
                                ${_o}
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="i_add_stock_line_adr_contenant" class="form-control-label">Code contenant</label>
                            <input name="contenant" type="text" class="form-control form-control-sm" id="i_add_stock_line_adr_contenant" value="" required />
                        </div>
                    `);
                } else {
                    $('#f_add_stock_line_adr_div').append(`<p>Aucune adresse disponible!</p>`);
                }
            }
            // else if ( cur_func == 'edit' ) {
            //     if (adresses.length > 0) {
            //         _o = '';
            //         for (var i = 0; i < adresses.length; i++) {
            //             _o += `<option value="${adresses[i].adresse}">${adresses[i].adresse}</option>`;
            //         }

            //         $('#f_edit_stock_line_adr_div').append(`
            //             <div class="form-group">
            //                 <label for="i_edit_stock_line_adr_adr" class="form-control-label">Emplacement</label>
            //                 <select name="adresse" multiple class="form-control" id="i_edit_stock_line_adr_adr">
            //                     ${_o}
            //                 </select>
            //             </div>
            //         `);
            //     } else {
            //         $('#f_edit_stock_line_adr_div').append(`<p>Aucune adresse disponible!</p>`);
            //     }
            // }
        });

    return false;

}


function moveContainer_getAvailableAddressesForMagasin(mag) {
    // récupérer le magasin (en argument), l'adresse d'origine, la fraction
    var row_indexes = stock_table.rows( { selected: true } )[0];
    _l = stock_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/available_adresses",
        type: 'GET',
        data: {
            reference: product_ref,
            origin_adresse: _l.emplacement.replace(/ /g, ''),
            fraction: _l.fraction,
            magasin: mag,
            creation: false
        },
        success: function(available_addresses) {

            $('#move_container_error_notif').hide(400);
            $('#move_container_adr_adr_form_group').remove();

            var form_group = `
            <div class="form-group" id="move_container_adr_adr_form_group">
                <label for="move_container_adr_adr" class="form-control-label">Emplacement</label>
                <select name="adresse" multiple="" class="form-control" id="move_container_adr_adr" required>`;

            for ( var i = 0 ; i < available_addresses.length ; i++ ) {
                _a = available_addresses[i].adresse;
                // if ( _a.substring(0,3) == mag )
                form_group += `<option value="${available_addresses[i].adresse}">${available_addresses[i].adresse}</option>`;
            }

            form_group += `
                </select>
            </div>`;

            $('#f_move_container_adr_div').append(form_group);
        },
        error: function(data) {
            $('#move_container_error_notif').html('<p class="mb-0">Nous avons rencontré un problème en interne, veuillez réessayer.</p>');
            $('#move_container_error_notif').show(400);
        }
    });
}


$("#f_move_container").submit(function(event) {

    event.preventDefault();

    // vérifier que tous les champs sont renseignés
    // if ( $('#modal-move-container-service-select').val() == '-' ) {
    //     $('#move_container_error_notif').html('<p class="mb-0">Veuillez indiquer le service imputé.</p>');
    //     $('#move_container_error_notif').show(400);
    //     return false;
    // }

    // récupérer le magasin (en argument), l'adresse d'origine, la fraction
    var row_indexes = stock_table.rows( { selected: true } )[0];
    _l = stock_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/move_container/" + product_ref,
        type: 'PUT',
        data: {
            pk: _l.pk,
            form_data: $('#f_move_container').serialize(),
            origin_adresse: _l.emplacement.replace(/ /g, ''),
            lot: _l.lot,
            date_peremption: _l.date_peremption,
            ucd: _l.ucd,
            fraction: _l.fraction
        },
        success: function(product) {
            $('#move_container_error_notif').hide(400);
            refresh_stock_cards();
            stock_table.draw();
            $('#modal-form-move-container').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Contenant déplacé.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $('#move_container_error_notif').html('<p class="mb-0">Problème rencontré lors du déplacement du contenant.</p>');
            $('#move_container_error_notif').show(400);
        }
    });

});


function getAvailableFormatsForMagasin(mag, cur_func = 'add') {

    if ( ! mag ) {
        return false;
    }

    // chercher les formats dispo pour ce magasin
    var mags = $.ajax({
            url: "/api/container_formats/" + mag,
            cache: false
        })
        .done(function(containers) {
            if ( cur_func == 'add' ) {
                $('#f_add_stock_line_adr_div').html($('#f_add_stock_line_adr_div').children().first());

                // s'il y a un seul magasin, on va chercher les adresses
                if (containers.length == 1) {
                    $('#f_add_stock_line_adr_div').append(`
                            <div>
                            <label class="form-control-label">Type de contenant</label>
                            <p>${containers[0].format}</p>
                            <input type="hidden" name="format" value="${ecoBasicEncodeURIComponent(containers[0].format)}">
                            </div>`);
                    getAvailableAdresses(mag, containers[0].format);
                } else if (containers.length > 1) {

                    _o = '';
                    for (var i = 0; i < containers.length; i++) {
                        _o += `<option value="${containers[i].format}">${containers[i].format}</option>`;
                    }

                    $('#f_add_stock_line_adr_div').append(`
                            <div class="form-group">
                                <label for="i_add_stock_line_adr_format" class="form-control-label">Type de contenant</label>
                                <select name="format" class="form-control form-control-sm" id="i_add_stock_line_adr_format" required onchange="getAvailableAdresses('${mag}', this.value); return false;">
                                    <option value="">Choix du format</option>
                                    ${_o}
                                </select>
                            </div>
                            `);
                } else {
                    $('#f_add_stock_line_adr_div').append(`<p>Aucun format n'est disponible pour ce magasin!</p>`);
                }
            }
            // else if ( cur_func == 'edit') {
            //     $('#f_edit_stock_line_adr_div').html($('#f_edit_stock_line_adr_div').children().first());

            //     // s'il y a un seul magasin, on va chercher les adresses
            //     if (containers.length == 1) {
            //         $('#f_edit_stock_line_adr_div').append(`
            //                 <div>
            //                 <label class="form-control-label">Type de contenant</label>
            //                 <p>${containers[0].format}</p>
            //                 <input type="hidden" name="format" value="${ecoBasicEncodeURIComponent(containers[0].format)}">
            //                 </div>`);
            //         getAvailableAdresses(mag, containers[0].format, 'edit');
            //     } else if (containers.length > 1) {

            //         _o = '';
            //         for (var i = 0; i < containers.length; i++) {
            //             _o += `<option value="${containers[i].format}">${containers[i].format}</option>`;
            //         }

            //         $('#f_edit_stock_line_adr_div').append(`
            //                 <div class="form-group">
            //                     <label for="i_edit_stock_line_adr_format" class="form-control-label">Type de contenant</label>
            //                     <select name="format" class="form-control form-control-sm" id="i_edit_stock_line_adr_format" onchange="getAvailableAdresses('${mag}', this.value, 'edit'); return false;">
            //                         <option value="">Choix du format</option>
            //                         ${_o}
            //                     </select>
            //                 </div>
            //                 `);
            //     } else {
            //         $('#f_edit_stock_line_adr_div').append(`<p>Aucun format n'est disponible pour ce magasin!</p>`);
            //     }
            // }
        });

    return false;

}

// chercher la liste des magasins
var mags = $.ajax({
        url: "/api/magasins",
        cache: false
    })
    .done(function(mags) {
        // s'il y a un seul magasin, on va chercher les formats
        if (mags.length == 1) {
            $('#f_add_stock_line_adr_div').html(`
                <div class="form-group">
                    <label class="form-control-label">Magasin</label>
                    <p>${mags[0].type_mag}</p>
                    <input type="hidden" name="magasin" value="${mags[0].mag}">
                </div>
                `);
            getAvailableFormatsForMagasin(mags[0].mag);



            _o = '';
            for (var i = 0; i < mags.length; i++) {
                _o += `<option value="${mags[i].mag}">${mags[i].type_mag}</option>`;
            }
            $('#f_move_container_adr_div').html(`
            <div class="form-group">
                <label for="i_move_container_adr_mag" class="form-control-label">Magasin</label>
                <select name="magasin" class="form-control form-control-sm" id="i_move_container_adr_mag" required onchange="moveContainer_getAvailableAddressesForMagasin(this.value);">
                    <option value="">Choix du magasin</option>
                    ${_o}
                </select>
            </div>
            `);

        } else if (mags.length > 1) {

            _o = '';
            for (var i = 0; i < mags.length; i++) {
                _o += `<option value="${mags[i].mag}">${mags[i].type_mag}</option>`;
            }

            $('#f_add_stock_line_adr_div').html(`
                <div class="form-group">
                    <label for="i_add_stock_line_adr_mag" class="form-control-label">Magasin</label>
                    <select name="magasin" class="form-control form-control-sm" id="i_add_stock_line_adr_mag" required onchange="getAvailableFormatsForMagasin(this.value);">
                        <option value="">Choix du magasin</option>
                        ${_o}
                    </select>
                </div>
                `);

                $('#f_move_container_adr_div').html(`
                <div class="form-group">
                    <label for="i_move_container_adr_mag" class="form-control-label">Magasin</label>
                    <select name="magasin" class="form-control form-control-sm" id="i_move_container_adr_mag" required onchange="moveContainer_getAvailableAddressesForMagasin(this.value);">
                        <option value="">Choix du magasin</option>
                        ${_o}
                    </select>
                </div>
                `);
        } else {
            $('#f_add_stock_line_adr_div').html("Une erreur s'est produite.");
            $('#f_move_container_adr_div').html("Une erreur s'est produite.");
        }
    });




function _add_stock_line__on_ucd_select(_ucd) {

    // get labels for custom buttons
    $.ajax({
            url: "/api/lot/" + $.trim(_ucd)
        })
        .done(function(numlot) {
            $('#i_add_stock_line_lot').val(numlot);
        });
}



function _create_stock_cards(stock_by_mag) {
    for (i = 0; i < stock_by_mag.length; i++) {
        $('#stock_cards_row').append(`
            <div class="col-3 stock_card_mag_col">
                <div class="card stock_card">
                    <!-- Card body -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <h5 style="font-size: 1rem" class="card-title text-uppercase text-muted mb-0">Stock ${stock_by_mag[i].type_mag}</h5></td><td align="right">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-7"><span style="font-size: 3rem" class="h1 font-weight-bold mb-0">${stock_by_mag[i].stock}</span></div>
                            <div class="col-5">
                                <img title="Quantité de produits commandés" style="margin-top: 0.5rem !important; height: 3rem !important;" src="./static/img/icons/median/commandes.png" />
                                <span class="text-warning align-bottom font-weight-bold mb-0">${stock_by_mag[i].commande}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            `);
    }
}

$(document).ready(function() {


    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    // chercher la liste des services
    var list_of_services = $.ajax({
            url: "/api/services",
            cache: false
        })
        .done(function(services) {
            if (services.length > 0) {

                for ( var i = 0; i < services.length ; i++) {
                    $('#i_add_stock_line_service').append(`<option value="${services[i].id}">${services[i].name}</option>`);
                    $('#modal-delete-stock-line-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
                    $('#modal-edit-stock-line-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
                    $('#modal-form-sortie-unitaire-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
                    $('#modal-move-container-service-select').append(`<option value="${services[i].id}">${services[i].name}</option>`);
                }

            } else {
                $('#f_add_stock_line_adr_div').html("Une erreur s'est produite.");
                $('#f_edit_stock_line_adr_div').html("Une erreur s'est produite.");
            }
        });

    // get labels for custom buttons
    $.ajax({
            url: "/api/labels"
        })
        .done(function(labels) {
            $('.medianCustomField1').html(labels.dci + ' : ');
            $('.medianCustomField2').html(labels.desig_bis + ' : ');
        });


    function _create_magasin_filter(stock_by_mag) {
        $('#tableau_stock_wrapper').children().first().children().last().html(`
            <button title="Filtrer par magasin" style="float:right" type="button" class="btn btn-sm mr-0 bleu_jerome_devant rounded-0" data-toggle="modal" data-target="#modal-form-filtrer-par-magasin"><i class="stock_table_icon fas fa-filter"></i></button>
            <button title="Choix des colonnes" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" data-toggle="modal" data-target="#modal-form-select-stock-table-columns"><i class="stock_table_icon fas fa-th"></i></button>
            <button title="Créer une ligne de stock" style="float:right; font-size: 22px;" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" data-toggle="modal" data-target="#modal-form-add-stock-line"><i class="fas fa-plus"></i></button>
            <button title="Supprimer une ligne de stock" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="onDeleteClick();"><i class="stock_table_icon fas fa-trash"></i></button>
            <button title="Modifier une ligne de stock" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="edit_stock_line_onclick();"><i class="stock_table_icon fas fa-pen"></i></button>
            <button title="Déplacer un contenant" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="move_container_onclick();"><i class="stock_table_icon fas fa-angle-double-right"></i></button>
            <button title="Sortie unitaire" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="sortie_unitaire_onclick();"><img src="./static/img/icons/median/sortie_unitaire3.png" width="35"></button>
            `);

        for (i = 0; i < stock_by_mag.length; i++) {
            $('#f_mag_filter_lines').append(`
                <div class="form-group">
                    <span class="form-control-label">${stock_by_mag[i].type_mag}</span>
                    <label class="custom-toggle  custom-toggle-default" style="float: right">
                        <input type="checkbox" class="mag_filter_chk" name="mag_filter_check" value='${stock_by_mag[i].mag}' checked>
                        <span class="custom-toggle-slider rounded-circle"></span>
                    </label>
                </div>
                `);
        }
    }


    // get product
    $.ajax({
        url: "/api/product/" + product_ref,
        cache: false,
        statusCode: {
            404: function() {
                window.location.replace('/reference.html');
            }
        }
    })
    .done(function(product) {
        $('#encadre_infos__ref').html(product.reference);
        $('#encadre_infos__desig').html(product.designation);
        $('#encadre_infos__com_med').html(product.com_med);
        $('#breadcrumbs_product_desig').html(product.designation);
        $('#breadcrumbs_product_ref').html(product_ref);
        $('#encadre_infos__dci').html(product.dci);
        $('#encadre_infos__desig_bis').html(product.desig_bis);
        $('#stock_total_span').html(product.stock);
        $('#i_edit_desig').val(product.designation);
        $('#i_edit_com_med').val(product.com_med);
        $('#link__fiches_produits_stock')[0].href += '?' + product_ref;
        $('#link__fiches_produits_param')[0].href += '?' + product_ref;
        $('#link__fiches_produits_lots_retires')[0].href += '?' + product_ref;

        if (product.ucd_cip_list.length > 0) {
            $('#ucd_cip_tree_div').jstree({
                'core': {
                    'data': product.ucd_cip_list
                }
            });
        } else {
            $('#ucd_cip_tree_div').html("<p>Aucun UCD n'a été renseigné pour ce produit</p>");
        }

        var _u = '';
        if (product.ucd_cip_list.length == 0) {
            $('#i_add_stock_line_ucd').prop("disabled", true);
        } else if (product.ucd_cip_list.length == 1) {
            var _ucd = product.ucd_cip_list[0].text.replace('<b>UCD</b>:', '');
            $('#i_add_stock_line_ucd').replaceWith(`<p>${_ucd}</p><input type="hidden" name="ucd" value="${_ucd}">`);
            _add_stock_line__on_ucd_select(_ucd);

        } else {
            for (var i = 0; i < product.ucd_cip_list.length; i++) {
                $('#i_add_stock_line_ucd').append(`<option>${product.ucd_cip_list[i].text.replace('<b>UCD</b>:', '')}</option>`);
            }
        }

        _create_stock_cards(product.stock_by_mag);
        _create_magasin_filter(product.stock_by_mag);
    });



    // get zones
    $.ajax({
        url: "/api/product/" + product_ref,
        cache: false,
        statusCode: {
            404: function() {
                window.location.replace('/reference.html');
            }
        }
    })
    .done(function(product) {
        // mettre les options dans le select
        $('#encadre_infos__ref').html(product.reference);


    });


    // get stock data
    stock_table = $('#tableau_stock').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: '/api/datatable/stock/' + product_ref,
            type: 'POST',
            data: function(data) {
                data.filterByMagasin = $('#filterByMagasin').val();
            }
        },
        "columns": [{
            "data": null
        }, {
            "data": "bloque"
        }, {
            "data": "emplacement"
        }, {
            "data": "quantite"
        }, {
            "data": "fraction"
        }, {
            "data": "ucd"
        }, {
            "data": "date_sortie"
        }, {
            "data": "date_entree"
        }, {
            "data": "lot"
        }, {
            "data": "date_peremption"
        }, {
            "data": "contenant"
        }],
        "searching": false,
        "paging": true,
        "pageLength": 10,
        "info": false,
        "columnDefs": [{
            targets: 0,
            data: null,
            defaultContent: '',
            orderable: false,
            className: 'select-checkbox'
        },{
            targets: 1,
            render: function(data, type, row, meta) {
                if (data != 'NON') {
                    return '<i class="ni ni-lock-circle-open" title="L\'emplacement est bloqué!"></i>';
                }
                return '';
            }
        }],
        select: {
            style:    'single',
            selector: 'td:first-child'
        }
    });

    $('#i_add_stock_line_date_peremption').datepicker({
        // inline: true,
        language: 'fr',
        dateFormat: 'dd-mm-yyyy',
        minDate: new Date(),
        classes: 'eco_datepicker',
        autoClose: true,
        position: "left top"
    });

    $('#i_edit_stock_line_date_peremption').datepicker({
        // inline: true,
        language: 'fr',
        dateFormat: 'dd-mm-yyyy',
        minDate: new Date(),
        classes: 'eco_datepicker',
        autoClose: true,
        position: "left top"
    });

});

