var dt_read = null;

function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}


function creer_perimes() {

    if ( ! doesTableHaveASelectedRow(dt_rea) ) return false;

    // var today = new Date();
    // var dd = today.getDate();
    // var mm = today.getMonth() + 1;

    // var yyyy = today.getFullYear();
    // if (dd < 10) {
    //     dd = '0' + dd;
    // }
    // if (mm < 10) {
    //     mm = '0' + mm;
    // }
    // var today = yyyy + '-' + mm + '-' + dd;

    // var liste = sessionStorage.magasin + " PAR " +  sessionStorage.username + " LE " + today + " No " + compteur;

    var res = [];

    $.each(dt_rea.rows('.selected').nodes(), function(i, item) {
        var data = dt_rea.row(this).data();
        res.push({"ref": data[1], "frac": data[4], "qte": data[5], "date": data[6]});

    });

    console.log(res);

    $.ajax({
        url: "/api/perimes",
        method: 'POST',
        data: JSON.stringify({"lines": res, "type_mag": sessionStorage.type_mag, "date_peremption": sessionStorage.date_peremption}),
        contentType: "application/json",
        dataType: "json"
    })

    window.location.href = "/listes_sorties.html"

}

function annuler_click() {
    window.location.href = "/listes_sorties.html"
}

function atteindre_reference_click() {
    window.location.href = "/reference.html?" + sessionStorage.ref;
}


$(document).ready(function () {

    $('#titre').html("Validation de la sortie de périmés pour le stock " + sessionStorage.magasin);
    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
        sessionStorage.setItem('username', user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    /// fill the table with sessionStorage data
    var data = JSON.parse(sessionStorage.getItem('perimes.calcul'));
    var ds = [];
    var tbl = [];

    for (const l in data) {
        var li = data[l];
        tbl = [false, li.ref, li.designation, li.adresse, li.fraction, li.quantite, li.date_peremption];
        ds.push(tbl);
    }

    dt_rea = $('#tableau_items').DataTable({
        "language": datatables_lang_fr,
        // language: {
            // select: {
            //     rows: {
            //         _: "%d lignes sélectionnées",
            //         0: "Cliquer sur une ligne pour la sélectionnée",
            //         1: "1 ligne sélectionnée"
            //     }
            // }

        "data": ds,
        "autoWidth": true,
        "columns": [
            {"title": ""},
            {"title": "référence"},
            {"title": "désignation"},
            {"title": "adresse"},
            {"title": "fraction"},
            {"title": "quantité"},
            {"title": "date de péremption",
            "className": "red"}
        ],
        "columnDefs": [{
            "targets": 0,
            "checkboxes": {
               "selectRow": true
            }
         }],
        "order":[[2, "asc"],[3, "asc"]],
        "searching": false,
        "select": {
            "style": "multi"
        }
        // "paging": true,
        // "pageLength": 10,
        // "info": false,
        // "deferLoading": 0
    });

    // $('#tableau_items').on('click', 'tbody td', function () {
    //     dt_rea.cell(this).edit();
    // });
    // On passe la taille a 100%
    $('#tableau_items').css('width', '100%')
    $('#div_tableau_items').show();

    $('#div_tableau_items tbody').on('click', 'tr', function () {
        var data = dt_rea.row( this ).data();
        sessionStorage.setItem("ref", data[1]);
    } );
});

function myCallbackFunction(updatedCell, updatedRow, oldValue) {
    console.log("The new value for the cell is: " + updatedCell.data());
    console.log("The old value for that cell was: " + oldValue);
    console.log("The values for each cell in that row are: " + updatedRow.data());
}
