/**
 * Fonction globale a tous les écrans Median
 * ce fichier doit être chargé après jQuery, Handlebar JS, MomentJS, mais avant d'utiliser les traitement dans le dossier js/median
 */

var mweb_partial_dir = 'static/partial/';

/**
 * Load the partial in HBJS format and append it at the end of body element
 *
 * @param {string} a_template
 * @param {string} a_tag
 */
function mweb_load_partial(a_template, a_tag) {
    $.ajax({
        url: mweb_partial_dir + a_template,
        dataType: 'html',
        success: function(response) {
            console.log('chargement: ' + a_template);
            document.body.insertAdjacentHTML('beforeend','<script id="' + a_tag + '" type="text/x-handlebars-template">' + response + '</script>');
        }
    })
}

/**
 *
 * @param {string} a_template Template to retrieve
 * @param {string} a_tag tag to identify element
 * @param {string} a_api Url of API to call
 * @param {string} a_method  HTTP method to call the API
 * @param {object} a_data Data to pass when call the API
 * @param {string} a_final Element to insert the rendering
 */
function mweb_execute_partial(a_template, a_tag, a_api, a_method, a_data, a_final) {
    var tmpl;
    $.ajax({
        url: mweb_partial_dir + a_template,
        dataType: 'html',
        success: function(response) {
            console.log('chargement: ' + a_template);
            document.body.insertAdjacentHTML('beforeend','<script id="' + a_tag + '" type="text/x-handlebars-template">' + response + '</script>');
            $.ajax({
                url: a_api,
                type: a_method,
                data: a_data,
                success: function(response) {
                    tmpl = Handlebars.compile(document.getElementById(a_tag).innerHTML);
                    render_html = tmpl(response);
                    document.getElementById(a_final).innerHTML = render_html;
                },
                error: function(response) {
                    console.log('Error when execute partial');
                }
            })
        }
    })
}

// Search script type wit
function mweb_execute_template(a_final) {
    var tmpl;
    $.ajax({
        url: mweb_partial_dir + "navbar.hbs",
        dataType: 'html',
        success: function(response) {
            tmpl = Handlebars.compile(response);
            render_html = tmpl(response);
            document.getElementById(a_final).innerHTML = render_html;
            //console.log(response);

            // Quick search is on narvbar.hbs file
            $('.ecodexAutoComplete').autoComplete({
                resolverSettings: {
                    url: '/api/suggestions'
                },
                noResultsText: 'Aucun produit trouvé'
            });

            $('.ecodexAutoComplete').on('autocomplete.select', function(evt, item) {
                document.location.href = '/reference.html?' + item.value;
                sessionStorage.setItem("ref",item.value);
            });

            // Disable Enter Key (for AutoComplete Search Form)
            $(document).keydown(function(e){
                var key = e.charCode || e.keyCode;
                if (key == 13) {
                // enter key do nothing
                e.preventDefault();
                }
            });


        }
    })

}

function mweb_navbar_render() {

}

function mweb_menu_click(url) {
    sessionStorage.setItem("page",url[1]);
    console.log(url[0]);
    window.location.href = url[0];
}

/**
 * Disconnect the user and send him to the logout page.
 */
function user_logout() {
    // clean translation cache
    if ('i18n_terms' in sessionStorage) {
        sessionStorage.removeItem('i18n_terms');
    }
    window.location.replace('/logout');
}

/**
 *
 * @param {string} key Key to retrieve in sessionStorage
 * @param {string} defval DEfault translation
 * @returns Translate term
 */
function i18n_convert(key, defval) {
    var res = "";
    var x = JSON.parse(sessionStorage.getItem('i18n_terms'));

    res = x[key];
    if (!res) {
        console.log('i18n missing: ' + key);
        res = defval;
    }

    return res;
}

/**
 * Use Promise for an async treatment
 * @param {*} codelang
 */
function median_i18n(codelang) {
    // TODO retrieve user lang and store it on the sessionStorage

    var deferred = $.Deferred();

    deferred.done(function(value) {
        // console.log(value);
        // On parcours toutes les classes med-i18n
        // puis on remplacement l'attribut data-med-i18n
        var els = document.getElementsByClassName('med-i18n');
        Array.prototype.forEach.call(els, function(el) {
            el.textContent = i18n_convert(el.dataset.medI18n, "[(" + el.textContent + ")]");
        });
    });

    if (!('i18n_terms' in sessionStorage)) {
        $.ajax({
            url: '/api/ui/i18nform',
            type: 'POST',
            data: {
                lang: codelang
            },
            success: function(i18n_form) {
                // console.log("Load " + codelang + " on session storage");
                // console.log(i18n_form);

                sessionStorage.setItem('i18n_terms', JSON.stringify(i18n_form.terms));
                deferred.resolve("Tout frais");
            }
        });
    } else {
        // c'est deja en cache on affiche
        deferred.resolve("En cache");
    }
}

function onAfficherMenu() {
    $('.sidenav-toggler').addClass('active');
    $('.sidenav-toggler').data('action', 'sidenav-unpin');
    $('body').removeClass('g-sidenav-hidden').addClass('g-sidenav-show g-sidenav-pinned');
    $('body').append('<div class="backdrop d-xl-none" data-action="sidenav-unpin" data-target='+$('#sidenav-main').data('target')+' />');

    // Store the sidenav state in a cookie session
    Cookies.set('sidenav-state', 'pinned');

}

/**
 * Check if one line of the datatables is selected
 *
 * @param {Datatable} i_table Datatable element
 * @returns true if line is select, otherwise false
 */
function DatatableSelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}

/**
 * Fill the select element with datas and teh default value.
 * if callback is specify, we add it on the onchange event
 *
 * @param {string} elem_id Element ID
 * @param {Array} datas LIst of value and name for listbox
 * @param {Any} default_value Default value to select
 * @param {function} event_callback Event callback when chaneg event detect
 */
function form_select_element(elem_id, datas, default_value, event_callback=null) {
    var elem_orig = document.getElementById(elem_id);
    var elem = elem_orig.cloneNode(false);
    if (elem != null) {
        elem.innerHTML = '';
        console.debug('Default value: ' + default_value);
        // Fill the options list
        datas.forEach(function(item){
            var opt = document.createElement("option");
            opt.text = item.name;
            opt.value = item.value;
            if (item.value == default_value) {
                opt.selected = true
            }
            elem.add(opt)
            console.debug(item);
        })

        if (event_callback != null) {
            var changeEvent = function() {
                event_callback(elem.value);
                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Le valeur a été modifié avec succès.'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 2000
                });
            }
            //elem.removeEventListener('change', changeEvent);
            elem.addEventListener('change', changeEvent);
        }
    } else {
        console.error('Element ' + elem_id + ' not found !!!');
    }
    elem_orig.replaceWith(elem);
}

function form_checkbox_element(elem_id, default_value, event_callback=null) {
    var elem_orig = document.getElementById(elem_id);
    var elem = elem_orig.cloneNode(false);
    if (elem != null) {
        console.debug('default_value: '+ default_value);
        elem.checked = default_value;
    } else {
        console.error('Element ' + elem_id + ' not found !!!');
    }
    if (event_callback != null) {
        var changeEvent = function() {
            event_callback(elem.checked);
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Le valeur a été modifié avec succès.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 2000
            });
        }
        //elem.removeEventListener('change', changeEvent);
        elem.addEventListener('click', changeEvent);
    }

    elem_orig.replaceWith(elem);
}
