var services_table;


function onSelectClick(element, mode) {

    if (element.checked) {
        valeur = 1;
    } else {
        valeur = 0;
    }

    $.ajax({
        url: "/api/menu",
        cache: false,
        type: 'POST',
        data: {
            ressource: element.name,
            mode: mode,
            valeur: valeur
        }
    })

}

function edit_user_line_onclick() {

    var row_indexes = services_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à éditer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    // display a modal, with edit form, prefilled with values just fetched from stock_table
    _l = services_table.row(row_indexes[0]).data();
    $('#i_user_line_edit_code').val(_l.dest);
    $('#i_user_line_edit_lib').val(_l.libelle);
    $('#i_user_line_edit_type_peigne').val(_l.type_peigne);

    switch (_l.moment_deb)  {
        case "matin":
            $('#modal-edit-user-line-moment-select').val("matin");
            break;
        case "midi":
            $('#modal-edit-user-line-moment-select').val("midi");
            break;
        case "soir":
            $('#modal-edit-user-line-moment-select').val("soir");
            break;
        case "coucher":
            $('#modal-edit-user-line-moment-select').val("coucher");
            break;
        default:
            $('#modal-edit-user-line-moment-select').val("0");
    }

    $('#i_user_line_edit_deb_matin').val(_l.deb_matin);
    $('#i_user_line_edit_deb_midi').val(_l.deb_midi);
    $('#i_user_line_edit_deb_soir').val(_l.deb_soir);
    $('#i_user_line_edit_deb_coucher').val(_l.deb_coucher);

    switch (_l.tri)  {
        case "CHAMBRE":
            $('#modal-edit-user-line-tri-select').val("CHAMBRE");
            break;
        case "NOM":
            $('#modal-edit-user-line-tri-select').val("NOM");
            break;
        case "SEJOUR":
            $('#modal-edit-user-line-tri-select').val("SEJOUR");
            break;
        default:
            $('#modal-edit-user-line-tri-select').val("0");
    }

    $('#modal-form-edit-user-line').modal('show');
}

function add_user_line_onclick() {

    $('#i_user_line_add_code').val("");
    $('#i_user_line_add_lib').val("");
    $('#i_user_line_add_type_peigne').val("0");
    $('#modal-add-user-line-moment-select').val("0");
    $('#i_user_line_add_deb_matin').val("0");
    $('#i_user_line_add_deb_midi').val("0");
    $('#i_user_line_add_deb_soir').val("0");
    $('#i_user_line_add_deb_coucher').val("0");
    $('#modal-add-user-line-tri-select').val("0");

    // display a modal, with edit form, prefilled with values just fetched from stock_table
    // _l = stock_table.row(row_indexes[0]).data();
    // $('#i_stock_line_edit_qte').val(_l.quantite);
    // $('#i_stock_line_edit_lot').val(_l.lot);
    // $('#i_edit_stock_line_date_peremption').val(_l.date_peremption.split(' ')[0]);

    $('#modal-form-add-user-line').modal('show');
}


$("#f_edit_user_line").submit(function(event) {

    event.preventDefault();

    // vérifier que tous les champs sont renseignés
    // if ( $('#modal-move-container-service-select').val() == '-' ) {
    //     $('#move_container_error_notif').html('<p class="mb-0">Veuillez indiquer le service imputé.</p>');
    //     $('#move_container_error_notif').show(400);
    //     return false;
    // }


    $.ajax({
        url: "/api/services",
        type: 'PUT',
        data: {
            code: $('#i_user_line_edit_code').val(),
            libelle: $('#i_user_line_edit_lib').val(),
            type_peigne: $('#i_user_line_edit_type_peigne').val(),
            moment_deb: $('#modal-edit-user-line-moment-select').val(),
            deb_matin: $('#i_user_line_edit_deb_matin').val(),
            deb_midi: $('#i_user_line_edit_deb_midi').val(),
            deb_soir: $('#i_user_line_edit_deb_soir').val(),
            deb_coucher: $('#i_user_line_edit_deb_coucher').val(),
            tri: $('#modal-edit-user-line-tri-select').val(),
        },
        success: function(product) {
            $('#move_container_error_notif').hide(400);
            services_table.draw();
            $('#modal-form-edit-user-line').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Service modifié.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $('#move_container_error_notif').html('<p class="mb-0">Problème rencontré lors de la mise à jour du service.</p>');
            $('#move_container_error_notif').show(400);
        }
    });

});


$("#f_add_user_line").submit(function(event) {

    event.preventDefault();

    // vérifier que tous les champs sont renseignés
    // if ( $('#modal-move-container-service-select').val() == '-' ) {
    //     $('#move_container_error_notif').html('<p class="mb-0">Veuillez indiquer le service imputé.</p>');
    //     $('#move_container_error_notif').show(400);
    //     return false;
    // }

    $.ajax({
        url: "/api/services",
        type: 'POST',
        data: {
            code: $('#i_user_line_add_code').val(),
            libelle: $('#i_user_line_add_lib').val(),
            type_peigne: $('#i_user_line_add_type_peigne').val(),
            moment_deb: $('#modal-add-user-line-moment-select').val(),
            deb_matin: $('#i_user_line_add_deb_matin').val(),
            deb_midi: $('#i_user_line_add_deb_midi').val(),
            deb_soir: $('#i_user_line_add_deb_soir').val(),
            deb_coucher: $('#i_user_line_add_deb_coucher').val(),
            tri: $('#modal-add-user-line-tri-select').val(),
        },
        success: function(product) {
            $('#move_container_error_notif').hide(400);
            services_table.draw();
            $('#modal-form-add-user-line').modal('hide');

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Service créé.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(data) {
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Le service existe déjà.'
            }, {
                'type': 'danger',
                'placement.align': 'center',
                'delay': 3000
            });
            // $('#move_container_error_notif').html('<p class="mb-0">Problème rencontré lors de la création du service.</p>');
            // $('#move_container_error_notif').show(400);
        }
    });

});

function onDeleteUserClick() {
    var row_indexes = services_table.rows( { selected: true } )[0];

    if ( row_indexes.length != 1 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Veuillez sélectionner une ligne à supprimer!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;

    }

    _l = services_table.row(row_indexes[0]).data();

    $('#modal-delete-user-line').modal('show');

}

function onDeleteModalClick() {
    var row_indexes = services_table.rows( { selected: true } )[0];

    _l = services_table.row(row_indexes[0]).data();

    $.ajax({
        url: "/api/services",
        type: 'DELETE',
        data: {
            code: _l.dest,
        },
        success: function() {
            services_table.draw();
            $('#modal-delete-user-line').modal('hide');
            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'Service supprimé'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });
        },
        error: function(error) {
            $.notify({
                icon: 'ni ni-check-bold',
                'message': error.responseText
            }, {
                'type': 'danger',
                'placement.align': 'center',
                'delay': 3000
            });
        }
    });

}

function btnExport(){
    var htmltable= document.getElementById('tableau_stock');
    var html = htmltable.outerHTML;
    window.open('data:application/vnd.ms-excel,' + encodeURIComponent(html));
 }

function get_profil(profil_user) {
    var myNode = document.getElementById("modal-edit-user-line-profil-select");
    myNode.textContent = '';

    myNode = document.getElementById("modal-add-user-line-profil-select");
    myNode.textContent = '';

    $('#modal-edit-user-line-profil-select').append(`<option>-</option>`);
    $('#modal-add-user-line-profil-select').append(`<option>-</option>`);

    // chercher la liste des profils
    $.ajax({
        url: "/api/profils",
        cache: false
    })
    .done(function(profil) {
        if (profil.length > 0) {

            for ( var i = 0; i < profil.length ; i++) {
                $('#modal-edit-user-line-profil-select').append(`<option value="${profil[i].profil}">${profil[i].profil}</option>`);
                $('#modal-add-user-line-profil-select').append(`<option value="${profil[i].profil}">${profil[i].profil}</option>`);
            }
        }
        document.getElementById('modal-edit-user-line-profil-select').value=profil_user;
    });



}


$(document).ready(function() {


    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });

    function _create_bouton() {
        $('#tableau_services_wrapper').children().first().children().last().html(`

            <button title="Supprimer un service" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="onDeleteUserClick();"><i class="stock_table_icon fas fa-trash"></i></button>
            <button title="Créer un service" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="add_user_line_onclick();"><i class="stock_table_icon fas fa-plus"></i></button>
            <button title="Modifier un service" style="float:right" type="button" class="btn btn-sm mr-1 bleu_jerome_devant rounded-0" onclick="edit_user_line_onclick();"><i class="stock_table_icon fas fa-pen"></i></button>
            `);

    }


    // get user data
    services_table = $('#tableau_services').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: '/api/datatable/services',
            type: 'POST',
        },
        "columns": [{
            "data": null
        }, {
            "data": "dest"
        }, {
            "data": "libelle"
        }, {
            "data": "type_peigne"
        }, {
            "data": "moment_deb"
        }, {
            "data": "deb_matin"
        }, {
            "data": "deb_midi"
        }, {
            "data": "deb_soir"
        }, {
            "data": "deb_coucher"
        }, {
            "data": "tri"
        }],
        "scrollY": "545px",
        "sScrollX": "100%",
        "scrollX": true,
        "scrollCollapse": true,
        "searching": false,
        "paging": true,
        "pageLength": 100,
        "info": true,
        "columnDefs": [{
            targets: 0,
            data: null,
            defaultContent: '',
            orderable: false,
            className: 'select-checkbox'
        }],
        "select": {
            style:    'single'
        },
        lengthMenu: [ [10, 25, 50, 100, 200, 10000000], ['10', '25', '50', '100', '200', 'Tout'] ],
        // "drawCallback": function( settings ) {
        //     var api = this.api();

        //     // Output the data for the visible rows to the browser's console
        //     // console.log( api.rows( {page:'current'} ).data() );
        //     // console.log(stock_table.page.info())
        //     document.getElementById('lbltipAddedComment').innerHTML = stock_table.page.info().recordsTotal + " emplacements";
        // },

    });

    _create_bouton();


});
