/**
 * S execute automatiquement lorsque la page est chargée
 */
window.addEventListener("DOMContentLoaded", (event) => {
    console.log("DOM entièrement chargé et analysé");
    mweb_execute_partial('menu.hbs', 'menu-id', 'api/ui/menu', 'get', {}, 'sidenav-main');
    mweb_execute_template('topnav-main');
    init_page();
    load_lists();
});

var items_table;

function load_lists() {
    $.ajax({
        url: "/api/riedl/listes_entrees",
        type: 'GET',
        data: {
            'riedl': ''
        }
    }).done(function(response) {
        console.log(response);

        if (response.length == 0 ) {
            $('#div_liste_reappros').html('Aucune liste de chargement en cours.');
            return;
        }

        $('#riedl_entree_liste').jstree({
            'core': {
                'data' : response.listes
            }
        });

        $('#riedl_entree_liste').bind('loaded.jstree', function(e, data) {
            // invoked after jstree has loaded
            $(this).jstree("open_all");
            //$(this).jstree("select_node", data1);

            // $('#ucd_cip_tree_div').jstree(true).select_node(response.listes);

        })

        $('#riedl_entree_liste').on("select_node.jstree", function(evt, data) {
            console.debug('node-select: ' + data.node.id);
            console.debug('node-length: ' + data.node.parents.length);
            //console.log('item_table: ' + items_table);
            // if (data.node.parents.length >= 2) {
            if (data.node.id.startsWith('model-')) {
                $('#div_tableau_items').show();
                $('#list_items_titre').html(data.node.id);
                $('#div_tableau_listes').hide();
                document.getElementById('atteindre_reference').style.visibility="visible";
                items_table = selected_list(data.node.text, items_table);
                items_table.draw();
                items_table.columns().checkboxes.deselect(true);
            } else {
            //     $('#div_tableau_listes').show();
                $('#div_tableau_items').hide();
                $('#list_items_titre').html(data.node.text);
                document.getElementById('atteindre_reference').style.visibility="hidden";
            //     items_table1.ajax.url('/api/datatable/liste_sorties_listes/'+data.node.id);
            //     items_table1.draw();
            //     items_table1.columns().checkboxes.deselect(true);
            }

        });
    })
}

/**
 * Fill the item of the list in a DatatableZ
 *
 * @param {string} listname Name of the MEdian List
 * @param {HTMLElement} elem CUrrent datatable element
 * @returns
 */
function selected_list(listname, elem) {
    var uri = '/api/datatable/riedl_entrees_items/' + listname;
    if (elem === undefined) {
        elem = $('#tableau_items').DataTable({
            "language": datatables_lang_fr,
            "processing": true,
            "serverSide": true,
            "stateSave": false,
            "ajax": {
                url: uri,
                type: 'POST'
            },
            "columnDefs": [{
                'targets': 0,
                'searchable': false,
                'orderable': false,
                'checkboxes':{
                    "selectRow": true
                }
            }],
            "select": {
                style:    'multi'
            },
            "columns": [
                {
                    "data": null
                }, {
                    "data": "item"
                }, {
                    "data": "etat"
                }, {
                    "data": "reference"
                }, {
                    "data": "fraction"
                }, {
                    "data": "designation"
                }, {
                    "data": "qte_demandee"
                }, {
                    "data": "qte_servie"
                }, {
                    "data": "moment"
                }, {
                    "data": "heure"
                }
            ],
            "searching": false,
            "paging": false,
            "pageLength": 10,
            "info": false,
            "deferLoading": 0,
            order: []
        });
    } else {
        elem.ajax.url(uri);
    }

    return elem;
}

function atteindre_reference_click() {
    if ( ! doesTableHaveASelectedRow(items_table) ) return false;

    window.location.href = "/reference.html?" + sessionStorage.ref;
}

function init_page() {
    // document.getElementById('button_unload_list').style.visibility="hidden";
    document.getElementById('button_delete_list').style.visibility="hidden";
    // $("#button_unload_list").BootConfirm({
    //     complete: function(elem){
    //         $.ajax({
    //             url: "/api/riedl/command_sorties",
    //             type: "POST",
    //             data: {
    //                 liste: $(elem).data('model-id')
    //             }
    //         }).done(function(response) {
    //             console.log('unload: ' + response);
    //             alert('Lancement effectué');
    //             window.location.reload();
    //         }).fail(function(response) {
    //             console.error('unload error: ' + response);
    //             alert('Erreur de lancement');
    //         });
    //     },
    //     message: true
    // });

    // $("#button_delete_list").BootConfirm({
    //     complete: function(elem){
    //         console.log($(elem).data('model-id'));
    //         $.ajax({
    //             url: "/api/riedl/listes_entrees",
    //             type: "DELETE",
    //             data: {
    //                 liste: $(elem).data('model-id')
    //             }
    //         }).done(function(response) {
    //             console.log('delete: ' + response['liste']);
    //             window.location.reload();
    //         });
    //         // execute_unload();
    //     },
    //     message: true
    // });
}
