var items_table;
var items_table1;
var data1;
var ipp;

$('.ecodexAutoComplete3').autoComplete({
    resolverSettings: {
        url: '/api/suggestions'
    },
    noResultsText: 'Aucun produit trouvé'
});

$('.ecodexAutoComplete3').on('autocomplete.select', function(evt, item) {
    // document.location.href = '/reference.html?' + item.value;
    sessionStorage.setItem("ref",item.value);
});

$('#btn-select1').click(function(){

    // alert(input.selectedindex)

    $('#ucd_cip_tree_div').jstree("destroy")
    ipp=''
    $('.ecodexAutoComplete1').val('');
    sessionStorage.setItem("ipp",'');

    items_table1.destroy()

    items_table1 = $('#tableau_listes').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "stateSave": false,
        "ajax": {
            url: '/api/datatable/liste_sorties_listes/',
            type: 'POST',
            data: {
                ipp: ''
            }
        },
        "columnDefs": [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'checkboxes':{"selectRow":true}
        }],
        "select": {
            style:    'multi'
        //  selector: 'tr'
        },
        "columns": [
            {
                "data": null
            }, {
                "data": "liste"
            }, {
                "data": "nom"
            }
        ],
        "searching": false,
        "paging": false,
        "pageLength": 10,
        "info": false,
        "deferLoading": 0,
        order: []
    });


    get_lists();

    items_table.columns().checkboxes.deselect(true);
    items_table1.columns().checkboxes.deselect(true);


    return false;
});


function get_lists() {

    if(sessionStorage.ipp==undefined){ sessionStorage.setItem("ipp",'')}

    $.ajax({
        url: "/api/listes_sorties",
        type: 'GET',
        data: {
            'ipp': sessionStorage.ipp
        }
    })

    .done(function(listes) {

        if ( listes.length == 0 ) {
            $('#div_liste_reappros').html('Aucune liste de sorties en cours.');
            return;
        }

        $('#ucd_cip_tree_div').jstree({
            'core': {
                'data' : listes.ucd_cip_list
            }
        });

        $('#ucd_cip_tree_div').on("select_node.jstree",
        function(evt, data){
            if (data.node.parents.length == 2) {
                $('#div_tableau_items').show();
                $('#list_items_titre').html(data.node.id);
                $('#div_tableau_listes').hide();
                document.getElementById('atteindre_reference').style.visibility="visible";
                items_table.ajax.url('/api/datatable/liste_sorties_items/'+data.node.text);
                items_table.draw();
                sessionStorage.setItem("liste",data.node.id)
                console.log(sessionStorage.liste)
                items_table.columns().checkboxes.deselect(true);
             } else {
                $('#div_tableau_listes').show();
                $('#div_tableau_items').hide();
                $('#list_items_titre').html(data.node.text);
                document.getElementById('atteindre_reference').style.visibility="hidden";
                items_table1.ajax.url('/api/datatable/liste_sorties_listes/'+data.node.id);
                items_table1.draw();
                items_table1.columns().checkboxes.deselect(true);
            }

        });

        $('#ucd_cip_tree_div').bind('loaded.jstree', function(e, data) {
            // invoked after jstree has loaded
            $(this).jstree("open_all");
            //$(this).jstree("select_node", data1);

            $('#ucd_cip_tree_div').jstree(true).select_node(sessionStorage.liste);

        })

    });

}


function delete_list_click() {

    var data = $("#ucd_cip_tree_div").jstree().get_selected(true)[0].parents.length;


    if (data == 1) {
        $('#modal-form-delete-list').modal('show');
    } else {
        $('#modal-form-delete-item').modal('show');
    }

}

$('#f_delete_list').submit(function(event) {

    event.preventDefault();

    data1 = $("#ucd_cip_tree_div").jstree().get_selected(true)[0].id;
    console.log(data1);

    $.each(items_table1.rows('.selected').nodes(), function(i, item) {
        var id = item.id;
        var data = items_table1.row(this).data();


        $.ajax({
            url: "/api/listes_sorties",
            type: 'DELETE',
            data: {
                pk: data.liste
            },
            success: function(product) {
                $('#delete_list_error_notif').hide(400);

                $('#modal-form-delete-list').modal('hide');

                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Une liste de sortie a été supprimée.'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });

                $('#div_tableau_items').hide();
                $('#list_items_titre').html("<< Cliquez sur une liste de sortie pour afficher les détails.");
                //get_lists();

            },
            error: function(data) {
                var msg = data.responseJSON.message;
                if ( msg != '' ) {
                    $('#delete_list_error_notif').html('<p class="mb-0">' + msg + '</p>');
                }
                else {
                    $('#delete_list_error_notif').html('<p class="mb-0">Problème lors de la suppression d une liste de sorties.</p>');
                }

                $('#delete_list_error_notif').show(400);
            }
        });

        console.log("Liste: " + data.liste);
    });


    $('#div_tableau_listes').show();
    $('#div_tableau_items').hide();
    //$('#list_items_titre').html(data.node.text);
    items_table1.ajax.url('/api/datatable/liste_sorties_listes/'+data1);
    items_table1.draw();


    $('#ucd_cip_tree_div').jstree("destroy")

    get_lists();

    items_table.columns().checkboxes.deselect(true);
    items_table1.columns().checkboxes.deselect(true);

});


$('#f_delete_item').submit(function(event) {

    event.preventDefault();

    data1 = $("#ucd_cip_tree_div").jstree().get_selected(true)[0].id;
    console.log(data1);

    $.each(items_table.rows('.selected').nodes(), function(i, item) {
        var id = item.text;
        var data = items_table.row(this).data();

        $.ajax({
            url: "/api/listes_sorties_items",
            type: 'DELETE',
            data: {
                pk: $("#ucd_cip_tree_div").jstree().get_selected(true)[0].text,
                item: data.item
            },
            success: function(product) {
                $('#delete_item_error_notif').hide(400);

                $('#modal-form-delete-item').modal('hide');

                $.notify({
                    icon: 'ni ni-check-bold',
                    'message': 'Un item de sortie a été supprimé.'
                }, {
                    'type': 'success',
                    'placement.align': 'center',
                    'delay': 3000
                });

                $('#div_tableau_items').hide();
                $('#list_items_titre').html("<< Cliquez sur une liste de sortie pour afficher les détails.");
                //get_lists();

            },
            error: function(data) {
                var msg = data.responseJSON.message;
                if ( msg != '' ) {
                    $('#delete_item_error_notif').html('<p class="mb-0">' + msg + '</p>');
                }
                else {
                    $('#delete_item_error_notif').html('<p class="mb-0">Problème lors de la suppression d un item de sorties.</p>');
                }

                $('#delete_item_error_notif').show(400);
            }
        });
    });

    $('#div_tableau_items').show();
    $('#div_tableau_listes').hide();
    items_table.ajax.url('/api/datatable/liste_sorties_items/'+$("#ucd_cip_tree_div").jstree().get_selected(true)[0].id);
    items_table.draw();


    $('#ucd_cip_tree_div').jstree("destroy")

    get_lists();

    items_table.columns().checkboxes.deselect(true);
    items_table1.columns().checkboxes.deselect(true);

});

 function atteindre_reference_click() {
    if ( ! doesTableHaveASelectedRow(items_table) ) return false;

    window.location.href = "/reference.html?" + sessionStorage.ref;
}

function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}

$('#f_sortie_perimes').submit(function(event) {

    event.preventDefault();

    var _mag = $('#modal-edit-stock-line-module-select').val();

    if (_mag == '-') {
        return
    }

    // use sessionstorage to retireve user
    var _user = $('#username').text();
    var _date = new Date().toISOString().slice(0, 10);

    $.ajax({
        url: "/api/perimes",
        type: 'GET',
        data: {
            mag: _mag,
            date_peremption: document.getElementById("myDatetime").value
        },
        beforeSend: function() {
            $('#modal-form-generate-list').modal('hide');
            // $("#overlay").modal("show");
         },
         complete: function(){
            // $("#overlay").modal("hide");
         },
        success: function(lines) {
            // store on the sessionStorage, the result.

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'La sortie de périmés a été créée.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });

            if (sessionStorage.getItem("perimes.calcul")) {
                sessionStorage.removeItem('perimes.calcul');
            }
            sessionStorage.setItem('perimes.calcul', JSON.stringify(lines));
            sessionStorage.setItem('magasin', _mag);
            sessionStorage.setItem('date_peremption', document.getElementById("myDatetime").value)
            sessionStorage.setItem('type_mag', document.getElementById('modal-edit-stock-line-module-select').options[document.getElementById('modal-edit-stock-line-module-select').selectedIndex].text);

            $('#generate_list_error_notif').hide(400);
            $('#modal-form-generate-list').modal('hide');
            // Launch
            window.location.href = "/calcul_perimes.html";
        },
        error: function (data) {
            var msg = data.responseJSON.message;
            if ( msg == '' ) {
                msg = "Problème lors de la création de la liste.";
            }

            $('#generate_list_error_notif').html('<p class="mb-0">' + msg + '</p>');
            $('#generate_list_error_notif').show(400);

        }
    });

});

$('#f_sortie_globale').submit(function(event) {

    event.preventDefault();


    // use sessionstorage to retireve user
    var _user = $('#username').text();
    var _date = new Date().toISOString().slice(0, 10);

    $.ajax({
        url: "/api/globale",
        type: 'POST',
        data: {
            service: document.getElementById("i_edit_service").value,
            ref: sessionStorage.ref,
            quantite: document.getElementById("i_edit_quantite").value,
            fraction: document.getElementById("i_edit_fraction").value
        },
        success: function(lines) {
            // store on the sessionStorage, the result.

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'La sortie globale en boîte PASS a été créée.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });

            $('#generate_list_error_notif').hide(400);
            $('#modal-form-generate-list-globale').modal('hide');

            $('#div_tableau_listes').show();
            $('#div_tableau_items').hide();
            // items_table1.ajax.url('/api/datatable/liste_sorties_listes/'+data1);
            // items_table1.draw();


            $('#ucd_cip_tree_div').jstree("destroy")

            get_lists();

            items_table.columns().checkboxes.deselect(true);
            items_table1.columns().checkboxes.deselect(true);

        },
        error: function (data) {
            var msg = data.responseJSON.message;
            if ( msg == '' ) {
                msg = "Problème lors de la création de la liste.";
            }

            $('#generate_list_error_notif').html('<p class="mb-0">' + msg + '</p>');
            $('#generate_list_error_notif').show(400);

        }
    });

});

$('#f_sortie_globale_pilulier').submit(function(event) {

    event.preventDefault();

    // use sessionstorage to retireve user
    var _user = $('#username').text();
    var _date = new Date().toISOString().slice(0, 10);

    $.ajax({
        url: "/api/globale_pilulier",
        type: 'POST',
        data: {
            service: document.getElementById("i_edit_service_pilulier").value,
            ref: sessionStorage.ref,
            quantite: document.getElementById("i_edit_quantite_pilulier").value,
            fraction: document.getElementById("i_edit_fraction_pilulier").value,
            mode: document.querySelector("input[name=custom-radio-1]:checked").value
        },
        success: function(lines) {
            // store on the sessionStorage, the result.

            $.notify({
                icon: 'ni ni-check-bold',
                'message': 'La sortie globale en pilulier a été créée.'
            }, {
                'type': 'success',
                'placement.align': 'center',
                'delay': 3000
            });

            $('#generate_list_error_notif').hide(400);
            $('#modal-form-generate-list-globale-pilulier').modal('hide');

            $('#div_tableau_listes').show();
            $('#div_tableau_items').hide();
            // items_table1.ajax.url('/api/datatable/liste_sorties_listes/'+data1);
            // items_table1.draw();


            $('#ucd_cip_tree_div').jstree("destroy")

            get_lists();

            items_table.columns().checkboxes.deselect(true);
            items_table1.columns().checkboxes.deselect(true);

        },
        error: function (data) {
            var msg = data.responseJSON.message;
            if ( msg == '' ) {
                msg = "Problème lors de la création de la liste.";
            }

            $('#generate_list_error_notif').html('<p class="mb-0">' + msg + '</p>');
            $('#generate_list_error_notif').show(400);

        }
    });

});

// chercher la liste des services
var list_of_services = $.ajax({
    url: "/api/services",
    cache: false
})
.done(function(services) {
    if (services.length > 0) {

        for ( var i = 0; i < services.length ; i++) {
            $('#i_edit_service').append(`<option value="${services[i].id}">${services[i].code_et_name}</option>`);
            $('#i_edit_service_pilulier').append(`<option value="${services[i].id}">${services[i].code_et_name}</option>`);
        }

    } else {
        $('#f_add_stock_line_adr_div').html("Une erreur s'est produite.");
        $('#f_edit_stock_line_adr_div').html("Une erreur s'est produite.");
    }
});


function disconnect_user() {
    window.location.replace('/logout');
}

$(document).ready(function () {

    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    // chercher la liste des magasins
    var mags = $.ajax({
        url: "/api/magasins",
        cache: false
    }).done(function(mags) {
            for (var i = 0; i < mags.length; i++) {
                if (mags[i].eco_type == "T" || mags[i].eco_type == "C") {
                    $('#modal-edit-stock-line-module-select').append(`<option value="${mags[i].mag}">${mags[i].type_mag}</option>`);
                }
            }

    });

    // get lists
    get_lists();

    items_table = $('#tableau_items').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "stateSave": false,
        "ajax": {
            url: '/api/datatable/liste_sorties_items/',
            type: 'POST'
        },
        "columnDefs": [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'checkboxes':{"selectRow":true}
         }],
         "select": {
            style:    'multi'
          //  selector: 'tr'
        },
        "columns": [
            {
                "data": null
            }, {
                "data": "item"
            }, {
                "data": "etat"
            }, {
                "data": "reference"
            }, {
                "data": "fraction"
            }, {
                "data": "designation"
            }, {
                "data": "qte_demandee"
            }, {
                "data": "qte_servie"
            }, {
                "data": "moment"
            }, {
                "data": "heure"
            }
        ],
        "searching": false,
        "paging": false,
        "pageLength": 10,
        "info": false,
        "deferLoading": 0,
        order: []
    });


    items_table1 = $('#tableau_listes').DataTable({
        "language": datatables_lang_fr,
        "processing": true,
        "serverSide": true,
        "stateSave": false,
        "ajax": {
            url: '/api/datatable/liste_sorties_listes/',
            type: 'POST',
            data: {
                ipp : sessionStorage.ipp
            }
        },
        "columnDefs": [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'checkboxes':{"selectRow":true}
         }],
         "select": {
            style:    'multi'
          //  selector: 'tr'
        },
        "columns": [
            {
                "data": null
             }, {
                 "data": "liste"
            }, {
                 "data": "nom"
            }
        ],
        "searching": false,
        "paging": false,
        "pageLength": 10,
        "info": false,
        "deferLoading": 0,
        order: []
    });

    // Handle click on "Select all" control
    $('#example-select-all').on('click', function(){
        // Get all rows with search applied
        var rows = items_table1.rows({ 'search': 'applied' }).nodes();
        // Check/uncheck checkboxes for all rows in the table
        $('input[type="checkbox"]', rows).prop('checked', this.checked);
    });

    // Quick search
    $('.ecodexAutoComplete1').autoComplete({
        resolverSettings: {
            url: '/api/suggestions_liste_entrees'
        },
        noResultsText: 'Aucun produit trouvé'
    });

    $('.ecodexAutoComplete1').on('autocomplete.select', function(evt, item) {

        $('#ucd_cip_tree_div').jstree("destroy")

        // ipp=item.value

        sessionStorage.setItem("ipp",item.value)

        items_table1.destroy()

        items_table1 = $('#tableau_listes').DataTable({
            "language": datatables_lang_fr,
            "processing": true,
            "serverSide": true,
            "stateSave": false,
            "ajax": {
                url: '/api/datatable/liste_sorties_listes/',
                type: 'POST',
                data: {
                    ipp: item.value
                }
            },
            "columnDefs": [{
                'targets': 0,
                'searchable': false,
                'orderable': false,
                'checkboxes':{"selectRow":true}
            }],
            "select": {
                style:    'multi'
            //  selector: 'tr'
            },
            "columns": [
                {
                    "data": null
                }, {
                    "data": "liste"
                }, {
                    "data": "nom"
                }
            ],
            "searching": false,
            "paging": false,
            "pageLength": 10,
            "info": false,
            "deferLoading": 0,
            order: []
        });


        get_lists();

        items_table.columns().checkboxes.deselect(true);
        items_table1.columns().checkboxes.deselect(true);
        // $(this).val("");
    });

   // Disable Enter Key (for AutoComplete Search Form)
   $(document).keydown(function(e){
    var key = e.charCode || e.keyCode;
    if (key == 13) {
      // enter key do nothing
      ipp=''
      $('.ecodexAutoComplete1').val('');
      sessionStorage.setItem("ipp",'');

      location.reload();


      e.preventDefault();
    }
  });


    $('#tableau_items tbody').on('click', 'tr', function () {
        var data = items_table.row( this ).data();
        sessionStorage.setItem("ref",data.reference);
        // window.location.href = "/reference.html?" + data.reference;
    });

});
