var dt_read = null;

function doesTableHaveASelectedRow(i_table) {
    var row_indexes = i_table.rows( { selected: true } )[0];

    if ( row_indexes.length == 0 ) {
        $.notify({
            icon: 'ni ni-air-baloon',
            'message': 'Aucune ligne sélectionnée!'
        }, {
            'type': 'warning',
            'placement.align': 'center',
            'delay': 3000
        });
        return false;
    }

    return true;
}

function create_list_click() {

    if ( ! doesTableHaveASelectedRow(dt_rea) ) return false;

    var compteur = $.get('/api/reappro');

    compteur.done(function( cpt ) {
        creer_reappro(cpt);
    });

}

function creer_reappro(compteur) {

    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1;

    var yyyy = today.getFullYear();
    if (dd < 10) {
        dd = '0' + dd;
    }
    if (mm < 10) {
        mm = '0' + mm;
    }
    var today = yyyy + '-' + mm + '-' + dd;

    var liste = sessionStorage.magasin + " PAR " +  sessionStorage.username + " LE " + today + " No " + compteur;

    // alert(liste);


    var res = [];
    var cpt = 0;

    $.each(dt_rea.rows('.selected').nodes(), function(i, item) {
        var data = dt_rea.row(this).data();
        cpt += 1
        res.push({"ref": data[1], "frac": data[3], "qte": data[4], "item": cpt});

    });

    console.log(res);

    $.ajax({
        url: "/api/reappro",
        method: 'POST',
        data: JSON.stringify({"lines": res, "liste": liste, "type_magasin": sessionStorage.magasin, "gpao": "1"}),
        contentType: "application/json",
        dataType: "json",
        success: function(response) {
            console.log('liste reappro: ' + response);
            window.location.href = "/reappro.html";
        }
    })
}

function annuler_click() {
    window.location.href = "/reappro.html"
}

function atteindre_reference_click() {
    window.location.href = "/reference.html?" + sessionStorage.ref;
}


$(document).ready(function () {

    $('#titre').html("Validation de la commande pour le stock " + sessionStorage.magasin);
    var user_get = $.get('/api/user');

    user_get.done(function( user ) {
        $('#username').html(user.name);
        sessionStorage.setItem('username', user.name);
    });

    user_get.fail(function() {
        window.location.replace('/logout');
    });


    /// fill the table with sessionStorage data
    var data = JSON.parse(sessionStorage.getItem('reappro.calcul'));
    var ds = [];
    var tbl = [];
    var cpt = 1;

    for (const l in data) {
        var li = data[l];
        tbl = [cpt, li.ref, li.name, li.fraction.toString(), li.quantite.toString(), li.stock.toString(), li.commande.toString(), li.stkmini.toString(), li.stkmaxi.toString()];
        ds.push(tbl);
        cpt += 1;
    }

    dt_rea = $('#tableau_items').DataTable({
        "language": datatables_lang_fr,
        // language: {
            // select: {
            //     rows: {
            //         _: "%d lignes sélectionnées",
            //         0: "Cliquer sur une ligne pour la sélectionnée",
            //         1: "1 ligne sélectionnée"
            //     }
            // }

        "data": ds,
        "autoWidth": true,
        "columns": [
            {"title": "check"},
            {"title": "reference"},
            {"title": "designation"},
            {"title": "fraction"},
            {"title": "quantité " + '<i class="fa fa-pen fa-lg"></i>',
                "className": "red"},
            {"title": "stock"},
            {"title": "commandé"},
            {"title": "stock mini"},
            {"title": "stock maxi"}
        ],
        "searching": false,
        "columnDefs": [{
            "targets": 0,
            "checkboxes": {
               "selectRow": true
            }
         }],
        "select": {
            "style": "multi"
        }
        // "paging": true,
        // "pageLength": 10,
        // "info": false,
        // "deferLoading": 0
    });

    // $('#tableau_items').on('click', 'tbody td', function () {
    //     dt_rea.cell(this).edit();
    // });
    // On passe la taille a 100%
    $('#tableau_items').css('width', '100%')
    $('#div_tableau_items').show();

    dt_rea.MakeCellsEditable({
        "onUpdate": myCallbackFunction,
        "inputCss":'my-input-class',
        "columns": [4]
    });

    $('#div_tableau_items tbody').on('click', 'tr', function () {
        var data = dt_rea.row( this ).data();
        sessionStorage.setItem("ref", data[1]);
    } );
});

function myCallbackFunction(updatedCell, updatedRow, oldValue) {
    console.log("The new value for the cell is: " + updatedCell.data());
    console.log("The old value for that cell was: " + oldValue);
    console.log("The values for each cell in that row are: " + updatedRow.data());
}
