from flask_restful import Resource, reqparse
from median.models import User, Profil
from common.models import WebMenu, WebMenuTranslation
from common.util import logger
from peewee import JOIN
from median.database import crypte

parser = reqparse.RequestParser()
parser.add_argument('pk')
parser.add_argument('profil')
parser.add_argument('ressource')
parser.add_argument('user')
parser.add_argument('password')
parser.add_argument('email')
parser.add_argument('login')
parser.add_argument('mode')
parser.add_argument('valeur')
parser.add_argument('maintenance')
parser.add_argument('stupefiant')


class ApiUsers(Resource):

    def get(self):

        args = parser.parse_args()
        v_user = args['user']
        v_password = args['password']
        v_profil = args['profil']
        v_maintenance = args['maintenance']
        v_stupefiant = args['stupefiant']

        if v_maintenance == 'false':
            v_maintenance = False
        else:
            v_maintenance = True

        if v_stupefiant == 'false':
            v_stupefiant = False
        else:
            v_stupefiant = True

        User.create(username=v_user, password=crypte(v_password), profil=v_profil, maintenance=v_maintenance,
                    droit_stupefiant=v_stupefiant)

    def post(self, id=None):
        return {'message': 'Post user is non implemented yet'}, 400

    def put(self, id=None):

        args = parser.parse_args()
        v_pk = args['pk']
        v_user = args['user']
        v_password = args['password']
        v_profil = args['profil']
        v_email = args['email']
        v_maintenance = args['maintenance']
        v_stupefiant = args['stupefiant']

        if v_maintenance == 'false':
            v_maintenance = False
        else:
            v_maintenance = True

        if v_stupefiant == 'false':
            v_stupefiant = False
        else:
            v_stupefiant = True

        User.update(username=v_user, password=crypte(v_password), profil=v_profil, maintenance=v_maintenance,
                    droit_stupefiant=v_stupefiant, email=v_email).where(User.pk == v_pk).execute()

    def delete(self, id=None):

        args = parser.parse_args()
        v_pk = args['pk']

        User.delete().where(User.pk == v_pk).execute()


class ApiProfil(Resource):

    def get(self):

        logger.info("Récupérer les profils utilisateurs")
        # TODO: Utiliser f_resrc qui est utilisé pour lister les droits, au lieu du distinct qui peut en oublier
        paged_profils = (Profil.select(Profil.profil).distinct())

        return ([{
            'profil': i.profil
        } for i in paged_profils])

    def post(self):
        args = parser.parse_args()
        v_profil = args['profil']

        exist_profil = (Profil.select(Profil.profil).distinct().where(Profil.profil == v_profil))

        if len(exist_profil) > 0:
            return "Groupe déjà existant", 400
        else:
            Profil.create(profil=v_profil, ressource="WEB_PRODUIT")
            return "ok"


class ApiMenu(Resource):

    def get(self):

        args = parser.parse_args()
        v_profil = args['profil']

        logger.info("Récupérer les menus du profil sélectionné")

        paged_profils = (WebMenu.select(
            WebMenu.pk, WebMenu.code, WebMenu.name, WebMenuTranslation.tr_name, Profil.visu, Profil.edit)
            .join(WebMenuTranslation, JOIN.LEFT_OUTER, on=(WebMenuTranslation.menu_id == WebMenu.pk))
            .switch(WebMenu)
            .join(Profil, JOIN.LEFT_OUTER, on=((Profil.ressource == WebMenu.code) & (Profil.profil == v_profil)))
            .order_by(WebMenu.sequence, WebMenu.parent))

        # pdb.set_trace()

        return ([{
            'profil': i.code,
            'profil_bis': i.code + "_bis",
            'nom_profil': (i.webmenutranslation.tr_name if hasattr(i, 'webmenutranslation') else i.name),
            'visu': (i.profil.visu if hasattr(i, 'profil') else 0),
            'edit': (i.profil.edit if hasattr(i, 'profil') else 0)
        } for i in paged_profils])

    def post(self):

        args = parser.parse_args()
        v_profil = args['profil']
        v_ressource = args['ressource']
        v_mode = args['mode']
        v_valeur = args['valeur']

        exist_profil = Profil.select(Profil.pk).where((Profil.profil == v_profil) & (Profil.ressource == v_ressource))

        if len(exist_profil) == 0:
            if v_mode == "visu":
                Profil.create(profil=v_profil, ressource=v_ressource, visu=v_valeur)
            else:
                Profil.create(profil=v_profil, ressource=v_ressource, edit=v_valeur)
        else:
            if v_mode == "visu":
                Profil.update(visu=v_valeur).where(Profil.pk == exist_profil[0].pk).execute()
            else:
                Profil.update(edit=v_valeur).where(Profil.pk == exist_profil[0].pk).execute()

        pro = Profil.select(
            Profil.visu, Profil.edit).where((Profil.profil == v_profil) & (Profil.ressource == v_ressource))

        if (pro[0].visu == 0) & (pro[0].edit == 0):
            Profil.delete().where((Profil.profil == v_profil) & (Profil.ressource == v_ressource)).execute()

    def delete(self):

        args = parser.parse_args()
        v_profil = args['profil']
        v_ressource = args['ressource']

        Profil.delete().where((Profil.profil == v_profil) & (Profil.ressource == v_ressource)).execute()
