from flask import abort, session
from flask_restful import Resource
from median.models import User, Profil
from peewee import DoesNotExist
import logging

logger = logging.getLogger('median.webserver')


class ApiUser(Resource):

    def _check_auth(self, ressource=None):
        """Check auth, return information if ok, otherwise 404"""
        if session.get('user_id', 0) == 0:
            abort(401)

        try:
            usr = User.get(pk=session['user_id'])
            logger.info('User logged in. id: %s, name: %s, profil: %s' % (usr.pk, usr.username, usr.profil))

        except DoesNotExist:
            logger.error('User does not exist')
            return {'message': 'User does not exist'}, 404

        pro = Profil.select(
            Profil.visu, Profil.edit
            ).where((Profil.profil == usr.profil) & (Profil.ressource == ressource))

        # Réécrire en utilisant usr.to_json() après mise a dispo dans la librairie Median
        return {
            'id': usr.pk,
            'name': usr.username,
            'profil': usr.profil,
            'desc': usr.description,
            'login': usr.login,
            'service': usr.service,
            'badge': usr.badge,
            'inventaire': usr.droit_inventaire,
            'stupefiant': usr.droit_stupefiant,
            'visu': (0 if len(pro) == 0 else pro[0].visu),
            'edit': (0 if len(pro) == 0 else pro[0].edit),
            'maintenance': usr.maintenance,
            'email': usr.email,
            'lang': usr.lang,
        }

    def get(self, ressource=None):
        return self._check_auth(ressource)

    def post(self, ressource=None):
        return {'message': 'Create user is non implemented yet'}, 400

    def put(self, ressource=None):
        return {'message': 'Update user is non implemented yet'}, 400

    def delete(self, ressource=None):
        return {'message': 'Delete user is non implemented yet'}, 400
