from flask_restful import Resource, reqparse
from median.models import Patient_Histo
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('q')


class ApiSuggestions_Patient(Resource):

    def get(self):
        args = parser.parse_args()
        v_search_text = args['q'].replace(' ', '%')

        try:

            patient = (Patient_Histo.select(
                Patient_Histo.nom, Patient_Histo.prenom)
                .where(Patient_Histo.nom.contains(v_search_text) | Patient_Histo.prenom.contains(v_search_text)))

            return ([{
                'value': p.nom + ' ' + p.prenom,
                'text': p.nom + ' ' + p.prenom
            } for p in patient])

        except Exception as error:
            return {'message': error.args}, 400
