from flask_restful import Resource, reqparse
from median.models import FListe, Patient
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('q')


class ApiSuggestions_Liste_Entrees(Resource):

    def get(self):
        args = parser.parse_args()
        v_search_text = args['q'].replace(' ', '%')

        try:
            products = (FListe.select(FListe.ipp, Patient.nom, Patient.prenom).join(Patient, on=(
                FListe.ipp == Patient.ipp).alias('scan_obj')).distinct()
                        .where(FListe.ipp.contains(v_search_text) |
                               Patient.nom.contains(v_search_text) |
                               Patient.prenom.contains(v_search_text)))

            if products.count() > 0:
                logger.info('Lines : %s.' % len(products))
                return ([{
                    'value': p.ipp,
                    'text': p.ipp + ' / ' + p.scan_obj.nom + ' ' + p.scan_obj.prenom
                } for p in products])

        except Exception as error:
            return {'message': error.args}, 400
