from flask_restful import Resource, reqparse
from median.models import Product, Ucd, Cip
import logging

logger = logging.getLogger('median.webserver')

parser = reqparse.RequestParser()
parser.add_argument('q')


class ApiSuggestions(Resource):

    def get(self):
        args = parser.parse_args()
        v_search_text = args['q'].replace(' ', '%')

        try:
            products = (Product.select(Product.reference, Product.ucd, Product.designation)
                        .where(Product.reference.contains(v_search_text) |
                               Product.designation.contains(v_search_text) |
                               Product.ucd.contains(v_search_text)))

            if products.count() > 0:
                logger.info('Lines : %s.' % len(products))
                return ([{
                    'value': p.reference,
                    'text': '[ ' + p.reference + ' / ' + p.ucd + ' ] ' + p.designation,
                    'designation': p.designation
                } for p in products])

            # si on ne trouve rien, on va chercher sur l'ucd, dans f_ref_ucd
            else:
                products = (Ucd.select(Ucd.reference, Ucd.ucd)
                            .where(Ucd.ucd.contains(v_search_text)))
                if products.count() > 0:
                    logger.info('Lines : %s.' % len(products))
                    return ([{
                        'value': p.reference,
                        'text': '[ ' + p.reference + ' / ' + p.ucd + ' ] '
                    } for p in products])

                # si on ne trouve rien, on va chercher sur le cip, dans f_ucd_cip
                else:
                    products = (Cip.select(Cip.cip, Cip.ucd).distinct()
                                .join(Ucd, on=(Ucd.ucd == Cip.ucd))
                                .where(Cip.cip.contains(v_search_text)))
                    if products.count() > 0:
                        logger.info('Lines : %s.' % len(products))
                        return ([{
                            'value': (Ucd.select(Ucd.reference).where(Ucd.ucd == p.ucd))[0].reference,
                            'text': p.cip + ' / ' + p.ucd
                        } for p in products])

        except Exception as error:
            return {'message': error.args}, 400
